/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.jpa.criteria.PersistentAssociationPath;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityJoinSupport;
import io.micronaut.data.model.jpa.criteria.impl.DefaultEmbeddedPersistentPropertyPath;
import io.micronaut.data.processor.model.SourceAssociation;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.impl.SourceEmbeddedPersistentPropertyPathImpl;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentAssociationPath;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentPropertyPath;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentPropertyPathImpl;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Path;
import java.util.ArrayList;
import java.util.List;

@Internal
abstract class AbstractSourcePersistentEntityJoinSupport<T, E>
extends AbstractPersistentEntityJoinSupport<T, E> {
    protected final CriteriaBuilder criteriaBuilder;

    AbstractSourcePersistentEntityJoinSupport(CriteriaBuilder criteriaBuilder) {
        this.criteriaBuilder = criteriaBuilder;
    }

    protected abstract List<Association> getCurrentPath();

    public abstract SourcePersistentEntity getPersistentEntity();

    public <Y> SourcePersistentPropertyPath<Y> get(String attributeName) {
        SourcePersistentProperty property = this.getPersistentEntity().getPropertyByNameIgnoreCase(attributeName);
        if (property == null) {
            throw new IllegalStateException("Cannot query entity [" + this.getPersistentEntity().getSimpleName() + "] on non-existent property: " + attributeName);
        }
        return AbstractSourcePersistentEntityJoinSupport.asPropertyPath(this, property, this.criteriaBuilder);
    }

    private static <Y> SourcePersistentPropertyPath<Y> asPropertyPath(Path<?> parentPath, @NonNull SourcePersistentProperty property, CriteriaBuilder criteriaBuilder) {
        SourceAssociation sourceAssociation;
        ArrayList<Association> associations;
        if (parentPath instanceof PersistentAssociationPath) {
            PersistentAssociationPath associationPath = (PersistentAssociationPath)parentPath;
            List pathAssociations = associationPath.getAssociations();
            associations = new ArrayList<Association>(pathAssociations.size() + 1);
            associations.addAll(pathAssociations);
            associations.add(associationPath.getAssociation());
        } else if (parentPath instanceof DefaultEmbeddedPersistentPropertyPath) {
            DefaultEmbeddedPersistentPropertyPath embedded = (DefaultEmbeddedPersistentPropertyPath)parentPath;
            associations = CollectionUtils.concat((List)embedded.getAssociations(), (Object)embedded.getProperty());
        } else {
            associations = List.of();
        }
        if (property instanceof SourceAssociation && (sourceAssociation = (SourceAssociation)property).isEmbedded()) {
            return new SourceEmbeddedPersistentPropertyPathImpl(parentPath, associations, sourceAssociation, (path, persistentProperty) -> AbstractSourcePersistentEntityJoinSupport.asPropertyPath(path, (SourcePersistentProperty)persistentProperty, criteriaBuilder));
        }
        return new SourcePersistentPropertyPathImpl(parentPath, associations, property, criteriaBuilder);
    }

    protected <Y> PersistentAssociationPath<E, Y> createJoinAssociation(Association association, Join.Type associationJoinType, String alias) {
        return new SourcePersistentAssociationPath(this, (SourceAssociation)association, this.getCurrentPath(), associationJoinType, alias, this.criteriaBuilder);
    }
}

