/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractMethodMatcher;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.MethodNameParser;
import io.micronaut.data.processor.visitors.finders.QueryMatchId;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.data.processor.visitors.finders.criteria.QueryCriteriaMethodMatch;
import java.util.List;

@Internal
public final class CountMethodMatcher
extends AbstractMethodMatcher {
    public CountMethodMatcher() {
        super(MethodNameParser.builder().match(QueryMatchId.PREFIX, "count").tryMatch(QueryMatchId.ALL, ALL).tryMatch(QueryMatchId.DISTINCT, "Distinct").tryMatchFirstOccurrencePrefixed(QueryMatchId.PREDICATE, "By").takeRest(QueryMatchId.PROJECTION).build());
    }

    @Override
    protected MethodMatcher.MethodMatch match(MethodMatchContext matchContext, List<MethodNameParser.Match> matches) {
        if (TypeUtils.isValidCountReturnType(matchContext)) {
            return new QueryCriteriaMethodMatch(matches){

                @Override
                protected PersistentEntityCriteriaQuery<Object> createQuery(MethodMatchContext matchContext, PersistentEntityCriteriaBuilder cb, List<AnnotationValue<Join>> joinSpecs) {
                    return super.createDefaultCountQuery(matchContext, cb, joinSpecs);
                }

                @Override
                protected FindersUtils.InterceptorMatch resolveReturnTypeAndInterceptor(MethodMatchContext matchContext) {
                    return FindersUtils.pickCountInterceptor(matchContext, matchContext.getReturnType());
                }

                @Override
                protected DataMethod.OperationType getOperationType() {
                    return DataMethod.OperationType.COUNT;
                }
            };
        }
        return null;
    }
}

