/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.jdql;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.annotation.OrderBy;
import io.micronaut.data.jdql.JDQLBaseListener;
import io.micronaut.data.jdql.JDQLLexer;
import io.micronaut.data.jdql.JDQLParser;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCommonAbstractCriteria;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaDelete;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaUpdate;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaBuilder;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaUpdate;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

@Internal
public final class JDQLCriteriaBuilderUtils {
    private JDQLCriteriaBuilderUtils() {
    }

    public static PersistentEntityCommonAbstractCriteria build(String query, PersistentEntity rootPersistentEntity, MethodElement methodElement, Function<String, ClassElement> classElementResolver, SourcePersistentEntityCriteriaBuilder criteriaBuilder) {
        ParseTree child = JDQLCriteriaBuilderUtils.parse(query, (Element)methodElement);
        if (child instanceof JDQLParser.Delete_statementContext) {
            JDQLParser.Delete_statementContext deleteStatementContext = (JDQLParser.Delete_statementContext)child;
            return JDQLCriteriaBuilderUtils.buildDelete(deleteStatementContext, classElementResolver, criteriaBuilder);
        }
        if (child instanceof JDQLParser.Update_statementContext) {
            JDQLParser.Update_statementContext updateStatementContext = (JDQLParser.Update_statementContext)child;
            return JDQLCriteriaBuilderUtils.buildUpdate(updateStatementContext, classElementResolver, criteriaBuilder);
        }
        if (child instanceof JDQLParser.Select_statementContext) {
            JDQLParser.Select_statementContext select_clauseContext = (JDQLParser.Select_statementContext)child;
            return JDQLCriteriaBuilderUtils.buildSelect(rootPersistentEntity, select_clauseContext, classElementResolver, criteriaBuilder, methodElement);
        }
        throw new MatchFailedException("Unrecognized query: " + String.valueOf(child.getParent()), (Element)methodElement);
    }

    public static PersistentEntityCriteriaQuery<?> buildCount(String query, PersistentEntity rootPersistentEntity, MethodElement methodElement, Function<String, ClassElement> classElementResolver, SourcePersistentEntityCriteriaBuilder criteriaBuilder) {
        ParseTree child = JDQLCriteriaBuilderUtils.parse(query, (Element)methodElement);
        if (child instanceof JDQLParser.Select_statementContext) {
            JDQLParser.Select_statementContext select_clauseContext = (JDQLParser.Select_statementContext)child;
            return JDQLCriteriaBuilderUtils.buildCount(rootPersistentEntity, select_clauseContext, classElementResolver, criteriaBuilder);
        }
        throw new MatchFailedException("Unrecognized count query: " + String.valueOf(child.getParent()), (Element)methodElement);
    }

    private static ParseTree parse(final String query, final Element originatingElement) {
        CodePointCharStream inputStream = CharStreams.fromString((String)query);
        JDQLLexer lexer = new JDQLLexer((CharStream)inputStream);
        ANTLRErrorListener errorListener = new ANTLRErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new MatchFailedException("Failed to parse Jakarta Data query: " + JDQLCriteriaBuilderUtils.prettifyAntlrError(offendingSymbol, line, charPositionInLine, msg, e, query), originatingElement);
            }

            public void reportAmbiguity(Parser parser, DFA dfa, int i, int i1, boolean b, BitSet bitSet, ATNConfigSet atnConfigSet) {
            }

            public void reportAttemptingFullContext(Parser parser, DFA dfa, int i, int i1, BitSet bitSet, ATNConfigSet atnConfigSet) {
            }

            public void reportContextSensitivity(Parser parser, DFA dfa, int i, int i1, int i2, ATNConfigSet atnConfigSet) {
            }
        };
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        JDQLParser parser = new JDQLParser((TokenStream)tokenStream);
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        lexer.addErrorListener(errorListener);
        parser.addErrorListener(errorListener);
        JDQLParser.StatementContext statement = parser.statement();
        return statement.getChild(0);
    }

    private static String prettifyAntlrError(Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e, String query) {
        CommonToken commonToken;
        String token;
        String errorText = "At " + line + ":" + charPositionInLine;
        if (offendingSymbol instanceof CommonToken && (token = (commonToken = (CommonToken)offendingSymbol).getText()) != null && !token.isEmpty()) {
            errorText = errorText + " and token '" + token + "'";
        }
        errorText = errorText + ", ";
        if (e instanceof NoViableAltException) {
            errorText = errorText + message.substring(0, message.indexOf(39));
            if (query.isEmpty()) {
                errorText = errorText + "'*' (empty query string)";
            } else {
                String lineText = query.lines().toList().get(line - 1);
                String text = lineText.substring(0, charPositionInLine) + "*" + lineText.substring(charPositionInLine);
                errorText = errorText + "'" + text + "'";
            }
        } else {
            errorText = e instanceof InputMismatchException ? errorText + message.substring(0, message.length() - 1).replace(" expecting {", ", expecting one of the following tokens: ") : errorText + message;
        }
        return errorText;
    }

    public static PersistentEntityCriteriaQuery<?> buildSelect(PersistentEntity rootPersistentEntity, JDQLParser.Select_statementContext selectStatementContext, Function<String, ClassElement> classElementResolver, SourcePersistentEntityCriteriaBuilder criteriaBuilder, MethodElement methodElement) {
        PersistentEntityRoot root;
        PersistentEntityCriteriaQuery query = criteriaBuilder.createQuery((Class)null);
        JDQLParser.From_clauseContext fromClauseContext = selectStatementContext.from_clause();
        if (fromClauseContext != null) {
            String entityName = fromClauseContext.entity_name().getText();
            root = query.from(classElementResolver.apply(entityName));
        } else {
            root = query.from(rootPersistentEntity);
        }
        Predicate predicate = JDQLCriteriaBuilderUtils.getPredicate(selectStatementContext.where_clause(), root, (PersistentEntityCriteriaBuilder)criteriaBuilder);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
        query.orderBy(JDQLCriteriaBuilderUtils.getOrders(selectStatementContext.orderby_clause(), root, criteriaBuilder, methodElement));
        JDQLParser.Select_clauseContext selectClauseContext = selectStatementContext.select_clause();
        if (selectClauseContext != null) {
            JDQLParser.Select_listContext selectList = selectClauseContext.select_list();
            JDQLParser.Aggregate_expressionContext aggregateExpression = selectList.aggregate_expression();
            if (aggregateExpression != null) {
                query.select((Selection)criteriaBuilder.count((Expression)root));
            } else {
                query.multiselect(selectList.state_field_path_expression().stream().map(s -> JDQLCriteriaBuilderUtils.getExpression(s, root, (CriteriaBuilder)criteriaBuilder)).toList());
            }
        }
        return query;
    }

    public static PersistentEntityCriteriaQuery<?> buildCount(PersistentEntity rootPersistentEntity, JDQLParser.Select_statementContext selectStatementContext, Function<String, ClassElement> classElementResolver, SourcePersistentEntityCriteriaBuilder criteriaBuilder) {
        PersistentEntityRoot root;
        PersistentEntityCriteriaQuery query = criteriaBuilder.createQuery((Class)null);
        JDQLParser.From_clauseContext fromClauseContext = selectStatementContext.from_clause();
        if (fromClauseContext != null) {
            String entityName = fromClauseContext.entity_name().getText();
            root = query.from(classElementResolver.apply(entityName));
        } else {
            root = query.from(rootPersistentEntity);
        }
        Predicate predicate = JDQLCriteriaBuilderUtils.getPredicate(selectStatementContext.where_clause(), root, (PersistentEntityCriteriaBuilder)criteriaBuilder);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
        query.select((Selection)criteriaBuilder.count((Expression)root));
        return query;
    }

    public static PersistentEntityCriteriaUpdate<?> buildUpdate(JDQLParser.Update_statementContext updateStatementContext, Function<String, ClassElement> classElementResolver, final SourcePersistentEntityCriteriaBuilder criteriaBuilder) {
        PersistentEntityCriteriaUpdate updateQuery;
        PersistentEntityRoot root;
        String entityName = updateStatementContext.entity_name().getText();
        JDQLParser.Where_clauseContext whereClauseContext = updateStatementContext.where_clause();
        Predicate predicate = JDQLCriteriaBuilderUtils.getPredicate(whereClauseContext, root = (updateQuery = criteriaBuilder.createCriteriaUpdate((Class)null)).from(classElementResolver.apply(entityName)), (PersistentEntityCriteriaBuilder)criteriaBuilder);
        if (predicate != null) {
            updateQuery.where((Expression)predicate);
        }
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)new JDQLBaseListener((SourcePersistentEntityCriteriaUpdate)updateQuery){
            final /* synthetic */ SourcePersistentEntityCriteriaUpdate val$updateQuery;
            {
                this.val$updateQuery = sourcePersistentEntityCriteriaUpdate;
            }

            @Override
            public void exitUpdate_item(JDQLParser.Update_itemContext ctx) {
                String name = ctx.state_field_path_expression().getText();
                Expression<?> expression = JDQLCriteriaBuilderUtils.getExpression(ctx.scalar_expression(), root, (CriteriaBuilder)criteriaBuilder);
                this.val$updateQuery.set(name, expression);
            }
        }, (ParseTree)updateStatementContext);
        return updateQuery;
    }

    public static PersistentEntityCriteriaDelete<?> buildDelete(JDQLParser.Delete_statementContext deleteStatementContext, Function<String, ClassElement> classElementResolver, SourcePersistentEntityCriteriaBuilder criteriaBuilder) {
        PersistentEntityCriteriaDelete deleteQuery;
        PersistentEntityRoot root;
        JDQLParser.From_clauseContext fromClauseContext = deleteStatementContext.from_clause();
        String entityName = fromClauseContext.entity_name().getText();
        JDQLParser.Where_clauseContext whereClauseContext = deleteStatementContext.where_clause();
        Predicate predicate = JDQLCriteriaBuilderUtils.getPredicate(whereClauseContext, root = (deleteQuery = criteriaBuilder.createCriteriaDelete((Class)null)).from(classElementResolver.apply(entityName)), (PersistentEntityCriteriaBuilder)criteriaBuilder);
        if (predicate != null) {
            deleteQuery.where((Expression)predicate);
        }
        return deleteQuery;
    }

    private static Predicate getPredicate(@Nullable JDQLParser.Where_clauseContext whereClause, Root<?> root, PersistentEntityCriteriaBuilder criteriaBuilder) {
        if (whereClause == null) {
            return null;
        }
        JDQLParser.Conditional_expressionContext conditionalExpression = whereClause.conditional_expression();
        return JDQLCriteriaBuilderUtils.getPredicate(conditionalExpression, root, criteriaBuilder);
    }

    private static List<Order> getOrders(@Nullable JDQLParser.Orderby_clauseContext orderByClause, Root<?> root, PersistentEntityCriteriaBuilder criteriaBuilder, MethodElement methodElement) {
        ArrayList<Order> orders = new ArrayList<Order>();
        if (orderByClause != null) {
            List<JDQLParser.Orderby_itemContext> orderbyItemContexts = orderByClause.orderby_item();
            for (JDQLParser.Orderby_itemContext orderbyItemContext : orderbyItemContexts) {
                Expression<?> expression = JDQLCriteriaBuilderUtils.getExpression(orderbyItemContext.state_field_path_expression(), root, (CriteriaBuilder)criteriaBuilder);
                orders.add(orderbyItemContext.DESC() == null ? criteriaBuilder.asc(expression) : criteriaBuilder.desc(expression));
            }
        }
        if (methodElement != null) {
            for (AnnotationValue av : methodElement.getAnnotationValuesByStereotype(OrderBy.class.getName())) {
                orders.add(criteriaBuilder.sort((Expression)root.get((String)av.stringValue().orElseThrow()), av.booleanValue("descending").orElse(false) == false, av.booleanValue("ignoreCase").orElse(false).booleanValue()));
            }
        }
        return orders;
    }

    private static Predicate getPredicate(JDQLParser.Conditional_expressionContext conditionalExpression, Root<?> root, PersistentEntityCriteriaBuilder criteriaBuilder) {
        if (conditionalExpression.LPAREN() != null) {
            return JDQLCriteriaBuilderUtils.getPredicate(conditionalExpression.conditional_expression(0), root, criteriaBuilder);
        }
        if (conditionalExpression.AND() != null) {
            return criteriaBuilder.and((Expression)JDQLCriteriaBuilderUtils.getPredicate(conditionalExpression.conditional_expression(0), root, criteriaBuilder), (Expression)JDQLCriteriaBuilderUtils.getPredicate(conditionalExpression.conditional_expression(1), root, criteriaBuilder));
        }
        if (conditionalExpression.OR() != null) {
            return criteriaBuilder.or((Expression)JDQLCriteriaBuilderUtils.getPredicate(conditionalExpression.conditional_expression(0), root, criteriaBuilder), (Expression)JDQLCriteriaBuilderUtils.getPredicate(conditionalExpression.conditional_expression(1), root, criteriaBuilder));
        }
        if (conditionalExpression.NOT() != null) {
            return criteriaBuilder.not((Expression)JDQLCriteriaBuilderUtils.getPredicate(conditionalExpression.conditional_expression(0), root, criteriaBuilder));
        }
        JDQLParser.Comparison_expressionContext comparisonExpression = conditionalExpression.comparison_expression();
        if (comparisonExpression != null) {
            Expression<?> firstExp = JDQLCriteriaBuilderUtils.getExpression(comparisonExpression.scalar_expression(0), root, (CriteriaBuilder)criteriaBuilder);
            Expression<?> secondExp = JDQLCriteriaBuilderUtils.getExpression(comparisonExpression.scalar_expression(1), root, (CriteriaBuilder)criteriaBuilder);
            JDQLParser.Comparison_operatorContext comparisonOperator = comparisonExpression.comparison_operator();
            if (comparisonOperator.EQ() != null) {
                return criteriaBuilder.equal(firstExp, secondExp);
            }
            if (comparisonOperator.NEQ() != null) {
                return criteriaBuilder.notEqual(firstExp, secondExp);
            }
            if (comparisonOperator.GT() != null) {
                return criteriaBuilder.greaterThan(firstExp, secondExp);
            }
            if (comparisonOperator.GTEQ() != null) {
                return criteriaBuilder.greaterThanOrEqualTo(firstExp, secondExp);
            }
            if (comparisonOperator.LT() != null) {
                return criteriaBuilder.lessThan(firstExp, secondExp);
            }
            if (comparisonOperator.LTEQ() != null) {
                return criteriaBuilder.lessThanOrEqualTo(firstExp, secondExp);
            }
            throw new IllegalStateException("Unsupported comparison operator: " + String.valueOf((Object)comparisonOperator));
        }
        JDQLParser.Like_expressionContext likeExpression = conditionalExpression.like_expression();
        if (likeExpression != null) {
            Expression pattern = likeExpression.STRING() != null ? criteriaBuilder.literal((Object)JDQLCriteriaBuilderUtils.getString(likeExpression.getChild(likeExpression.getChildCount() - 1).getText())) : JDQLCriteriaBuilderUtils.getExpression(likeExpression.input_parameter(), (CriteriaBuilder)criteriaBuilder);
            Expression<?> expression = JDQLCriteriaBuilderUtils.getExpression(likeExpression.scalar_expression(), root, (CriteriaBuilder)criteriaBuilder);
            if (likeExpression.NOT() != null) {
                return criteriaBuilder.notLike(expression, pattern);
            }
            return criteriaBuilder.like(expression, pattern);
        }
        JDQLParser.In_expressionContext inExpression = conditionalExpression.in_expression();
        if (inExpression != null) {
            Expression<?> expression = JDQLCriteriaBuilderUtils.getExpression(inExpression.state_field_path_expression(), root, (CriteriaBuilder)criteriaBuilder);
            CriteriaBuilder.In in = criteriaBuilder.in(expression);
            for (JDQLParser.In_itemContext item : inExpression.in_item()) {
                Expression<?> e = JDQLCriteriaBuilderUtils.getExpression(item, (CriteriaBuilder)criteriaBuilder);
                in.value(e);
            }
            if (inExpression.NOT() != null) {
                return in.not();
            }
            return in;
        }
        JDQLParser.Between_expressionContext betweenExpression = conditionalExpression.between_expression();
        if (betweenExpression != null) {
            Predicate between = criteriaBuilder.between(JDQLCriteriaBuilderUtils.getExpression(betweenExpression.scalar_expression(0), root, (CriteriaBuilder)criteriaBuilder), JDQLCriteriaBuilderUtils.getExpression(betweenExpression.scalar_expression(1), root, (CriteriaBuilder)criteriaBuilder), JDQLCriteriaBuilderUtils.getExpression(betweenExpression.scalar_expression(2), root, (CriteriaBuilder)criteriaBuilder));
            if (betweenExpression.NOT() != null) {
                return between.not();
            }
            return between;
        }
        JDQLParser.Null_comparison_expressionContext nullComparisonExpression = conditionalExpression.null_comparison_expression();
        if (nullComparisonExpression != null) {
            Expression<?> expression = JDQLCriteriaBuilderUtils.getExpression(nullComparisonExpression.state_field_path_expression(), root, (CriteriaBuilder)criteriaBuilder);
            if (nullComparisonExpression.NOT() != null) {
                return criteriaBuilder.isNotNull(expression);
            }
            return criteriaBuilder.isNull(expression);
        }
        throw new IllegalStateException("Unsupported conditional expression: " + String.valueOf((Object)conditionalExpression));
    }

    private static String getString(String text) {
        return text.substring(1, text.length() - 1);
    }

    private static Expression<?> getExpression(JDQLParser.Scalar_expressionContext scalarExpression, Root<?> root, CriteriaBuilder criteriaBuilder) {
        JDQLParser.Primary_expressionContext primaryExpression = scalarExpression.primary_expression();
        if (primaryExpression != null) {
            return JDQLCriteriaBuilderUtils.getExpression(primaryExpression, root, criteriaBuilder);
        }
        Expression<?> firstExp = JDQLCriteriaBuilderUtils.getExpression(Objects.requireNonNull((JDQLParser.Scalar_expressionContext)scalarExpression.getChild(0), "First expression cannot be null"), root, criteriaBuilder);
        Expression<?> secondExp = JDQLCriteriaBuilderUtils.getExpression(Objects.requireNonNull((JDQLParser.Scalar_expressionContext)scalarExpression.getChild(2), "First expression cannot be null"), root, criteriaBuilder);
        if (scalarExpression.PLUS() != null) {
            return criteriaBuilder.sum(firstExp, secondExp);
        }
        if (scalarExpression.MINUS() != null) {
            return criteriaBuilder.diff(firstExp, secondExp);
        }
        if (scalarExpression.CONCAT() != null) {
            return criteriaBuilder.concat(firstExp, secondExp);
        }
        if (scalarExpression.MUL() != null) {
            return criteriaBuilder.prod(firstExp, secondExp);
        }
        if (scalarExpression.DIV() != null) {
            return criteriaBuilder.quot(firstExp, secondExp);
        }
        throw new IllegalStateException("Unknown primary expression");
    }

    private static Expression<?> getExpression(JDQLParser.Primary_expressionContext context, Root<?> root, CriteriaBuilder criteriaBuilder) {
        if (context.literal() != null) {
            return JDQLCriteriaBuilderUtils.getExpression(context.literal(), criteriaBuilder);
        }
        if (context.input_parameter() != null) {
            return JDQLCriteriaBuilderUtils.getExpression(context.input_parameter(), criteriaBuilder);
        }
        if (context.special_expression() != null) {
            String specialExpression = context.special_expression().getText();
            return switch (specialExpression.toUpperCase(Locale.US)) {
                case "TRUE" -> criteriaBuilder.literal((Object)true);
                case "FALSE" -> criteriaBuilder.literal((Object)false);
                default -> throw new UnsupportedOperationException("Unsupported special expression: " + specialExpression);
            };
        }
        if (context.enum_literal() != null) {
            return JDQLCriteriaBuilderUtils.getExpression(context.enum_literal());
        }
        if (context.state_field_path_expression() != null) {
            JDQLParser.State_field_path_expressionContext stateContext = context.state_field_path_expression();
            return JDQLCriteriaBuilderUtils.getExpression(stateContext, root, criteriaBuilder);
        }
        JDQLParser.Function_expressionContext functionExpression = context.function_expression();
        if (functionExpression != null) {
            String functionName;
            SourcePersistentEntityCriteriaBuilder sourcePersistentEntityCriteriaBuilder = (SourcePersistentEntityCriteriaBuilder)criteriaBuilder;
            Expression<?> expression = JDQLCriteriaBuilderUtils.getExpression(functionExpression.scalar_expression(0), root, criteriaBuilder);
            return switch (functionName = functionExpression.getChild(0).getText().toLowerCase()) {
                case "abs(" -> criteriaBuilder.abs(expression);
                case "length(" -> criteriaBuilder.length(expression);
                case "lower(" -> criteriaBuilder.lower(expression);
                case "upper(" -> criteriaBuilder.upper(expression);
                case "left(" -> sourcePersistentEntityCriteriaBuilder.startsWithString(expression, JDQLCriteriaBuilderUtils.getExpression(functionExpression.scalar_expression(1), root, criteriaBuilder));
                case "right(" -> sourcePersistentEntityCriteriaBuilder.endingWithString(expression, JDQLCriteriaBuilderUtils.getExpression(functionExpression.scalar_expression(1), root, criteriaBuilder));
                default -> throw new UnsupportedOperationException("Unsupported function expression: " + functionName);
            };
        }
        throw new UnsupportedOperationException("Not supported expression: " + context.getText());
    }

    private static Expression<?> getExpression(JDQLParser.Enum_literalContext enumLiteralContext) {
        throw new UnsupportedOperationException("Unsupported enum: " + String.valueOf((Object)enumLiteralContext));
    }

    private static Expression<? extends Serializable> getExpression(JDQLParser.LiteralContext literal, CriteriaBuilder criteriaBuilder) {
        if (literal.STRING() != null) {
            return criteriaBuilder.literal((Object)JDQLCriteriaBuilderUtils.getString(literal.STRING().getText()));
        }
        if (literal.INTEGER() != null) {
            return criteriaBuilder.literal((Object)Integer.valueOf(literal.INTEGER().getText()));
        }
        if (literal.DOUBLE() != null) {
            return criteriaBuilder.literal((Object)Double.valueOf(literal.DOUBLE().getText()));
        }
        if (literal.FLOAT() != null) {
            return criteriaBuilder.literal((Object)Float.valueOf(literal.FLOAT().getText()));
        }
        throw new IllegalStateException("Unknown literal parameter: " + String.valueOf((Object)literal));
    }

    private static Expression<?> getExpression(JDQLParser.State_field_path_expressionContext stateFieldPathExpression, Root<?> root, CriteriaBuilder criteriaBuilder) {
        String text = stateFieldPathExpression.getText();
        if (stateFieldPathExpression.FULLY_QUALIFIED_IDENTIFIER() != null) {
            return criteriaBuilder.literal((Object)text);
        }
        return root.get(text);
    }

    private static Expression<?> getExpression(JDQLParser.Input_parameterContext inputParameter, CriteriaBuilder criteriaBuilder) {
        SourcePersistentEntityCriteriaBuilder sourcePersistentEntityCriteriaBuilder = (SourcePersistentEntityCriteriaBuilder)criteriaBuilder;
        String text = inputParameter.getChild(0).getText();
        if (text.equals("?")) {
            int parameterIndex = Integer.parseInt(inputParameter.getChild(1).getText()) - 1;
            return sourcePersistentEntityCriteriaBuilder.parameterReferencingMethodParameter(parameterIndex);
        }
        if (text.equals(":")) {
            return sourcePersistentEntityCriteriaBuilder.parameterReferencingMethodParameter(inputParameter.getChild(1).getText());
        }
        throw new IllegalStateException("Unknown input parameter: " + text);
    }

    private static Expression<?> getExpression(JDQLParser.In_itemContext inItem, CriteriaBuilder criteriaBuilder) {
        JDQLParser.LiteralContext literal = inItem.literal();
        if (literal != null) {
            return JDQLCriteriaBuilderUtils.getExpression(literal, criteriaBuilder);
        }
        JDQLParser.Enum_literalContext enumLiteral = inItem.enum_literal();
        if (enumLiteral != null) {
            return JDQLCriteriaBuilderUtils.getExpression(enumLiteral);
        }
        JDQLParser.Input_parameterContext inputParameter = inItem.input_parameter();
        if (inputParameter != null) {
            return JDQLCriteriaBuilderUtils.getExpression(inputParameter, criteriaBuilder);
        }
        throw new IllegalStateException("Unknown IN item: " + String.valueOf((Object)inItem));
    }
}

