/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.jpa.criteria.PersistentAssociationPath;
import io.micronaut.data.model.jpa.criteria.PersistentEntityPath;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentPropertyPathImpl;
import jakarta.persistence.criteria.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Internal
interface SourcePersistentEntityPath<T>
extends PersistentEntityPath<T> {
    public SourcePersistentEntity getPersistentEntity();

    public List<Association> getAssociations();

    default public <Y> PersistentPropertyPath<Y> get(String attributeName) {
        SourcePersistentProperty property = this.getPersistentEntity().getPropertyByName(attributeName);
        if (property == null) {
            throw new IllegalStateException("Cannot query entity [" + this.getPersistentEntity().getSimpleName() + "] on non-existent property: " + attributeName);
        }
        if (this instanceof PersistentAssociationPath) {
            PersistentAssociationPath associationPath = (PersistentAssociationPath)this;
            List associations = associationPath.getAssociations();
            ArrayList<Association> newAssociations = new ArrayList<Association>(associations.size() + 1);
            newAssociations.addAll(associations);
            newAssociations.add(associationPath.getAssociation());
            return new SourcePersistentPropertyPathImpl((Path<?>)this, (List<Association>)newAssociations, property);
        }
        return new SourcePersistentPropertyPathImpl((Path<?>)this, Collections.emptyList(), property);
    }
}

