/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.DataAnnotationUtils;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractPrefixPatternMethodMatcher;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.SaveEntityMethodMatcher;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

public class SaveOneMethodMatcher
extends AbstractPrefixPatternMethodMatcher {
    public SaveOneMethodMatcher() {
        super(SaveEntityMethodMatcher.PREFIXES);
    }

    @Override
    public final int getOrder() {
        return -100;
    }

    @Override
    protected MethodMatcher.MethodMatch match(MethodMatchContext matchContext, Matcher matcher) {
        List<ParameterElement> parameters = matchContext.getParametersNotInRole();
        if (parameters.size() == 0 || TypeUtils.isEntity(parameters.get(0).getGenericType()) || TypeUtils.isIterableOfEntity(parameters.get(0).getGenericType()) || !SaveOneMethodMatcher.isValidSaveReturnType(matchContext, true)) {
            return null;
        }
        return new MethodMatcher.MethodMatch(){

            @Override
            public MethodMatchInfo buildMatchInfo(MethodMatchContext matchContext) {
                Collection values;
                Set names;
                List<ParameterElement> parameters = matchContext.getParametersNotInRole();
                SourcePersistentEntity rootEntity = matchContext.getRootEntity();
                ClassElement returnType = matchContext.getReturnType();
                if (TypeUtils.isReactiveOrFuture(returnType)) {
                    returnType = returnType.getFirstTypeArgument().orElse(null);
                }
                if (returnType == null || !TypeUtils.isNumber(returnType) && !rootEntity.getName().equals(returnType.getName())) {
                    throw new MatchFailedException("The return type of the save method must be the same as the root entity type: " + rootEntity.getName());
                }
                Set requiredProps = rootEntity.getPersistentProperties().stream().filter(this::isRequiredProperty).map(PersistentProperty::getName).collect(Collectors.toSet());
                Object[] parameterElements = rootEntity.getClassElement().getPrimaryConstructor().map(MethodElement::getParameters).orElse(null);
                HashMap<String, Object> constructorArgs = new HashMap<String, Object>(10);
                if (ArrayUtils.isNotEmpty((Object[])parameterElements)) {
                    for (Object parameterElement : parameterElements) {
                        constructorArgs.put(SaveOneMethodMatcher.this.getParameterValue((ParameterElement)parameterElement), parameterElement);
                    }
                }
                for (ParameterElement parameter : parameters) {
                    String name = SaveOneMethodMatcher.this.getParameterValue(parameter);
                    ClassElement type = parameter.getGenericType();
                    SourcePersistentProperty prop = rootEntity.getPropertyByName(name);
                    ParameterElement constructorArg = (ParameterElement)constructorArgs.get(name);
                    if (prop == null && constructorArg == null) {
                        throw new MatchFailedException("Cannot save with non-existent property or constructor argument: " + name);
                    }
                    if (prop != null) {
                        String typeName = prop.getTypeName();
                        if (!type.isAssignable(typeName) && !typeName.equals(type.getName())) {
                            throw new MatchFailedException("Type mismatch. Found parameter of type [" + type.getName() + "]. Required property of type: " + typeName);
                        }
                        requiredProps.remove(name);
                    } else {
                        ClassElement argType = constructorArg.getGenericType();
                        String typeName = argType.getName();
                        if (!type.isAssignable(typeName) && !typeName.equals(type.getName())) {
                            throw new MatchFailedException("Type mismatch. Found parameter of type [" + type.getName() + "]. Required constructor argument of: " + typeName);
                        }
                    }
                    constructorArgs.remove(name);
                }
                if (!requiredProps.isEmpty()) {
                    throw new MatchFailedException("Save method missing required properties: " + requiredProps);
                }
                if (!constructorArgs.isEmpty() && CollectionUtils.isNotEmpty(names = (values = constructorArgs.values()).stream().filter(pe -> {
                    SourcePersistentProperty prop = rootEntity.getPropertyByName(pe.getName());
                    return prop != null && prop.isRequired() && !prop.getType().isPrimitive();
                }).map(p -> SaveOneMethodMatcher.this.getParameterValue((ParameterElement)p)).collect(Collectors.toSet()))) {
                    throw new MatchFailedException("Save method missing required constructor arguments: " + names);
                }
                AnnotationMetadataHierarchy annotationMetadataHierarchy = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{matchContext.getRepositoryClass().getAnnotationMetadata(), matchContext.getAnnotationMetadata()});
                Map.Entry<ClassElement, Class<? extends DataInterceptor>> e = FindersUtils.pickSaveOneInterceptor(matchContext, matchContext.getReturnType());
                boolean encodeEntityParameters = !DataAnnotationUtils.hasJsonEntityRepresentationAnnotation((AnnotationMetadata)matchContext.getAnnotationMetadata());
                return new MethodMatchInfo(DataMethod.OperationType.INSERT, (TypedElement)e.getKey(), FindersUtils.getInterceptorElement(matchContext, e.getValue())).encodeEntityParameters(encodeEntityParameters).queryResult(matchContext.getQueryBuilder().buildInsert((AnnotationMetadata)annotationMetadataHierarchy, (PersistentEntity)matchContext.getRootEntity()));
            }

            private boolean isRequiredProperty(SourcePersistentProperty pp) {
                return pp.isRequired() && !ClassUtils.getPrimitiveType((String)pp.getTypeName()).isPresent();
            }
        };
    }

    private String getParameterValue(ParameterElement p) {
        return p.stringValue(Parameter.class).orElseGet(() -> ((ParameterElement)p).getName());
    }

    private static boolean isValidSaveReturnType(@NonNull MatchContext matchContext, boolean entityArgumentNotRequired) {
        ClassElement returnType = matchContext.getReturnType();
        if (TypeUtils.isReactiveOrFuture(returnType)) {
            returnType = returnType.getFirstTypeArgument().orElse(null);
        }
        if (returnType == null) {
            return false;
        }
        if (TypeUtils.isVoid(returnType) || TypeUtils.isNumber(returnType)) {
            return true;
        }
        if (TypeUtils.isNumber(returnType)) {
            return true;
        }
        return returnType.hasAnnotation(MappedEntity.class) && (entityArgumentNotRequired || returnType.getName().equals(matchContext.getParameters()[0].getGenericType().getName()));
    }
}

