/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MatchContext
implements AnnotationMetadataProvider {
    @NonNull
    protected final VisitorContext visitorContext;
    @NonNull
    protected final MethodElement methodElement;
    protected final Map<String, String> typeRoles;
    protected final ClassElement returnType;
    @NonNull
    protected final ParameterElement[] parameters;
    private final ClassElement repositoryClass;
    private final QueryBuilder queryBuilder;
    private final List<String> possibleFailures = new ArrayList<String>();
    private boolean failing = false;

    MatchContext(@NonNull QueryBuilder queryBuilder, @NonNull ClassElement repositoryClass, @NonNull VisitorContext visitorContext, @NonNull MethodElement methodElement, @NonNull Map<String, String> typeRoles, @NonNull ClassElement returnType, @NonNull ParameterElement[] parameters) {
        this.queryBuilder = queryBuilder;
        this.repositoryClass = repositoryClass;
        this.visitorContext = visitorContext;
        this.methodElement = methodElement;
        this.typeRoles = typeRoles;
        this.returnType = returnType;
        this.parameters = parameters;
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.methodElement.getAnnotationMetadata();
    }

    public boolean isTypeInRole(@NonNull ClassElement type, @NonNull String role) {
        if (type != null && role != null) {
            String r = this.typeRoles.get(type.getName());
            return r != null && r.equalsIgnoreCase(role);
        }
        return false;
    }

    @NonNull
    public VisitorContext getVisitorContext() {
        return this.visitorContext;
    }

    @NonNull
    public MethodElement getMethodElement() {
        return this.methodElement;
    }

    @NonNull
    @Deprecated
    public ClassElement getReturnType() {
        return this.returnType;
    }

    @NonNull
    public ParameterElement[] getParameters() {
        return this.parameters;
    }

    public void fail(@NonNull String message) {
        this.failing = true;
        this.getVisitorContext().fail(this.getUnableToImplementMessage() + message, (Element)this.getMethodElement());
    }

    public void possiblyFail(@NonNull String message) {
        this.possibleFailures.add(message);
    }

    public boolean isFailing() {
        return this.failing;
    }

    public boolean isPossiblyFailing() {
        return !this.possibleFailures.isEmpty();
    }

    public void logPossibleFailures() {
        VisitorContext visitorContext = this.getVisitorContext();
        String unableToImplementMessage = this.getUnableToImplementMessage();
        MethodElement methodElement = this.getMethodElement();
        for (String message : this.possibleFailures) {
            visitorContext.fail(unableToImplementMessage + message, (Element)methodElement);
        }
    }

    public boolean supportsImplicitQueries() {
        return this.repositoryClass.booleanValue(RepositoryConfiguration.class, "implicitQueries").orElse(true);
    }

    @NonNull
    public ClassElement getRepositoryClass() {
        return this.repositoryClass;
    }

    public String getUnableToImplementMessage() {
        return "Unable to implement Repository method: " + this.repositoryClass.getSimpleName() + "." + this.methodElement.getName() + "(" + Arrays.stream(this.methodElement.getParameters()).map(p -> p.getType().getSimpleName() + " " + p.getName()).collect(Collectors.joining(",")) + "). ";
    }
}

