/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.data.annotation.Embeddable;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.TypeDef;
import io.micronaut.data.model.DataType;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.inject.ast.ClassElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@Internal
public final class Utils {
    public static SourcePersistentEntity resolvePersistentEntity(ClassElement returnType, Function<ClassElement, SourcePersistentEntity> entityResolver) {
        if (returnType != null) {
            if (returnType.hasAnnotation(MappedEntity.class) || returnType.hasStereotype(Embeddable.class)) {
                return entityResolver.apply(returnType);
            }
            Collection typeArguments = returnType.getTypeArguments().values();
            for (ClassElement typeArgument : typeArguments) {
                SourcePersistentEntity entity = Utils.resolvePersistentEntity(typeArgument, entityResolver);
                if (entity == null) continue;
                return entity;
            }
        }
        return null;
    }

    public static Map<String, DataType> getConfiguredDataTypes(ClassElement element) {
        List typeDefinitions = element.getAnnotationValuesByType(TypeDef.class);
        HashMap<String, DataType> dataTypes = new HashMap<String, DataType>(typeDefinitions.size());
        for (AnnotationValue typeDefinition : typeDefinitions) {
            typeDefinition.enumValue("type", DataType.class).ifPresent(dataType -> {
                String[] concated;
                Object[] values = typeDefinition.stringValues("classes");
                Object[] names = typeDefinition.stringValues("names");
                for (String s : concated = (String[])ArrayUtils.concat((Object[])values, (Object[])names)) {
                    dataTypes.put(s, (DataType)dataType);
                }
            });
        }
        return dataTypes;
    }

    public static Map<String, String> getConfiguredDataConverters(ClassElement element) {
        List typeDefinitions = element.getAnnotationValuesByType(TypeDef.class);
        HashMap<String, String> dataConverters = new HashMap<String, String>(typeDefinitions.size());
        for (AnnotationValue typeDefinition : typeDefinitions) {
            typeDefinition.stringValue("converter").filter(c -> !Object.class.getName().equals(c)).ifPresent(converter -> {
                String[] concated;
                Object[] values = typeDefinition.stringValues("classes");
                Object[] names = typeDefinition.stringValues("names");
                for (String s : concated = (String[])ArrayUtils.concat((Object[])values, (Object[])names)) {
                    dataConverters.put(s, (String)converter);
                }
            });
        }
        return dataConverters;
    }
}

