/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Selection;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Internal
public final class Projections {
    private static final List<Projection> PROJECTION_LIST = Arrays.stream(Projections.class.getClasses()).filter(clazz -> Projection.class.isAssignableFrom((Class<?>)clazz) && !Modifier.isAbstract(clazz.getModifiers())).map(clazz -> {
        try {
            return (Projection)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            return null;
        }
    }).collect(Collectors.toList());

    @Nullable
    public static Selection<?> find(@NonNull PersistentEntityRoot<?> entityRoot, @NonNull PersistentEntityCriteriaBuilder cb, String value) {
        String decapitalized = NameUtils.decapitalize((String)value);
        Optional path = entityRoot.getPersistentEntity().getPath(decapitalized);
        if (path.isPresent()) {
            return entityRoot.get((String)path.get());
        }
        for (Projection projection : PROJECTION_LIST) {
            Selection<?> selection = projection.find(entityRoot, cb, value);
            if (selection == null) continue;
            return selection;
        }
        return null;
    }

    static interface Projection {
        @Nullable
        public Selection<?> find(@NonNull PersistentEntityRoot<?> var1, @NonNull PersistentEntityCriteriaBuilder var2, @NonNull String var3);
    }

    private static abstract class PrefixedPropertyProjection
    implements Projection {
        private PrefixedPropertyProjection() {
        }

        @Override
        public final Selection<?> find(PersistentEntityRoot<?> entityRoot, PersistentEntityCriteriaBuilder cb, String value) {
            String prefix = this.getPrefix();
            if (value.startsWith(prefix)) {
                String remaining = value.substring(prefix.length());
                String propertyName = NameUtils.decapitalize((String)remaining);
                Optional path = entityRoot.getPersistentEntity().getPath(propertyName);
                if (!path.isPresent()) {
                    throw new IllegalStateException("Cannot project on non-existent property " + propertyName);
                }
                return this.createProjection((CriteriaBuilder)cb, entityRoot, propertyName);
            }
            return null;
        }

        public abstract Selection<?> createProjection(CriteriaBuilder var1, PersistentEntityRoot<?> var2, String var3);

        protected abstract String getPrefix();
    }

    public static class Avg
    extends PrefixedPropertyProjection {
        @Override
        public Selection<?> createProjection(CriteriaBuilder cb, PersistentEntityRoot<?> entityRoot, String propertyName) {
            return cb.avg((Expression)entityRoot.get(propertyName));
        }

        @Override
        protected String getPrefix() {
            return "Avg";
        }
    }

    public static class Sum
    extends PrefixedPropertyProjection {
        @Override
        public Selection<?> createProjection(CriteriaBuilder cb, PersistentEntityRoot<?> entityRoot, String propertyName) {
            return cb.sum((Expression)entityRoot.get(propertyName));
        }

        @Override
        protected String getPrefix() {
            return "Sum";
        }
    }

    public static class Min
    extends PrefixedPropertyProjection {
        @Override
        public Selection<?> createProjection(CriteriaBuilder cb, PersistentEntityRoot<?> entityRoot, String propertyName) {
            PersistentPropertyPath prop = entityRoot.get(propertyName);
            return prop.isNumeric() ? cb.min((Expression)prop) : cb.least((Expression)prop);
        }

        @Override
        protected String getPrefix() {
            return "Min";
        }
    }

    public static class Max
    extends PrefixedPropertyProjection {
        @Override
        public Selection<?> createProjection(CriteriaBuilder cb, PersistentEntityRoot<?> entityRoot, String propertyName) {
            PersistentPropertyPath prop = entityRoot.get(propertyName);
            return prop.isNumeric() ? cb.max((Expression)prop) : cb.greatest((Expression)prop);
        }

        @Override
        protected String getPrefix() {
            return "Max";
        }
    }
}

