/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.annotation.Expandable;
import io.micronaut.data.annotation.TypeDef;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.ParameterExpressionImpl;
import io.micronaut.data.model.query.BindingParameter;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ParameterElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Internal
public final class SourceParameterExpressionImpl
extends ParameterExpressionImpl<Object>
implements BindingParameter {
    private final Map<String, DataType> dataTypes;
    private final ParameterElement[] parameters;
    private final ParameterElement parameterElement;
    private final boolean isEntityParameter;
    private boolean isUpdate;

    public SourceParameterExpressionImpl(Map<String, DataType> dataTypes, ParameterElement[] parameters, ParameterElement parameterElement, boolean isEntityParameter) {
        super(null, parameterElement == null ? null : parameterElement.getName());
        this.dataTypes = dataTypes;
        this.parameters = parameters;
        this.parameterElement = parameterElement;
        this.isEntityParameter = isEntityParameter;
    }

    public Class<Object> getParameterType() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public void setUpdate(boolean update) {
        this.isUpdate = update;
    }

    public QueryParameterBinding bind(BindingParameter.BindingContext bindingContext) {
        PersistentPropertyPath propertyPath;
        final String bindName = bindingContext.getName() == null ? String.valueOf(bindingContext.getIndex()) : bindingContext.getName();
        PersistentPropertyPath incomingMethodParameterProperty = bindingContext.getIncomingMethodParameterProperty();
        PersistentPropertyPath outgoingQueryParameterProperty = bindingContext.getOutgoingQueryParameterProperty();
        PersistentPropertyPath persistentPropertyPath = propertyPath = outgoingQueryParameterProperty == null ? incomingMethodParameterProperty : outgoingQueryParameterProperty;
        if (propertyPath == null) {
            Objects.requireNonNull(this.parameterElement);
            final int index = Arrays.asList(this.parameters).indexOf(this.parameterElement);
            final DataType dataType = this.getDataType(null, this.parameterElement);
            final String converter = this.parameterElement.stringValue(TypeDef.class, "converter").orElse(null);
            final boolean isExpandable = this.isExpandable(bindingContext, dataType);
            return new QueryParameterBinding(){

                public String getKey() {
                    return bindName;
                }

                public int getParameterIndex() {
                    return index;
                }

                public DataType getDataType() {
                    return dataType;
                }

                public String getConverterClassName() {
                    return converter;
                }

                public boolean isExpandable() {
                    return isExpandable;
                }
            };
        }
        if (outgoingQueryParameterProperty == null) {
            throw new IllegalStateException("Outgoing query parameter property is required!");
        }
        final boolean autopopulated = propertyPath.getProperty().findAnnotation(AutoPopulated.class).map(ap -> (Boolean)ap.getRequiredValue("updateable", Boolean.class)).orElse(false);
        final DataType dataType = this.getDataType(propertyPath, this.parameterElement);
        final String converterClassName = ((SourcePersistentProperty)propertyPath.getProperty()).getConverterClassName();
        final int index = this.parameterElement == null || this.isEntityParameter ? -1 : Arrays.asList(this.parameters).indexOf(this.parameterElement);
        final String[] path = this.asStringPath(outgoingQueryParameterProperty.getAssociations(), outgoingQueryParameterProperty.getProperty());
        final String[] parameterBindingPath = index != -1 ? this.getBindingPath(incomingMethodParameterProperty, outgoingQueryParameterProperty) : null;
        final boolean requiresPrevValue = index == -1 && autopopulated && !this.isUpdate;
        final boolean isExpandable = this.isExpandable(bindingContext, dataType);
        return new QueryParameterBinding(){

            public String getKey() {
                return bindName;
            }

            public DataType getDataType() {
                return dataType;
            }

            public String getConverterClassName() {
                return converterClassName;
            }

            public int getParameterIndex() {
                return index;
            }

            public String[] getParameterBindingPath() {
                return parameterBindingPath;
            }

            public String[] getPropertyPath() {
                return path;
            }

            public boolean isAutoPopulated() {
                return autopopulated;
            }

            public boolean isRequiresPreviousPopulatedValue() {
                return requiresPrevValue;
            }

            public boolean isExpandable() {
                return isExpandable;
            }
        };
    }

    private boolean isExpandable(BindingParameter.BindingContext bindingContext, DataType dataType) {
        if (bindingContext.isExpandable()) {
            return true;
        }
        if (this.parameterElement != null && this.parameterElement.isAnnotationPresent(Expandable.class)) {
            return true;
        }
        if (dataType == DataType.JSON) {
            return false;
        }
        return !dataType.isArray() && (this.parameterElement == null || this.parameterElement.getType().isAssignable(Iterable.class.getName()));
    }

    private String[] getBindingPath(PersistentPropertyPath parameterProperty, PersistentPropertyPath bindedPath) {
        String p;
        String pp;
        if (parameterProperty == null) {
            return this.asStringPath(bindedPath.getAssociations(), bindedPath.getProperty());
        }
        List<String> parameterPath = Arrays.asList(this.asStringPath(parameterProperty.getAssociations(), parameterProperty.getProperty()));
        LinkedList<String> path = new LinkedList<String>(Arrays.asList(this.asStringPath(bindedPath.getAssociations(), bindedPath.getProperty())));
        if (path.equals(parameterPath)) {
            return null;
        }
        int fromIndex = 0;
        for (int i = 0; i < path.size() && i < parameterPath.size() && (pp = parameterPath.get(i)).equals(p = (String)path.get(i)); ++i) {
            ++fromIndex;
        }
        return path.subList(fromIndex, path.size()).toArray(new String[0]);
    }

    private DataType getDataType(PersistentPropertyPath propertyPath, ParameterElement parameterElement) {
        PersistentProperty property;
        if (propertyPath != null && !((property = propertyPath.getProperty()) instanceof Association)) {
            return property.getDataType();
        }
        if (parameterElement != null) {
            DataType dataType = TypeUtils.resolveDataType(parameterElement).orElse(null);
            if (dataType != null) {
                return dataType;
            }
            ClassElement type = parameterElement.getType();
            if (TypeUtils.isContainerType(type)) {
                type = type.getFirstTypeArgument().orElse(type);
            }
            return TypeUtils.resolveDataType(type, this.dataTypes);
        }
        return DataType.OBJECT;
    }

    private String[] asStringPath(List<Association> associations, PersistentProperty property) {
        if (associations.isEmpty()) {
            return new String[]{property.getName()};
        }
        ArrayList<String> path = new ArrayList<String>(associations.size() + 1);
        for (Association association : associations) {
            path.add(association.getName());
        }
        path.add(property.getName());
        return path.toArray(new String[0]);
    }
}

