/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.ISelection;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.LiteralExpression;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitable;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.selection.AggregateExpression;
import io.micronaut.data.model.jpa.criteria.impl.selection.AliasedSelection;
import io.micronaut.data.model.jpa.criteria.impl.selection.CompoundSelection;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaQuery;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentEntityRoot;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentPropertyPath;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.util.function.Function;

@Internal
final class SourcePersistentEntityCriteriaQueryImpl<T>
extends AbstractPersistentEntityCriteriaQuery<T>
implements SourcePersistentEntityCriteriaQuery<T> {
    private final Function<ClassElement, SourcePersistentEntity> entityResolver;

    public SourcePersistentEntityCriteriaQueryImpl(Function<ClassElement, SourcePersistentEntity> entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public <X> PersistentEntityRoot<X> from(ClassElement entityClassElement) {
        return this.from(new SourcePersistentEntity(entityClassElement, this.entityResolver));
    }

    public <X> PersistentEntityRoot<X> from(Class<X> entityClass) {
        throw new IllegalStateException("Unsupported operation");
    }

    public <X> PersistentEntityRoot<X> from(PersistentEntity persistentEntity) {
        SourcePersistentEntityRoot newEntityRoot;
        if (this.entityRoot != null) {
            throw new IllegalStateException("The root entity is already specified!");
        }
        this.entityRoot = newEntityRoot = new SourcePersistentEntityRoot((SourcePersistentEntity)persistentEntity);
        return newEntityRoot;
    }

    @Override
    public String getQueryResultTypeName() {
        if (this.selection instanceof ISelection) {
            final String[] result = new String[1];
            ((SelectionVisitable)this.selection).accept(new SelectionVisitor(){

                public void visit(Predicate predicate) {
                }

                public void visit(PersistentPropertyPath<?> persistentPropertyPath) {
                    result[0] = ((SourcePersistentPropertyPath)persistentPropertyPath).getProperty().getType().getName();
                }

                public void visit(AliasedSelection<?> aliasedSelection) {
                    ((SelectionVisitable)aliasedSelection.getSelection()).accept((SelectionVisitor)this);
                }

                public void visit(PersistentEntityRoot<?> entityRoot) {
                    result[0] = ((SourcePersistentEntity)entityRoot.getPersistentEntity()).getType().getName();
                }

                public void visit(AggregateExpression<?, ?> aggregateExpression) {
                    switch (aggregateExpression.getType()) {
                        case COUNT: 
                        case COUNT_DISTINCT: {
                            result[0] = Long.class.getName();
                            break;
                        }
                        case MAX: 
                        case MIN: {
                            result[0] = CriteriaUtils.requireProperty((Expression)aggregateExpression.getExpression()).getProperty().getTypeName();
                            break;
                        }
                        case SUM: 
                        case AVG: {
                            ClassElement type = ((SourcePersistentProperty)CriteriaUtils.requireProperty((Expression)aggregateExpression.getExpression()).getProperty()).getType();
                            if (aggregateExpression.getExpressionType() != null) {
                                result[0] = aggregateExpression.getExpressionType().getName();
                            }
                            if (TypeUtils.isNumber(type)) {
                                result[0] = Number.class.getName();
                                break;
                            }
                            result[0] = type.getName();
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }

                public void visit(CompoundSelection<?> compoundSelection) {
                    compoundSelection.getCompoundSelectionItems().forEach(s -> ((SelectionVisitable)s).accept((SelectionVisitor)this));
                }

                public void visit(LiteralExpression<?> literalExpression) {
                    result[0] = literalExpression.getValue().getClass().getName();
                }
            });
            return result[0];
        }
        return null;
    }
}

