/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.annotation.Id;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.Version;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaUpdate;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaUpdate;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaBuilder;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractPatternMethodMatcher;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.data.processor.visitors.finders.criteria.UpdateCriteriaMethodMatch;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
public final class UpdateMethodMatcher
extends AbstractPatternMethodMatcher {
    public UpdateMethodMatcher() {
        super(false, "update", "updateBy");
    }

    @Override
    protected MethodMatcher.MethodMatch match(MethodMatchContext matchContext, Matcher matcher) {
        MethodElement methodElement = matchContext.getMethodElement();
        ParameterElement[] parameters = methodElement.getParameters();
        ParameterElement idParameter = Arrays.stream(parameters).filter(p -> p.hasAnnotation(Id.class)).findFirst().orElse(null);
        if (parameters.length > 1 && idParameter != null) {
            if (!TypeUtils.isValidBatchUpdateReturnType(methodElement)) {
                throw new MatchFailedException("Update methods only support void or number based return types");
            }
            return this.batchUpdate(matcher, idParameter);
        }
        ParameterElement entityParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isEntity(p.getGenericType())).findFirst().orElse(null);
        ParameterElement entitiesParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isIterableOfEntity(p.getGenericType())).findFirst().orElse(null);
        if (entityParameter != null || entitiesParameter != null) {
            return this.entityUpdate(matcher, entityParameter, entitiesParameter);
        }
        if (!TypeUtils.isValidBatchUpdateReturnType(methodElement)) {
            throw new MatchFailedException("Update methods only support void or number based return types");
        }
        return this.batchUpdate2(matcher);
    }

    private UpdateCriteriaMethodMatch entityUpdate(Matcher matcher, final ParameterElement entityParameter, final ParameterElement entitiesParameter) {
        return new UpdateCriteriaMethodMatch(matcher){
            ParameterElement entityParam;
            {
                super(matcher);
                this.entityParam = entityParameter == null ? entitiesParameter : entityParameter;
            }

            @Override
            protected <T> void applyPredicates(List<ParameterElement> parameters, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, SourcePersistentEntityCriteriaBuilder cb) {
                SourcePersistentEntity rootEntity = (SourcePersistentEntity)root.getPersistentEntity();
                Predicate predicate = rootEntity.getVersion() != null ? cb.and((Expression)cb.equal(root.id(), (Expression)cb.entityPropertyParameter(this.entityParam)), (Expression)cb.equal((Expression)root.version(), (Expression)cb.entityPropertyParameter(this.entityParam))) : cb.equal(root.id(), (Expression)cb.entityPropertyParameter(this.entityParam));
                query.where((Expression)predicate);
            }

            @Override
            protected <T> void addPropertiesToUpdate(MethodMatchContext matchContext, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, SourcePersistentEntityCriteriaBuilder cb) {
                SourcePersistentEntity rootEntity = matchContext.getRootEntity();
                Stream.concat(rootEntity.getPersistentProperties().stream(), Stream.of(rootEntity.getVersion())).filter(p -> p != null && (!(p instanceof Association) || !((Association)p).isForeignKey()) && !p.isGenerated() && p.findAnnotation(AutoPopulated.class).map(ap -> (Boolean)ap.getRequiredValue("updateable", Boolean.class)).orElse(true) != false).forEach(p -> query.set(p.getName(), cb.entityPropertyParameter(this.entityParam)));
                if (((AbstractPersistentEntityCriteriaUpdate)query).getUpdateValues().isEmpty()) {
                    query.set(rootEntity.getIdentity().getName(), cb.entityPropertyParameter(this.entityParam));
                }
            }

            @Override
            protected boolean supportedByImplicitQueries() {
                return true;
            }

            @Override
            protected Map.Entry<ClassElement, Class<? extends DataInterceptor>> resolveReturnTypeAndInterceptor(MethodMatchContext matchContext) {
                MethodElement methodElement = matchContext.getMethodElement();
                Map.Entry<ClassElement, Class<? extends DataInterceptor>> e = super.resolveReturnTypeAndInterceptor(matchContext);
                ClassElement returnType = e.getKey();
                if (!(returnType == null || TypeUtils.isVoid(returnType) || TypeUtils.isNumber(returnType) || returnType.hasStereotype(MappedEntity.class) || TypeUtils.isReactiveOrFuture(matchContext.getReturnType()) && TypeUtils.isObjectClass(returnType))) {
                    throw new MatchFailedException("Cannot implement update method for specified return type: " + returnType.getName() + " " + methodElement.getReturnType() + " " + methodElement.getDescription(false));
                }
                return e;
            }

            @Override
            protected ParameterElement getEntityParameter() {
                return entityParameter;
            }

            @Override
            protected ParameterElement getEntitiesParameter() {
                return entitiesParameter;
            }
        };
    }

    private UpdateCriteriaMethodMatch batchUpdate(Matcher matcher, final ParameterElement idParameter) {
        return new UpdateCriteriaMethodMatch(matcher){

            @Override
            protected <T> void applyPredicates(String querySequence, ParameterElement[] parameters, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, SourcePersistentEntityCriteriaBuilder cb) {
                super.applyPredicates(querySequence, parameters, root, query, cb);
                ParameterElement versionParameter = Arrays.stream(parameters).filter(p -> p.hasAnnotation(Version.class)).findFirst().orElse(null);
                Predicate predicate = versionParameter != null ? cb.and((Expression)cb.equal(root.id(), (Expression)cb.parameter(idParameter)), (Expression)cb.equal((Expression)root.version(), (Expression)cb.parameter(versionParameter))) : cb.equal(root.id(), (Expression)cb.parameter(idParameter));
                query.where((Expression)predicate);
            }

            @Override
            protected <T> void applyPredicates(List<ParameterElement> parameters, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, SourcePersistentEntityCriteriaBuilder cb) {
                ParameterElement versionParameter = parameters.stream().filter(p -> p.hasAnnotation(Version.class)).findFirst().orElse(null);
                Predicate predicate = versionParameter != null ? cb.and((Expression)cb.equal(root.id(), (Expression)cb.parameter(idParameter)), (Expression)cb.equal((Expression)root.version(), (Expression)cb.parameter(versionParameter))) : cb.equal(root.id(), (Expression)cb.parameter(idParameter));
                query.where((Expression)predicate);
            }

            @Override
            protected <T> void addPropertiesToUpdate(MethodMatchContext matchContext, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, SourcePersistentEntityCriteriaBuilder cb) {
                List<ParameterElement> parameters = matchContext.getParametersNotInRole();
                List remainingParameters = parameters.stream().filter(p -> !p.hasAnnotation(Id.class) && !p.hasAnnotation(Version.class)).collect(Collectors.toList());
                ParameterElement idParameter2 = parameters.stream().filter(p -> p.hasAnnotation(Id.class)).findFirst().orElse(null);
                if (idParameter2 == null) {
                    throw new MatchFailedException("ID required for update method, but not specified");
                }
                SourcePersistentEntity entity = (SourcePersistentEntity)root.getPersistentEntity();
                if (entity.hasIdentity()) {
                    String idParameterType;
                    SourcePersistentProperty identity = entity.getIdentity();
                    String idType = TypeUtils.getTypeName(identity.getType());
                    if (!idType.equals(idParameterType = TypeUtils.getTypeName(idParameter2.getType()))) {
                        throw new MatchFailedException("ID type of method [" + idParameterType + "] does not match ID type of entity: " + idType);
                    }
                } else {
                    throw new MatchFailedException("Cannot update by ID for entity that has no ID");
                }
                for (ParameterElement parameter : remainingParameters) {
                    String name = UpdateMethodMatcher.this.getParameterName(parameter);
                    SourcePersistentProperty prop = entity.getPropertyByName(name);
                    if (prop == null) {
                        throw new MatchFailedException("Cannot update non-existent property: " + name);
                    }
                    if (prop.isGenerated()) {
                        throw new MatchFailedException("Cannot update a generated property: " + name);
                    }
                    query.set(name, cb.parameter(parameter));
                }
            }
        };
    }

    private UpdateCriteriaMethodMatch batchUpdate2(Matcher matcher) {
        return new UpdateCriteriaMethodMatch(matcher){

            @Override
            protected <T> void addPropertiesToUpdate(MethodMatchContext matchContext, PersistentEntityRoot<T> root, PersistentEntityCriteriaUpdate<T> query, SourcePersistentEntityCriteriaBuilder cb) {
                Set queryParameters = query.getParameters().stream().map(jakarta.persistence.Parameter::getName).collect(Collectors.toSet());
                for (ParameterElement p : matchContext.getParametersNotInRole()) {
                    String parameterName = UpdateMethodMatcher.this.getParameterName(p);
                    if (queryParameters.contains(parameterName)) continue;
                    PersistentPropertyPath path = root.getPersistentEntity().getPropertyPath(parameterName);
                    if (path != null) {
                        query.set(path.getProperty().getName(), cb.parameter(p));
                        continue;
                    }
                    throw new MatchFailedException("Cannot perform batch update for non-existent property: " + parameterName);
                }
            }
        };
    }

    private String getParameterName(ParameterElement p) {
        return p.stringValue(Parameter.class).orElse(p.getName());
    }
}

