/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders.specification;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.data.processor.visitors.finders.specification.AbstractSpecificationMethod;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;

@Internal
public class FindAllSpecificationMethod
extends AbstractSpecificationMethod {
    public static final String[] PREFIXES = new String[]{"get", "find", "search", "query"};

    public FindAllSpecificationMethod() {
        super(PREFIXES);
    }

    @Override
    public boolean isMethodMatch(@NonNull MethodElement methodElement, @NonNull MatchContext matchContext) {
        ClassElement returnType = matchContext.getReturnType();
        return super.isMethodMatch(methodElement, matchContext) && TypeUtils.isIterableOfEntity(returnType) && this.isCorrectParameters(methodElement);
    }

    @Override
    @Nullable
    public MethodMatchInfo buildMatchInfo(@NonNull MethodMatchContext matchContext) {
        if (this.isFirstParameterSpringJpaSpecification(matchContext.getMethodElement())) {
            return new MethodMatchInfo((TypedElement)matchContext.getReturnType(), null, this.getInterceptorElement(matchContext, "io.micronaut.data.spring.jpa.intercept.FindAllSpecificationInterceptor"));
        }
        return new MethodMatchInfo((TypedElement)matchContext.getReturnType(), null, this.getInterceptorElement(matchContext, "io.micronaut.data.jpa.repository.intercept.FindAllSpecificationInterceptor"));
    }

    private boolean isCorrectParameters(@NonNull MethodElement methodElement) {
        ParameterElement[] parameters = methodElement.getParameters();
        int len = parameters.length;
        switch (len) {
            case 1: {
                return true;
            }
            case 2: {
                return parameters[1].getType().isAssignable("org.springframework.data.domain.Sort") || parameters[1].getType().isAssignable("io.micronaut.data.model.Sort");
            }
        }
        return false;
    }
}

