/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders.specification;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractListMethod;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.VisitorContext;

public class AbstractSpecificationMethod
extends AbstractListMethod {
    protected AbstractSpecificationMethod(String ... prefixes) {
        super(prefixes);
    }

    @Override
    public int getOrder() {
        return -200;
    }

    @Override
    public boolean isMethodMatch(MethodElement methodElement, MatchContext matchContext) {
        return this.isFirstParameterSpringJpaSpecification(methodElement, matchContext) || this.isFirstParameterMicronautJpaSpecification(methodElement);
    }

    private boolean isFirstParameterSpringJpaSpecification(MethodElement methodElement, MatchContext matchContext) {
        VisitorContext visitorContext = matchContext.getVisitorContext();
        if (visitorContext.getClassElement("io.micronaut.data.spring.jpa.intercept.CountSpecificationInterceptor").isPresent() && visitorContext.getClassElement("org.springframework.data.jpa.domain.Specification").isPresent()) {
            return this.isFirstParameterSpringJpaSpecification(methodElement);
        }
        return false;
    }

    protected final boolean isFirstParameterSpringJpaSpecification(@NonNull MethodElement methodElement) {
        ParameterElement[] parameters = methodElement.getParameters();
        return parameters.length > 0 && parameters[0].getType().isAssignable("org.springframework.data.jpa.domain.Specification");
    }

    protected final boolean isFirstParameterMicronautJpaSpecification(@NonNull MethodElement methodElement) {
        ParameterElement[] parameters = methodElement.getParameters();
        return parameters.length > 0 && parameters[0].getType().isAssignable("io.micronaut.data.jpa.repository.criteria.Specification");
    }
}

