/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractPatternBasedMethod;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodCandidate;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class UpdateEntityMethod
extends AbstractPatternBasedMethod
implements MethodCandidate {
    public static final Pattern METHOD_PATTERN = Pattern.compile("^((update)(\\S*?))$");

    public UpdateEntityMethod() {
        super(METHOD_PATTERN);
    }

    @Override
    @NonNull
    protected MethodMatchInfo.OperationType getOperationType() {
        return MethodMatchInfo.OperationType.UPDATE;
    }

    @Override
    public int getOrder() {
        return -100;
    }

    @Override
    public boolean isMethodMatch(MethodElement methodElement, MatchContext matchContext) {
        ParameterElement[] parameters = matchContext.getParameters();
        return parameters.length > 0 && this.hasMatchingParameters(Arrays.stream(parameters)) && super.isMethodMatch(methodElement, matchContext);
    }

    private boolean hasMatchingParameters(Stream<ParameterElement> parameters) {
        return parameters.anyMatch(p -> TypeUtils.isIterableOfEntity(p.getGenericType()) || p.getGenericType().hasAnnotation(MappedEntity.class));
    }

    @Override
    @Nullable
    public MethodMatchInfo buildMatchInfo(@NonNull MethodMatchContext matchContext) {
        List<ParameterElement> parameters = matchContext.getParametersNotInRole();
        if (CollectionUtils.isNotEmpty(parameters) && this.hasMatchingParameters(parameters.stream())) {
            ParameterElement matchingParameter = null;
            boolean isEntityParameter = false;
            boolean isMultipleEntityParameter = false;
            if (parameters.size() > 0) {
                ParameterElement parameterElement = parameters.get(0);
                if (TypeUtils.isIterableOfEntity(parameterElement.getGenericType())) {
                    matchingParameter = parameterElement;
                    isMultipleEntityParameter = true;
                }
                if (parameterElement.getGenericType().hasAnnotation(MappedEntity.class)) {
                    matchingParameter = parameterElement;
                    isEntityParameter = true;
                }
            }
            if (matchingParameter == null) {
                matchContext.failAndThrow("Cannot find a parameter representing the entity update");
                return null;
            }
            Map.Entry<ClassElement, Class<? extends DataInterceptor>> matchEntry = FindersUtils.resolveInterceptorTypeByOperationType(isEntityParameter, isMultipleEntityParameter, MethodMatchInfo.OperationType.UPDATE, matchContext);
            ClassElement returnType = matchEntry.getKey();
            if (returnType == null) {
                returnType = matchContext.getRootEntity().getType();
            } else if (!(TypeUtils.isVoid(returnType) || TypeUtils.isNumber(returnType) || returnType.hasStereotype(MappedEntity.class) || TypeUtils.isReactiveOrFuture(matchContext.getReturnType()) && TypeUtils.isObjectClass(returnType))) {
                matchContext.failAndThrow("Cannot implement update method for specified return type: " + returnType.getName());
                return null;
            }
            Class<? extends DataInterceptor> interceptor = matchEntry.getValue();
            QueryModel queryModel = null;
            Object[] updateProperties = null;
            if (!matchContext.supportsImplicitQueries()) {
                SourcePersistentEntity rootEntity = matchContext.getRootEntity();
                SourcePersistentProperty identity = rootEntity.getIdentity();
                String idName = identity != null ? identity.getName() : "id";
                queryModel = QueryModel.from((PersistentEntity)rootEntity).idEq(new QueryParameter(idName));
                if (rootEntity.getVersion() != null) {
                    queryModel = queryModel.versionEq(new QueryParameter(rootEntity.getVersion().getName()));
                }
                if (ArrayUtils.isEmpty((Object[])(updateProperties = (String[])Stream.concat(rootEntity.getPersistentProperties().stream(), Stream.of(rootEntity.getVersion())).filter(p -> p != null && (!(p instanceof Association) || !((Association)p).isForeignKey()) && !p.isGenerated() && p.findAnnotation(AutoPopulated.class).map(ap -> (Boolean)ap.getRequiredValue("updateable", Boolean.class)).orElse(true) != false).map(PersistentProperty::getName).toArray(String[]::new)))) {
                    queryModel = null;
                }
            }
            MethodMatchInfo methodMatchInfo = new MethodMatchInfo((TypedElement)returnType, queryModel, this.getInterceptorElement(matchContext, interceptor), MethodMatchInfo.OperationType.UPDATE, (String[])updateProperties);
            if (isEntityParameter) {
                methodMatchInfo.addParameterRole("entity", matchingParameter.getName());
            }
            if (isMultipleEntityParameter) {
                methodMatchInfo.addParameterRole("entities", matchingParameter.getName());
            }
            if (queryModel != null && matchContext.getRootEntity().getVersion() != null) {
                methodMatchInfo.setOptimisticLock(true);
            }
            return methodMatchInfo;
        }
        matchContext.fail("Cannot implement update method for specified arguments and return type");
        return null;
    }
}

