/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractPatternBasedMethod;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public class SaveEntityMethod
extends AbstractPatternBasedMethod {
    public static final Pattern METHOD_PATTERN = Pattern.compile("^((save|persist|store|insert)(\\S*?))$");

    public SaveEntityMethod() {
        super(METHOD_PATTERN);
    }

    @Override
    @NonNull
    protected MethodMatchInfo.OperationType getOperationType() {
        return MethodMatchInfo.OperationType.INSERT;
    }

    @Override
    public boolean isMethodMatch(@NonNull MethodElement methodElement, MatchContext matchContext) {
        ParameterElement[] parameters = matchContext.getParameters();
        return parameters.length > 0 && Arrays.stream(parameters).anyMatch(p -> (TypeUtils.isIterableOfEntity(p.getGenericType()) || TypeUtils.isEntity(p.getGenericType())) && SaveEntityMethod.isValidSaveReturnType(matchContext)) && super.isMethodMatch(methodElement, matchContext);
    }

    @Override
    @Nullable
    public MethodMatchInfo buildMatchInfo(@NonNull MethodMatchContext matchContext) {
        VisitorContext visitorContext = matchContext.getVisitorContext();
        ParameterElement[] parameters = matchContext.getParameters();
        Optional<ParameterElement> entityParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isEntity(p.getGenericType())).findFirst();
        if (entityParameter.isPresent()) {
            Map.Entry<ClassElement, Class<? extends DataInterceptor>> entry = FindersUtils.resolveInterceptorTypeByOperationType(true, false, MethodMatchInfo.OperationType.INSERT, matchContext);
            QueryModel queryModel = matchContext.supportsImplicitQueries() ? null : QueryModel.from((PersistentEntity)matchContext.getRootEntity());
            MethodMatchInfo methodMatchInfo = new MethodMatchInfo((TypedElement)entry.getKey(), queryModel, this.getInterceptorElement(matchContext, entry.getValue()), MethodMatchInfo.OperationType.INSERT);
            methodMatchInfo.addParameterRole("entity", entityParameter.get().getName());
            return methodMatchInfo;
        }
        Optional<ParameterElement> entitiesParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isIterableOfEntity(p.getGenericType())).findFirst();
        if (entitiesParameter.isPresent()) {
            Map.Entry<ClassElement, Class<? extends DataInterceptor>> entry = FindersUtils.resolveInterceptorTypeByOperationType(false, true, MethodMatchInfo.OperationType.INSERT, matchContext);
            QueryModel queryModel = matchContext.supportsImplicitQueries() ? null : QueryModel.from((PersistentEntity)matchContext.getRootEntity());
            MethodMatchInfo methodMatchInfo = new MethodMatchInfo((TypedElement)entry.getKey(), queryModel, this.getInterceptorElement(matchContext, entry.getValue()), MethodMatchInfo.OperationType.INSERT);
            methodMatchInfo.addParameterRole("entities", entitiesParameter.get().getName());
            return methodMatchInfo;
        }
        visitorContext.fail("Cannot implement save method for specified arguments and return type", (Element)matchContext.getMethodElement());
        return null;
    }

    static boolean isValidSaveReturnType(@NonNull MatchContext matchContext) {
        ClassElement returnType = matchContext.getReturnType();
        if (TypeUtils.isVoid(returnType) || TypeUtils.isNumber(returnType)) {
            return true;
        }
        if (TypeUtils.isReactiveOrFuture(returnType)) {
            returnType = returnType.getFirstTypeArgument().orElse(null);
        }
        if (returnType == null) {
            return true;
        }
        if (TypeUtils.isNumber(returnType) || TypeUtils.isIterableOfEntity(returnType)) {
            return true;
        }
        if (returnType.isAssignable(Iterable.class)) {
            return true;
        }
        return TypeUtils.isEntity(returnType);
    }
}

