/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractListMethod;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;

public class DeleteMethod
extends AbstractListMethod {
    public static final Pattern METHOD_PATTERN = Pattern.compile("^((delete|remove|erase|eliminate)(\\S*?))$");

    public DeleteMethod() {
        super("delete", "remove", "erase", "eliminate");
    }

    @Override
    public final int getOrder() {
        return 100;
    }

    @Override
    public boolean isMethodMatch(MethodElement methodElement, MatchContext matchContext) {
        return super.isMethodMatch(methodElement, matchContext) && TypeUtils.isValidBatchUpdateReturnType(methodElement);
    }

    @Override
    @NonNull
    protected MethodMatchInfo.OperationType getOperationType() {
        return MethodMatchInfo.OperationType.DELETE;
    }

    @Override
    @Nullable
    public MethodMatchInfo buildMatchInfo(@NonNull MethodMatchContext matchContext) {
        ParameterElement[] parameters = matchContext.getParameters();
        ParameterElement entityParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isEntity(p.getGenericType())).findFirst().orElse(null);
        ParameterElement entitiesParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isIterableOfEntity(p.getGenericType())).findFirst().orElse(null);
        if (entityParameter == null && entitiesParameter == null) {
            return super.buildMatchInfo(matchContext);
        }
        SourcePersistentEntity rootEntity = matchContext.getRootEntity();
        QueryModel queryModel = null;
        if (!matchContext.supportsImplicitQueries()) {
            boolean generateInIdList;
            if (!rootEntity.hasIdentity() && !rootEntity.hasCompositeIdentity()) {
                matchContext.fail("Delete all not supported for entities with no ID");
                return null;
            }
            SourcePersistentProperty identity = rootEntity.getIdentity();
            String idName = identity != null ? identity.getName() : "id";
            boolean bl = generateInIdList = entitiesParameter != null && !rootEntity.hasCompositeIdentity() && !(rootEntity.getIdentity() instanceof Embedded) && rootEntity.getVersion() == null;
            if (generateInIdList) {
                queryModel = QueryModel.from((PersistentEntity)rootEntity).inList(rootEntity.getIdentity().getName(), new QueryParameter(idName));
            } else {
                queryModel = QueryModel.from((PersistentEntity)rootEntity).idEq(new QueryParameter(idName));
                if (rootEntity.getVersion() != null) {
                    queryModel.versionEq(new QueryParameter(rootEntity.getVersion().getName()));
                }
            }
        }
        Map.Entry<ClassElement, Class<? extends DataInterceptor>> entry = FindersUtils.resolveInterceptorTypeByOperationType(entityParameter != null, entitiesParameter != null, MethodMatchInfo.OperationType.DELETE, matchContext);
        ClassElement resultType = entry.getKey();
        Class<? extends DataInterceptor> interceptorType = entry.getValue();
        MethodMatchInfo methodMatchInfo = new MethodMatchInfo((TypedElement)resultType, queryModel, this.getInterceptorElement(matchContext, interceptorType), this.getOperationType());
        if (entityParameter != null) {
            methodMatchInfo.addParameterRole("entity", entityParameter.getName());
        } else if (entitiesParameter != null) {
            methodMatchInfo.addParameterRole("entities", entitiesParameter.getName());
        }
        if (queryModel != null && rootEntity.getVersion() != null) {
            methodMatchInfo.setOptimisticLock(true);
        }
        return methodMatchInfo;
    }

    @Override
    @Nullable
    protected MethodMatchInfo buildInfo(@NonNull MethodMatchContext matchContext, @NonNull ClassElement queryResultType, @Nullable QueryModel query) {
        Map.Entry<ClassElement, Class<? extends DataInterceptor>> entry = FindersUtils.pickDeleteAllInterceptor(matchContext, matchContext.getReturnType());
        Class<? extends DataInterceptor> interceptor = entry.getValue();
        if (query != null) {
            return new MethodMatchInfo((TypedElement)entry.getKey(), query, this.getInterceptorElement(matchContext, interceptor), this.getOperationType());
        }
        return new MethodMatchInfo((TypedElement)entry.getKey(), QueryModel.from((PersistentEntity)matchContext.getRootEntity()), this.getInterceptorElement(matchContext, interceptor), this.getOperationType());
    }
}

