/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.FindByIdInterceptor;
import io.micronaut.data.intercept.FindOneInterceptor;
import io.micronaut.data.intercept.async.FindByIdAsyncInterceptor;
import io.micronaut.data.intercept.async.FindOneAsyncInterceptor;
import io.micronaut.data.intercept.reactive.FindByIdReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindOneReactiveInterceptor;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.AssociationQuery;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.factory.Projections;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodCandidate;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.ProjectionMethodExpression;
import io.micronaut.data.processor.visitors.finders.RawQuery;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractPatternBasedMethod
implements MethodCandidate {
    private static final Pattern ORDER_BY_PATTERN = Pattern.compile("(.*)OrderBy([\\w\\d]+)");
    private static final Pattern FOR_UPDATE_PATTERN = Pattern.compile("(.*)ForUpdate$");
    protected final Pattern pattern;

    protected AbstractPatternBasedMethod(@NonNull Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean isMethodMatch(@NonNull MethodElement methodElement, @NonNull MatchContext matchContext) {
        return this.pattern.matcher(methodElement.getName()).find();
    }

    protected String matchOrder(String querySequence, List<Sort.Order> orders) {
        if (ORDER_BY_PATTERN.matcher(querySequence).matches()) {
            Matcher matcher = ORDER_BY_PATTERN.matcher(querySequence);
            StringBuffer buffer = new StringBuffer();
            if (matcher.find()) {
                matcher.appendReplacement(buffer, "$1");
                String orderDefGroup = matcher.group(2);
                if (StringUtils.isNotEmpty((CharSequence)orderDefGroup)) {
                    String[] orderDefItems;
                    for (String orderDef : orderDefItems = orderDefGroup.split("And")) {
                        String prop = NameUtils.decapitalize((String)orderDef);
                        if (prop.endsWith("Desc")) {
                            orders.add(Sort.Order.desc((String)prop.substring(0, prop.length() - 4)));
                            continue;
                        }
                        if (prop.endsWith("Asc")) {
                            orders.add(Sort.Order.asc((String)prop.substring(0, prop.length() - 3)));
                            continue;
                        }
                        orders.add(Sort.Order.asc((String)prop));
                    }
                }
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
        return querySequence;
    }

    protected String matchForUpdate(MethodMatchContext matchContext, String querySequence) {
        Matcher matcher;
        if (matchContext.getQueryBuilder().supportsForUpdate() && (matcher = FOR_UPDATE_PATTERN.matcher(querySequence)).matches()) {
            return matcher.group(1);
        }
        return querySequence;
    }

    protected void matchProjections(@NonNull MethodMatchContext matchContext, List<ProjectionMethodExpression> projectionExpressions, String projectionSequence) {
        ProjectionMethodExpression currentExpression = ProjectionMethodExpression.matchProjection(matchContext, projectionSequence);
        if (currentExpression != null) {
            projectionExpressions.add(currentExpression);
        }
    }

    @Nullable
    protected MethodMatchInfo buildInfo(@NonNull MethodMatchContext matchContext, @NonNull ClassElement queryResultType, @Nullable QueryModel query) {
        ClassElement returnType = matchContext.getReturnType();
        if (!TypeUtils.isVoid(returnType)) {
            Map.Entry<ClassElement, Class<? extends DataInterceptor>> entry = FindersUtils.resolveFindInterceptor(matchContext, returnType);
            ClassElement resultType = entry.getKey();
            Class<? extends DataInterceptor> interceptorType = entry.getValue();
            if (interceptorType == FindOneInterceptor.class && this.isFindByIdQuery(matchContext, queryResultType, query)) {
                interceptorType = FindByIdInterceptor.class;
            } else if (interceptorType == FindOneAsyncInterceptor.class && this.isFindByIdQuery(matchContext, queryResultType, query)) {
                interceptorType = FindByIdAsyncInterceptor.class;
            } else if (interceptorType == FindOneReactiveInterceptor.class && this.isFindByIdQuery(matchContext, queryResultType, query)) {
                interceptorType = FindByIdReactiveInterceptor.class;
            }
            boolean isDto = false;
            if (resultType == null || TypeUtils.areTypesCompatible(resultType, queryResultType)) {
                if (!queryResultType.isPrimitive() || resultType == null) {
                    resultType = queryResultType;
                }
            } else if (resultType.hasStereotype(Introspected.class) && queryResultType.hasStereotype(MappedEntity.class)) {
                if (query == null) {
                    query = QueryModel.from((PersistentEntity)matchContext.getRootEntity());
                }
                if (!this.ignoreAttemptProjection(query)) {
                    this.attemptProjection(matchContext, queryResultType, query, resultType);
                }
                isDto = true;
            } else {
                matchContext.failAndThrow("Query results in a type [" + queryResultType.getName() + "] whilst method returns an incompatible type: " + resultType.getName());
            }
            return new MethodMatchInfo((TypedElement)resultType, query, FindersUtils.getInterceptorElement(matchContext, interceptorType), isDto);
        }
        matchContext.fail("Unsupported Repository method return type");
        return null;
    }

    protected ClassElement getInterceptorElement(@NonNull MethodMatchContext matchContext, Class<? extends DataInterceptor> type) {
        return FindersUtils.getInterceptorElement(matchContext, type);
    }

    protected ClassElement getInterceptorElement(@NonNull MethodMatchContext matchContext, String type) {
        return FindersUtils.getInterceptorElement(matchContext, type);
    }

    private void attemptProjection(@NonNull MethodMatchContext matchContext, @NonNull ClassElement queryResultType, @NonNull QueryModel query, ClassElement returnType) {
        List beanProperties = returnType.getBeanProperties();
        SourcePersistentEntity entity = matchContext.getEntity(queryResultType);
        for (PropertyElement beanProperty : beanProperties) {
            String propertyName = beanProperty.getName();
            if ("metaClass".equals(propertyName) && beanProperty.getType().isAssignable("groovy.lang.MetaClass")) continue;
            SourcePersistentProperty pp = entity.getPropertyByName(propertyName);
            if (pp == null) {
                pp = entity.getIdOrVersionPropertyByName(propertyName);
            }
            if (pp == null) {
                matchContext.failAndThrow("Property " + propertyName + " is not present in entity: " + entity.getName());
                return;
            }
            if (!TypeUtils.areTypesCompatible(beanProperty.getType(), pp.getType())) {
                matchContext.failAndThrow("Property [" + propertyName + "] of type [" + beanProperty.getType().getName() + "] is not compatible with equivalent property declared in entity: " + entity.getName());
                return;
            }
            QueryBuilder queryBuilder = matchContext.getQueryBuilder();
            if (queryBuilder.shouldAliasProjections()) {
                query.projections().add((QueryModel.Projection)Projections.property((String)propertyName).aliased());
                continue;
            }
            query.projections().add((QueryModel.Projection)Projections.property((String)propertyName));
        }
    }

    protected boolean applyOrderBy(@NonNull MethodMatchContext context, @NonNull QueryModel query, @NonNull List<Sort.Order> orderList) {
        if (CollectionUtils.isNotEmpty(orderList)) {
            SourcePersistentEntity entity = context.getRootEntity();
            for (Sort.Order order : orderList) {
                String prop = order.getProperty();
                if (entity.getPath(prop).isPresent()) continue;
                context.fail("Cannot order by non-existent property: " + prop);
                return true;
            }
            query.sort(Sort.of(orderList));
        }
        return false;
    }

    protected void applyForUpdate(QueryModel query) {
        query.forUpdate();
    }

    @NonNull
    protected List<AnnotationValue<Join>> joinSpecsAtMatchContext(@NonNull MethodMatchContext matchContext) {
        MethodMatchInfo.OperationType operationType = this.getOperationType();
        if (operationType != MethodMatchInfo.OperationType.QUERY) {
            return matchContext.getAnnotationMetadata().getDeclaredAnnotationValuesByType(Join.class);
        }
        List joins = matchContext.getAnnotationMetadata().getAnnotationValuesByType(Join.class);
        if (!joins.isEmpty()) {
            return joins;
        }
        return matchContext.getRepositoryClass().getAnnotationMetadata().getAnnotationValuesByType(Join.class);
    }

    protected boolean applyJoinSpecs(@NonNull MethodMatchContext matchContext, @NonNull QueryModel query, @NonNull SourcePersistentEntity rootEntity, @NonNull List<AnnotationValue<Join>> joinSpecs) {
        for (AnnotationValue<Join> joinSpec : joinSpecs) {
            String path = joinSpec.stringValue().orElse(null);
            Join.Type type = joinSpec.enumValue("type", Join.Type.class).orElse(Join.Type.FETCH);
            String alias = joinSpec.stringValue("alias").orElse(null);
            if (path == null) continue;
            PersistentProperty prop = rootEntity.getPropertyByPath(path).orElse(null);
            if (!(prop instanceof Association)) {
                matchContext.fail("Invalid join spec [" + path + "]. Property is not an association!");
                return true;
            }
            boolean hasExisting = query.getCriteria().getCriteria().stream().anyMatch(c -> {
                if (c instanceof AssociationQuery) {
                    AssociationQuery aq = (AssociationQuery)c;
                    return aq.getAssociation().equals(prop);
                }
                return false;
            });
            if (!hasExisting) {
                query.add((QueryModel.Criterion)new AssociationQuery(path, (Association)prop));
            }
            query.join(path, (Association)prop, type, alias);
        }
        return false;
    }

    private boolean isFindByIdQuery(@NonNull MethodMatchContext matchContext, @NonNull ClassElement queryResultType, @Nullable QueryModel query) {
        return matchContext.supportsImplicitQueries() && query != null && queryResultType.getName().equals(matchContext.getRootEntity().getName()) && this.isIdEquals(query) != false;
    }

    private Boolean isIdEquals(@NonNull QueryModel query) {
        List criteria = query.getCriteria().getCriteria();
        return criteria.size() == 1 && criteria.stream().findFirst().map(c -> c instanceof QueryModel.IdEquals).orElse(false) != false;
    }

    @NonNull
    protected MethodMatchInfo.OperationType getOperationType() {
        return MethodMatchInfo.OperationType.QUERY;
    }

    private boolean ignoreAttemptProjection(@Nullable QueryModel query) {
        return query instanceof RawQuery;
    }
}

