/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.TypeDef;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Slice;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.time.Year;
import java.time.YearMonth;
import java.time.chrono.ChronoLocalDate;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

@Internal
public class TypeUtils {
    private static final Map<String, DataType> RESOLVED_DATA_TYPES = new HashMap<String, DataType>(50);

    public static boolean isIterableOfEntity(@Nullable ClassElement type) {
        return type != null && type.isAssignable(Iterable.class) && TypeUtils.hasPersistedTypeArgument(type);
    }

    public static boolean isEntityContainerType(@Nullable ClassElement type) {
        return TypeUtils.isContainerType(type) && TypeUtils.hasPersistedTypeArgument(type);
    }

    public static boolean isEntity(@Nullable ClassElement type) {
        if (type == null) {
            return false;
        }
        return type.hasAnnotation(MappedEntity.class);
    }

    public static boolean hasPersistedTypeArgument(@Nullable ClassElement type) {
        if (type == null) {
            return false;
        }
        return type.getFirstTypeArgument().map(TypeUtils::isEntity).orElse(false);
    }

    public static boolean doesReturnNumber(@NonNull MethodElement methodElement) {
        ClassElement returnType = methodElement.getGenericReturnType();
        if (returnType != null) {
            return TypeUtils.isNumber(returnType);
        }
        return false;
    }

    public static boolean doesReturnVoid(@NonNull MethodElement methodElement) {
        ClassElement rt = methodElement.getReturnType();
        return TypeUtils.isVoid(rt);
    }

    public static boolean doesReturnBoolean(@NonNull MethodElement methodElement) {
        return TypeUtils.isBoolean(methodElement.getGenericReturnType());
    }

    public static boolean isContainerType(@Nullable ClassElement type) {
        if (type == null) {
            return false;
        }
        return type.isAssignable(Iterable.class) || type.isAssignable(Stream.class) || type.isAssignable(Slice.class) || TypeUtils.isReactiveType(type) || type.isAssignable(Optional.class) || TypeUtils.isFutureType(type);
    }

    public static boolean isReactiveType(@Nullable ClassElement type) {
        return type != null && (type.isAssignable(Publisher.class) || type.getPackageName().equals("io.reactivex"));
    }

    public static boolean isFutureType(@Nullable ClassElement type) {
        if (type == null) {
            return false;
        }
        return type.isAssignable(CompletionStage.class) || type.isAssignable(Future.class);
    }

    public static boolean isReactiveOrFuture(@Nullable ClassElement type) {
        if (type == null) {
            return false;
        }
        return TypeUtils.isReactiveType(type) || TypeUtils.isFutureType(type);
    }

    public static boolean isNumber(@Nullable ClassElement type) {
        if (type == null) {
            return false;
        }
        if (type.isPrimitive()) {
            return ClassUtils.getPrimitiveType((String)type.getName()).map(aClass -> Number.class.isAssignableFrom(ReflectionUtils.getWrapperType((Class)aClass))).orElse(false);
        }
        return type.isAssignable(Number.class);
    }

    public static boolean isVoid(@Nullable ClassElement type) {
        return type != null && (type.isAssignable(Void.class) || type.isAssignable(Void.TYPE));
    }

    public static boolean isBoolean(@Nullable ClassElement type) {
        return type != null && (type.isAssignable(Boolean.class) || type.isPrimitive() && type.getName().equals("boolean"));
    }

    public static boolean isVoidOrNumberArgument(ClassElement type) {
        if (type == null) {
            return false;
        }
        ClassElement ce = type.getFirstTypeArgument().orElse(null);
        return ce == null || ce.isAssignable(Void.class) || TypeUtils.isNumber(ce);
    }

    static boolean isValidBatchUpdateReturnType(MethodElement methodElement) {
        return TypeUtils.doesReturnVoid(methodElement) || TypeUtils.doesReturnNumber(methodElement) || TypeUtils.isReactiveOrFuture(methodElement.getReturnType()) && TypeUtils.isVoidOrNumberArgument(methodElement.getReturnType());
    }

    public static boolean isObjectClass(ClassElement type) {
        return type != null && type.getName().equals(Object.class.getName());
    }

    public static Optional<DataType> resolveDataType(@NonNull ParameterElement parameter) {
        ClassElement genericType = parameter.getGenericType();
        if (TypeUtils.isEntityContainerType(genericType) || genericType.hasStereotype(MappedEntity.class)) {
            return Optional.of(DataType.ENTITY);
        }
        return parameter.enumValue(TypeDef.class, "type", DataType.class);
    }

    @NonNull
    public static DataType resolveDataType(@NonNull ClassElement type, Map<String, DataType> dataTypes) {
        String typeName = type.isArray() ? type.getName() + "[]" : type.getName();
        return RESOLVED_DATA_TYPES.computeIfAbsent(typeName, s -> {
            Class primitiveType;
            if ((type.isPrimitive() || typeName.startsWith("java.lang")) && (primitiveType = (Class)ClassUtils.getPrimitiveType((String)type.getName()).orElse(null)) != null && primitiveType != Void.TYPE) {
                String wrapperName = ReflectionUtils.getWrapperType((Class)primitiveType).getSimpleName().toUpperCase(Locale.ENGLISH);
                if (type.isArray()) {
                    wrapperName = wrapperName + "_ARRAY";
                }
                return DataType.valueOf((String)wrapperName);
            }
            Optional explicitType = type.getValue(TypeDef.class, "type", DataType.class);
            if (explicitType.isPresent()) {
                return (DataType)explicitType.get();
            }
            if (type.isEnum()) {
                return DataType.STRING;
            }
            if (type.hasStereotype(MappedEntity.class)) {
                return DataType.ENTITY;
            }
            if (type.isArray()) {
                if (type.isAssignable(String.class)) {
                    return DataType.STRING_ARRAY;
                }
                if (type.isAssignable(Short.class)) {
                    return DataType.SHORT_ARRAY;
                }
                if (type.isAssignable(Integer.class)) {
                    return DataType.INTEGER_ARRAY;
                }
                if (type.isAssignable(Long.class)) {
                    return DataType.LONG_ARRAY;
                }
                if (type.isAssignable(Float.class)) {
                    return DataType.FLOAT_ARRAY;
                }
                if (type.isAssignable(Double.class)) {
                    return DataType.DOUBLE_ARRAY;
                }
                if (type.isAssignable(Character.class)) {
                    return DataType.CHARACTER_ARRAY;
                }
                if (type.isAssignable(Boolean.class)) {
                    return DataType.BOOLEAN_ARRAY;
                }
            }
            try {
                if (ClassUtils.isJavaBasicType((String)type.getName())) {
                    Class pt = ClassUtils.getPrimitiveType((String)type.getName()).orElse(null);
                    if (pt != null) {
                        String wrapperName = ReflectionUtils.getWrapperType((Class)pt).getSimpleName();
                        return DataType.valueOf((String)wrapperName.toUpperCase(Locale.ENGLISH));
                    }
                    return DataType.valueOf((String)type.getSimpleName().toUpperCase(Locale.ENGLISH));
                }
            }
            catch (IllegalArgumentException pt) {
                // empty catch block
            }
            if (type.isAssignable(CharSequence.class)) {
                return DataType.STRING;
            }
            if (type.isAssignable(BigDecimal.class) || type.isAssignable(BigInteger.class)) {
                return DataType.BIGDECIMAL;
            }
            if (type.isAssignable(Temporal.class)) {
                if (type.isAssignable(ChronoLocalDate.class) || type.isAssignable(Year.class) || type.isAssignable(YearMonth.class)) {
                    return DataType.DATE;
                }
                return DataType.TIMESTAMP;
            }
            if (type.isAssignable(Date.class)) {
                if (type.isAssignable(Timestamp.class)) {
                    return DataType.TIMESTAMP;
                }
                return DataType.DATE;
            }
            if (type.isAssignable(UUID.class)) {
                return DataType.UUID;
            }
            if (Stream.of(Charset.class, TimeZone.class, Locale.class, URL.class, URI.class).anyMatch(arg_0 -> ((ClassElement)type).isAssignable(arg_0))) {
                return DataType.STRING;
            }
            String configured = dataTypes.keySet().stream().filter(arg_0 -> ((ClassElement)type).isAssignable(arg_0)).findFirst().orElse(null);
            if (configured != null) {
                return (DataType)dataTypes.get(configured);
            }
            if (ClassUtils.isJavaBasicType((String)type.getName())) {
                return DataType.STRING;
            }
            return DataType.OBJECT;
        });
    }

    public static boolean areTypesCompatible(ClassElement leftType, ClassElement rightType) {
        String rightTypeName = rightType.getName();
        if (leftType.getName().equals(rightTypeName)) {
            return true;
        }
        if (leftType.isAssignable(rightTypeName)) {
            return true;
        }
        if (TypeUtils.isNumber(leftType) && TypeUtils.isNumber(rightType)) {
            return true;
        }
        return TypeUtils.isBoolean(leftType) && TypeUtils.isBoolean(rightType);
    }

    @NonNull
    public static String getTypeName(@NonNull ClassElement type) {
        String typeName = type.getName();
        return ClassUtils.getPrimitiveType((String)typeName).map(t -> ReflectionUtils.getWrapperType((Class)t).getName()).orElse(typeName);
    }
}

