/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.DeleteMethod;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodCandidate;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.RawQuery;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;

public class RawQueryMethod
implements MethodCandidate {
    private static final String SELECT = "select";
    private static final String DELETE = "delete";
    private static final String UPDATE = "update";
    private static final String INSERT = "insert";

    @Override
    public final int getOrder() {
        return -1000;
    }

    @Override
    public boolean isMethodMatch(MethodElement methodElement, MatchContext matchContext) {
        return methodElement.stringValue(Query.class).isPresent();
    }

    @Override
    @Nullable
    public MethodMatchInfo buildMatchInfo(@NonNull MethodMatchContext matchContext) {
        RawQuery queryModel;
        ParameterElement entitiesParameter;
        ParameterElement entityParameter;
        MethodElement methodElement = matchContext.getMethodElement();
        ParameterElement[] parameters = matchContext.getParameters();
        if (parameters.length > 1) {
            entityParameter = null;
            entitiesParameter = null;
        } else {
            entityParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isEntity(p.getGenericType())).findFirst().orElse(null);
            entitiesParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isIterableOfEntity(p.getGenericType())).findFirst().orElse(null);
        }
        boolean readOnly = matchContext.getAnnotationMetadata().booleanValue(Query.class, "readOnly").orElse(true);
        String query = (String)matchContext.getAnnotationMetadata().stringValue(Query.class).get();
        MethodMatchInfo.OperationType operationType = this.findOperationType(methodElement.getName(), query, readOnly);
        Map.Entry<ClassElement, Class<? extends DataInterceptor>> entry = FindersUtils.resolveInterceptorTypeByOperationType(entityParameter != null, entitiesParameter != null, operationType, matchContext);
        ClassElement resultType = entry.getKey();
        Class<? extends DataInterceptor> interceptorType = entry.getValue();
        if (interceptorType.getSimpleName().startsWith("SaveOne")) {
            operationType = MethodMatchInfo.OperationType.UPDATE;
            Map.Entry<ClassElement, Class<? extends DataInterceptor>> e = FindersUtils.pickUpdateInterceptor(matchContext, matchContext.getReturnType());
            resultType = e.getKey();
            interceptorType = e.getValue();
        }
        if (operationType == MethodMatchInfo.OperationType.QUERY) {
            entityParameter = null;
            entitiesParameter = null;
        }
        if ((queryModel = this.buildRawQuery(matchContext, entityParameter, entitiesParameter, operationType)) == null) {
            return null;
        }
        boolean isDto = false;
        if (resultType == null) {
            resultType = matchContext.getRootEntity().getType();
        } else if (operationType == MethodMatchInfo.OperationType.QUERY) {
            if (resultType.hasAnnotation(Introspected.class) && !resultType.hasAnnotation(MappedEntity.class)) {
                isDto = true;
            }
        } else if (!this.isValidReturnType(resultType, operationType)) {
            matchContext.failAndThrow("Invalid result type: " + resultType.getName() + " for '" + (Object)((Object)operationType) + "' operation");
            return null;
        }
        MethodMatchInfo methodMatchInfo = isDto ? new MethodMatchInfo((TypedElement)resultType, (QueryModel)queryModel, FindersUtils.getInterceptorElement(matchContext, interceptorType), true) : new MethodMatchInfo((TypedElement)resultType, (QueryModel)queryModel, FindersUtils.getInterceptorElement(matchContext, interceptorType), operationType);
        if (entityParameter != null) {
            methodMatchInfo.addParameterRole("entity", entityParameter.getName());
        } else if (entitiesParameter != null) {
            methodMatchInfo.addParameterRole("entities", entitiesParameter.getName());
        }
        return methodMatchInfo;
    }

    private boolean isValidReturnType(ClassElement returnType, MethodMatchInfo.OperationType operationType) {
        if (operationType == MethodMatchInfo.OperationType.INSERT) {
            return TypeUtils.isVoid(returnType) || TypeUtils.isNumber(returnType);
        }
        return true;
    }

    private MethodMatchInfo.OperationType findOperationType(String methodName, String query, boolean readOnly) {
        if ((query = query.trim().toLowerCase(Locale.ENGLISH)).startsWith(SELECT)) {
            return MethodMatchInfo.OperationType.QUERY;
        }
        if (query.startsWith(DELETE)) {
            return MethodMatchInfo.OperationType.DELETE;
        }
        if (query.startsWith(UPDATE)) {
            if (DeleteMethod.METHOD_PATTERN.matcher(methodName.toLowerCase(Locale.ENGLISH)).matches()) {
                return MethodMatchInfo.OperationType.DELETE;
            }
            return MethodMatchInfo.OperationType.UPDATE;
        }
        if (query.startsWith(INSERT)) {
            return MethodMatchInfo.OperationType.INSERT;
        }
        if (readOnly) {
            return MethodMatchInfo.OperationType.QUERY;
        }
        return MethodMatchInfo.OperationType.UPDATE;
    }

    private RawQuery buildRawQuery(@NonNull MethodMatchContext matchContext, ParameterElement entityParameter, ParameterElement entitiesParameter, MethodMatchInfo.OperationType operationType) {
        MethodElement methodElement = matchContext.getMethodElement();
        String queryString = (String)methodElement.stringValue(Query.class).orElseThrow(() -> new IllegalStateException("Should only be called if Query has value!"));
        List<ParameterElement> parameters = Arrays.asList(matchContext.getParameters());
        boolean namedParameters = matchContext.getRepositoryClass().booleanValue(RepositoryConfiguration.class, "namedParameters").orElse(true);
        Matcher matcher = QueryBuilder.VARIABLE_PATTERN.matcher(queryString);
        SourcePersistentEntity persistentEntity = null;
        if (entityParameter != null) {
            persistentEntity = matchContext.getEntity(entityParameter.getGenericType());
        } else if (entitiesParameter != null) {
            persistentEntity = matchContext.getEntity((ClassElement)entitiesParameter.getGenericType().getFirstTypeArgument().get());
        }
        ArrayList<QueryParameterBinding> parameterBindings = new ArrayList<QueryParameterBinding>(parameters.size());
        if (namedParameters) {
            while (matcher.find()) {
                String name = matcher.group(3);
                Optional<ParameterElement> element = parameters.stream().filter(p -> p.getName().equals(name)).findFirst();
                if (element.isPresent()) {
                    parameterBindings.add(QueryParameterBinding.of((String)name, (String)name, (DataType)DataType.OBJECT, (QueryParameter)new QueryParameter(name)));
                    continue;
                }
                if (persistentEntity != null) {
                    PersistentPropertyPath propertyPath = persistentEntity.getPropertyPath(name);
                    if (propertyPath == null) {
                        matchContext.fail("Cannot update non-existent property: " + name);
                        continue;
                    }
                    parameterBindings.add(QueryParameterBinding.of((String)name, (String)propertyPath.getPath(), (DataType)propertyPath.getProperty().getDataType()));
                    continue;
                }
                matchContext.fail("No method parameter found for named Query parameter : " + name);
                return null;
            }
        } else {
            int index = 1;
            while (matcher.find()) {
                String name = matcher.group(3);
                Optional<ParameterElement> element = parameters.stream().filter(p -> p.getName().equals(name)).findFirst();
                if (element.isPresent()) {
                    parameterBindings.add(QueryParameterBinding.of((String)String.valueOf(index++), (String)name, (DataType)DataType.OBJECT, (QueryParameter)new QueryParameter(name)));
                    continue;
                }
                if (persistentEntity != null) {
                    PersistentPropertyPath propertyPath = persistentEntity.getPropertyPath(name);
                    if (propertyPath == null) {
                        matchContext.fail("Cannot update non-existent property: " + name);
                        continue;
                    }
                    parameterBindings.add(QueryParameterBinding.of((String)String.valueOf(index++), (String)propertyPath.getPath(), (DataType)propertyPath.getProperty().getDataType()));
                    continue;
                }
                matchContext.fail("No method parameter found for named Query parameter : " + name);
                return null;
            }
        }
        boolean encodeEntityParameters = persistentEntity != null || operationType == MethodMatchInfo.OperationType.INSERT;
        return new RawQuery(matchContext.getRootEntity(), parameterBindings, encodeEntityParameters);
    }
}

