/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.SaveOneInterceptor;
import io.micronaut.data.intercept.async.SaveOneAsyncInterceptor;
import io.micronaut.data.intercept.reactive.SaveOneReactiveInterceptor;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractPatternBasedMethod;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.SaveEntityMethod;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SaveOneMethod
extends AbstractPatternBasedMethod {
    public SaveOneMethod() {
        super(SaveEntityMethod.METHOD_PATTERN);
    }

    @Override
    @NonNull
    protected MethodMatchInfo.OperationType getOperationType() {
        return MethodMatchInfo.OperationType.INSERT;
    }

    @Override
    public boolean isMethodMatch(@NonNull MethodElement methodElement, @NonNull MatchContext matchContext) {
        ParameterElement[] parameters = matchContext.getParameters();
        return super.isMethodMatch(methodElement, matchContext) && SaveOneMethod.isValidSaveReturnType(matchContext, true) && parameters.length > 0 && !TypeUtils.isIterableOfEntity(parameters[0].getGenericType());
    }

    @Override
    @Nullable
    public MethodMatchInfo buildMatchInfo(@NonNull MethodMatchContext matchContext) {
        Collection values;
        Set names;
        List<ParameterElement> parameters = matchContext.getParametersNotInRole();
        SourcePersistentEntity rootEntity = matchContext.getRootEntity();
        ClassElement returnType = matchContext.getReturnType();
        if (TypeUtils.isReactiveOrFuture(returnType)) {
            returnType = returnType.getFirstTypeArgument().orElse(null);
        }
        if (returnType == null || !rootEntity.getName().equals(returnType.getName())) {
            matchContext.fail("The return type of the save method must be the same as the root entity type: " + rootEntity.getName());
            return null;
        }
        Set requiredProps = rootEntity.getPersistentProperties().stream().filter(this::isRequiredProperty).map(PersistentProperty::getName).collect(Collectors.toSet());
        Object[] parameterElements = rootEntity.getClassElement().getPrimaryConstructor().map(MethodElement::getParameters).orElse(null);
        HashMap<String, Object> constructorArgs = new HashMap<String, Object>(10);
        if (ArrayUtils.isNotEmpty((Object[])parameterElements)) {
            for (Object parameterElement : parameterElements) {
                constructorArgs.put(parameterElement.getName(), parameterElement);
            }
        }
        for (ParameterElement parameter : parameters) {
            String name = parameter.getName();
            ClassElement type = parameter.getGenericType();
            SourcePersistentProperty prop = rootEntity.getPropertyByName(name);
            ParameterElement constructorArg = (ParameterElement)constructorArgs.get(name);
            if (prop == null && constructorArg == null) {
                matchContext.fail("Cannot save with non-existent property or constructor argument: " + name);
                return null;
            }
            if (prop != null) {
                String typeName = prop.getTypeName();
                if (!type.isAssignable(typeName) && !typeName.equals(type.getName())) {
                    matchContext.fail("Type mismatch. Found parameter of type [" + type.getName() + "]. Required property of type: " + typeName);
                    return null;
                }
                requiredProps.remove(name);
                constructorArgs.remove(name);
                continue;
            }
            ClassElement argType = constructorArg.getGenericType();
            String typeName = argType.getName();
            if (!type.isAssignable(typeName) && !typeName.equals(type.getName())) {
                matchContext.fail("Type mismatch. Found parameter of type [" + type.getName() + "]. Required constructor argument of: " + typeName);
                return null;
            }
            constructorArgs.remove(name);
        }
        if (!requiredProps.isEmpty()) {
            matchContext.fail("Save method missing required properties: " + requiredProps);
            return null;
        }
        if (!constructorArgs.isEmpty() && CollectionUtils.isNotEmpty(names = (values = constructorArgs.values()).stream().filter(pe -> {
            SourcePersistentProperty prop = rootEntity.getPropertyByName(pe.getName());
            return prop != null && prop.isRequired() && !prop.getType().isPrimitive();
        }).map(Element::getName).collect(Collectors.toSet()))) {
            matchContext.fail("Save method missing required constructor arguments: " + names);
            return null;
        }
        Class<? extends DataInterceptor> interceptor = SaveOneMethod.pickSaveInterceptor(matchContext.getReturnType());
        return new MethodMatchInfo((TypedElement)returnType, QueryModel.from((PersistentEntity)matchContext.getRootEntity()), this.getInterceptorElement(matchContext, interceptor), MethodMatchInfo.OperationType.INSERT);
    }

    private boolean isRequiredProperty(SourcePersistentProperty pp) {
        return pp.isRequired() && !ClassUtils.getPrimitiveType((String)pp.getTypeName()).isPresent();
    }

    @NonNull
    static Class<? extends DataInterceptor> pickSaveInterceptor(@NonNull ClassElement returnType) {
        if (TypeUtils.isFutureType(returnType)) {
            return SaveOneAsyncInterceptor.class;
        }
        if (TypeUtils.isReactiveOrFuture(returnType)) {
            return SaveOneReactiveInterceptor.class;
        }
        return SaveOneInterceptor.class;
    }

    private static boolean isValidSaveReturnType(@NonNull MatchContext matchContext, boolean entityArgumentNotRequired) {
        ClassElement returnType = matchContext.getReturnType();
        if (TypeUtils.isReactiveOrFuture(returnType)) {
            returnType = returnType.getFirstTypeArgument().orElse(null);
        }
        return returnType != null && returnType.hasAnnotation(MappedEntity.class) && (entityArgumentNotRequired || returnType.getName().equals(matchContext.getParameters()[0].getGenericType().getName()));
    }
}

