/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MethodMatchInfo {
    private final TypedElement resultType;
    private final QueryModel query;
    private final ClassElement interceptor;
    private final OperationType operationType;
    private final String[] updateProperties;
    private Map<String, String> parameterRoles = new HashMap<String, String>(2);
    private boolean dto;
    private boolean optimisticLock;

    public MethodMatchInfo(@Nullable TypedElement resultType, @Nullable QueryModel query, @Nullable ClassElement interceptor) {
        this(resultType, query, interceptor, OperationType.QUERY);
    }

    public MethodMatchInfo(@Nullable TypedElement resultType, @Nullable QueryModel query, @Nullable ClassElement interceptor, boolean dto) {
        this(resultType, query, interceptor, OperationType.QUERY);
        this.dto = dto;
    }

    public MethodMatchInfo(@Nullable TypedElement resultType, @Nullable QueryModel query, @Nullable ClassElement interceptor, @NonNull OperationType operationType) {
        this(resultType, query, interceptor, operationType, null);
    }

    public MethodMatchInfo(@Nullable TypedElement resultType, @Nullable QueryModel query, @Nullable ClassElement interceptor, @NonNull OperationType operationType, String[] updateProperties) {
        this.query = query;
        this.interceptor = interceptor;
        this.operationType = operationType;
        this.resultType = resultType;
        this.updateProperties = updateProperties;
    }

    public boolean isDto() {
        return this.dto;
    }

    public boolean isOptimisticLock() {
        return this.optimisticLock;
    }

    public void setOptimisticLock(boolean optimisticLock) {
        this.optimisticLock = optimisticLock;
    }

    public void addParameterRole(CharSequence role, String name) {
        this.parameterRoles.put(role.toString(), name);
    }

    public Map<String, String> getParameterRoles() {
        return Collections.unmodifiableMap(this.parameterRoles);
    }

    @NonNull
    public List<String> getUpdateProperties() {
        if (this.updateProperties == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.updateProperties);
    }

    @Nullable
    public TypedElement getResultType() {
        return this.resultType;
    }

    @Nullable
    public QueryModel getQuery() {
        return this.query;
    }

    @Nullable
    public ClassElement getRuntimeInterceptor() {
        return this.interceptor;
    }

    @NonNull
    public OperationType getOperationType() {
        return this.operationType;
    }

    public static enum OperationType {
        QUERY,
        UPDATE,
        DELETE,
        INSERT;

    }
}

