/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.DeleteAllInterceptor;
import io.micronaut.data.intercept.DeleteOneInterceptor;
import io.micronaut.data.intercept.FindAllInterceptor;
import io.micronaut.data.intercept.FindOneInterceptor;
import io.micronaut.data.intercept.FindOptionalInterceptor;
import io.micronaut.data.intercept.FindPageInterceptor;
import io.micronaut.data.intercept.FindSliceInterceptor;
import io.micronaut.data.intercept.FindStreamInterceptor;
import io.micronaut.data.intercept.SaveAllInterceptor;
import io.micronaut.data.intercept.SaveEntityInterceptor;
import io.micronaut.data.intercept.SaveOneInterceptor;
import io.micronaut.data.intercept.UpdateAllEntitiesInterceptor;
import io.micronaut.data.intercept.UpdateEntityInterceptor;
import io.micronaut.data.intercept.UpdateInterceptor;
import io.micronaut.data.intercept.async.DeleteAllAsyncInterceptor;
import io.micronaut.data.intercept.async.DeleteOneAsyncInterceptor;
import io.micronaut.data.intercept.async.FindAllAsyncInterceptor;
import io.micronaut.data.intercept.async.FindOneAsyncInterceptor;
import io.micronaut.data.intercept.async.FindPageAsyncInterceptor;
import io.micronaut.data.intercept.async.FindSliceAsyncInterceptor;
import io.micronaut.data.intercept.async.SaveAllAsyncInterceptor;
import io.micronaut.data.intercept.async.SaveEntityAsyncInterceptor;
import io.micronaut.data.intercept.async.SaveOneAsyncInterceptor;
import io.micronaut.data.intercept.async.UpdateAllEntriesAsyncInterceptor;
import io.micronaut.data.intercept.async.UpdateAsyncInterceptor;
import io.micronaut.data.intercept.async.UpdateEntityAsyncInterceptor;
import io.micronaut.data.intercept.reactive.DeleteAllReactiveInterceptor;
import io.micronaut.data.intercept.reactive.DeleteOneReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindAllReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindOneReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindPageReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindSliceReactiveInterceptor;
import io.micronaut.data.intercept.reactive.SaveAllReactiveInterceptor;
import io.micronaut.data.intercept.reactive.SaveEntityReactiveInterceptor;
import io.micronaut.data.intercept.reactive.SaveOneReactiveInterceptor;
import io.micronaut.data.intercept.reactive.UpdateAllEntitiesReactiveInterceptor;
import io.micronaut.data.intercept.reactive.UpdateEntityReactiveInterceptor;
import io.micronaut.data.intercept.reactive.UpdateReactiveInterceptor;
import io.micronaut.data.model.Slice;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.inject.ast.ClassElement;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;
import org.reactivestreams.Publisher;

@Internal
interface FindersUtils {
    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> resolveInterceptorTypeByOperationType(boolean hasEntityParameter, boolean hasMultipleEntityParameter, MethodMatchInfo.OperationType operationType, MethodMatchContext matchContext) {
        ClassElement returnType = matchContext.getReturnType();
        switch (operationType) {
            case DELETE: {
                if (hasEntityParameter) {
                    return FindersUtils.pickDeleteInterceptor(matchContext, returnType);
                }
                return FindersUtils.pickDeleteAllInterceptor(matchContext, returnType);
            }
            case UPDATE: {
                Map.Entry<ClassElement, Class<? extends DataInterceptor>> updateEntry = hasMultipleEntityParameter ? FindersUtils.pickUpdateAllEntitiesInterceptor(matchContext, returnType) : (hasEntityParameter ? FindersUtils.pickUpdateEntityInterceptor(matchContext, returnType) : FindersUtils.pickUpdateInterceptor(matchContext, returnType));
                if (FindersUtils.isContainer(matchContext, updateEntry.getKey(), Iterable.class)) {
                    return FindersUtils.typeAndInterceptorEntry((ClassElement)updateEntry.getKey().getFirstTypeArgument().get(), updateEntry.getValue());
                }
                return updateEntry;
            }
            case INSERT: {
                Map.Entry<ClassElement, Class<? extends DataInterceptor>> saveEntry = hasEntityParameter ? FindersUtils.pickSaveEntityInterceptor(matchContext, returnType) : (hasMultipleEntityParameter ? FindersUtils.pickSaveAllEntitiesInterceptor(matchContext, returnType) : (FindersUtils.isFutureType(matchContext, returnType) ? FindersUtils.typeAndInterceptorEntry(returnType.getType(), SaveOneAsyncInterceptor.class) : (FindersUtils.isReactiveType(matchContext, returnType) ? FindersUtils.typeAndInterceptorEntry(returnType.getType(), SaveOneReactiveInterceptor.class) : FindersUtils.typeAndInterceptorEntry(returnType.getType(), SaveOneInterceptor.class))));
                if (FindersUtils.isContainer(matchContext, saveEntry.getKey(), Iterable.class)) {
                    return FindersUtils.typeAndInterceptorEntry((ClassElement)saveEntry.getKey().getFirstTypeArgument().get(), saveEntry.getValue());
                }
                return saveEntry;
            }
            case QUERY: {
                return FindersUtils.resolveFindInterceptor(matchContext, returnType);
            }
        }
        throw new IllegalStateException("Cannot pick interceptor for an operation type: " + (Object)((Object)operationType) + " and a return type: " + returnType);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> pickUpdateAllEntitiesInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        ClassElement firstTypeArgument = returnType.getFirstTypeArgument().orElse(null);
        if (FindersUtils.isFutureType(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, UpdateAllEntriesAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, UpdateAllEntitiesReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), UpdateAllEntitiesInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> pickDeleteInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        ClassElement firstTypeArgument = returnType.getFirstTypeArgument().orElse(null);
        if (FindersUtils.isFutureType(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, DeleteOneAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, DeleteOneReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), DeleteOneInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> pickDeleteAllInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        ClassElement firstTypeArgument = returnType.getFirstTypeArgument().orElse(null);
        if (FindersUtils.isFutureType(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, DeleteAllAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, DeleteAllReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), DeleteAllInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> pickSaveEntityInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        ClassElement firstTypeArgument = returnType.getFirstTypeArgument().orElse(null);
        if (FindersUtils.isFutureType(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, SaveEntityAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, SaveEntityReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), SaveEntityInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> pickSaveAllEntitiesInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        ClassElement firstTypeArgument = returnType.getFirstTypeArgument().orElse(null);
        if (FindersUtils.isFutureType(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, SaveAllAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, SaveAllReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), SaveAllInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> pickUpdateInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        ClassElement firstTypeArgument = returnType.getFirstTypeArgument().orElse(null);
        if (FindersUtils.isFutureType(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, UpdateAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, UpdateReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), UpdateInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> pickUpdateEntityInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        ClassElement firstTypeArgument = returnType.getFirstTypeArgument().orElse(null);
        if (FindersUtils.isFutureType(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, UpdateEntityAsyncInterceptor.class);
        }
        if (FindersUtils.isReactiveType(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, UpdateEntityReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType.getType(), UpdateEntityInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> resolveFindInterceptor(MethodMatchContext matchContext, ClassElement returnType) {
        ClassElement firstTypeArgument = returnType.getFirstTypeArgument().orElse(null);
        Map.Entry<ClassElement, Class<? extends DataInterceptor>> entry = FindersUtils.isFutureType(matchContext, returnType) ? FindersUtils.resolveAsyncFindInterceptor(matchContext, returnType, firstTypeArgument) : (FindersUtils.isReactiveType(matchContext, returnType) ? FindersUtils.resolveReactiveFindInterceptor(matchContext, returnType, firstTypeArgument) : FindersUtils.resolveSyncFindInterceptor(matchContext, returnType));
        return entry;
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> resolveSyncFindInterceptor(@NonNull MethodMatchContext matchContext, @NotNull ClassElement returnType) {
        ClassElement firstTypeArgument = returnType.getFirstTypeArgument().orElse(null);
        if (FindersUtils.isPage(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindPageInterceptor.class);
        }
        if (FindersUtils.isSlice(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindSliceInterceptor.class);
        }
        if (FindersUtils.isContainer(matchContext, returnType, Iterable.class)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindAllInterceptor.class);
        }
        if (FindersUtils.isContainer(matchContext, returnType, Stream.class)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindStreamInterceptor.class);
        }
        if (FindersUtils.isContainer(matchContext, returnType, Optional.class)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindOptionalInterceptor.class);
        }
        if (FindersUtils.isContainer(matchContext, returnType, Publisher.class)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindAllReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(returnType, FindOneInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> resolveReactiveFindInterceptor(@NonNull MethodMatchContext matchContext, @NonNull ClassElement returnType, @NonNull ClassElement reactiveType) {
        ClassElement firstTypeArgument = reactiveType.getFirstTypeArgument().orElse(null);
        if (FindersUtils.isPage(matchContext, reactiveType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindPageReactiveInterceptor.class);
        }
        if (FindersUtils.isSlice(matchContext, reactiveType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindSliceReactiveInterceptor.class);
        }
        if (FindersUtils.isReactiveSingleResult(matchContext, returnType)) {
            return FindersUtils.typeAndInterceptorEntry(reactiveType, FindOneReactiveInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(reactiveType, FindAllReactiveInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> resolveAsyncFindInterceptor(@NonNull MethodMatchContext matchContext, @NonNull ClassElement returnType, @NonNull ClassElement asyncType) {
        ClassElement firstTypeArgument = asyncType.getFirstTypeArgument().orElse(null);
        if (FindersUtils.isPage(matchContext, asyncType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindPageAsyncInterceptor.class);
        }
        if (FindersUtils.isSlice(matchContext, asyncType)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindSliceAsyncInterceptor.class);
        }
        if (FindersUtils.isContainer(matchContext, asyncType, Iterable.class)) {
            return FindersUtils.typeAndInterceptorEntry(firstTypeArgument, FindAllAsyncInterceptor.class);
        }
        return FindersUtils.typeAndInterceptorEntry(asyncType, FindOneAsyncInterceptor.class);
    }

    public static Map.Entry<ClassElement, Class<? extends DataInterceptor>> typeAndInterceptorEntry(ClassElement type, Class<? extends DataInterceptor> interceptor) {
        return new AbstractMap.SimpleEntry<ClassElement, Class<? extends DataInterceptor>>(type, interceptor);
    }

    public static boolean isFutureType(MethodMatchContext methodMatchContext, @Nullable ClassElement type) {
        return FindersUtils.isOneOfContainers(methodMatchContext, type, CompletionStage.class, Future.class);
    }

    public static boolean isReactiveType(MethodMatchContext methodMatchContext, @Nullable ClassElement type) {
        return FindersUtils.isContainer(methodMatchContext, type, Publisher.class) || type != null && type.getPackageName().equals("io.reactivex") && (type.getTypeArguments().isEmpty() || FindersUtils.isContainer(methodMatchContext, type, type.getName()));
    }

    public static boolean isPage(MethodMatchContext methodMatchContext, ClassElement typeArgument) {
        boolean matches = methodMatchContext.isTypeInRole(typeArgument, "page");
        if (matches && !methodMatchContext.hasParameterInRole("pageable")) {
            methodMatchContext.fail("Method must accept an argument that is a Pageable");
        }
        return matches;
    }

    public static boolean isSlice(MethodMatchContext methodMatchContext, ClassElement typeArgument) {
        boolean matches = methodMatchContext.isTypeInRole(typeArgument, "slice");
        if (matches && !methodMatchContext.hasParameterInRole("pageable")) {
            methodMatchContext.fail("Method must accept an argument that is a Pageable");
        }
        return FindersUtils.isContainer(methodMatchContext, typeArgument, Slice.class);
    }

    public static boolean isContainer(MethodMatchContext methodMatchContext, ClassElement typeArgument, Class<?> containerType) {
        if (typeArgument == null) {
            return false;
        }
        if (typeArgument.isAssignable(containerType)) {
            ClassElement type = typeArgument.getFirstTypeArgument().orElse(null);
            if (type == null) {
                methodMatchContext.failAndThrow("'" + containerType + "' return type missing type argument");
            }
            return true;
        }
        return false;
    }

    public static boolean isOneOfContainers(MethodMatchContext methodMatchContext, ClassElement typeArgument, Class<?> ... containers) {
        if (typeArgument == null) {
            return false;
        }
        for (Class<?> containerType : containers) {
            if (!FindersUtils.isContainer(methodMatchContext, typeArgument, containerType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainer(MethodMatchContext methodMatchContext, ClassElement typeArgument, String containerType) {
        if (typeArgument.isAssignable(containerType)) {
            ClassElement type = typeArgument.getFirstTypeArgument().orElse(null);
            if (type == null) {
                methodMatchContext.failAndThrow("'" + containerType + "' return type missing type argument");
            }
            return true;
        }
        return false;
    }

    public static boolean isValidResultType(ClassElement returnType) {
        return returnType.hasStereotype(Introspected.class) || ClassUtils.isJavaBasicType((String)returnType.getName()) || returnType.isPrimitive();
    }

    public static boolean isReactiveSingleResult(MethodMatchContext matchContext, ClassElement returnType) {
        return returnType.hasStereotype(SingleResult.class) || FindersUtils.isContainer(matchContext, returnType, "io.reactivex.Single") || FindersUtils.isContainer(matchContext, returnType, "reactor.core.publisher.Mono");
    }

    public static ClassElement getInterceptorElement(@NonNull MethodMatchContext matchContext, Class<? extends DataInterceptor> type) {
        return matchContext.getVisitorContext().getClassElement(type).orElseGet(() -> new DynamicClassElement(type));
    }

    public static ClassElement getInterceptorElement(@NonNull MethodMatchContext matchContext, String type) {
        return (ClassElement)matchContext.getVisitorContext().getClassElement(type).orElseThrow(() -> new IllegalStateException("Unable to apply interceptor of type: " + type + ". The interceptor was not found on the classpath. Check your annotation processor configuration and try again."));
    }

    public static class DynamicClassElement
    implements ClassElement {
        private final Class<? extends DataInterceptor> type;

        DynamicClassElement(Class<? extends DataInterceptor> type) {
            this.type = type;
        }

        public boolean isAssignable(String type) {
            return false;
        }

        public ClassElement toArray() {
            return new DynamicClassElement(Array.newInstance(this.type, 0).getClass());
        }

        public ClassElement fromArray() {
            return new DynamicClassElement(this.type.getComponentType());
        }

        @Nonnull
        public String getName() {
            return this.type.getName();
        }

        public boolean isProtected() {
            return Modifier.isProtected(this.type.getModifiers());
        }

        public boolean isPublic() {
            return Modifier.isPublic(this.type.getModifiers());
        }

        @Nonnull
        public Object getNativeType() {
            return this.type;
        }
    }
}

