/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Property;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Embeddable;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.annotation.TypeDef;
import io.micronaut.data.annotation.TypeRole;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.Slice;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.visitors.AnnotationMetadataHierarchy;
import io.micronaut.data.processor.visitors.MappedEntityVisitor;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.CountByMethod;
import io.micronaut.data.processor.visitors.finders.CountMethod;
import io.micronaut.data.processor.visitors.finders.DeleteByMethod;
import io.micronaut.data.processor.visitors.finders.DeleteMethod;
import io.micronaut.data.processor.visitors.finders.ExistsByFinder;
import io.micronaut.data.processor.visitors.finders.FindByFinder;
import io.micronaut.data.processor.visitors.finders.FindByIdsMethod;
import io.micronaut.data.processor.visitors.finders.FindOneMethod;
import io.micronaut.data.processor.visitors.finders.ListMethod;
import io.micronaut.data.processor.visitors.finders.MethodCandidate;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.RawQuery;
import io.micronaut.data.processor.visitors.finders.SaveAllMethod;
import io.micronaut.data.processor.visitors.finders.SaveEntityMethod;
import io.micronaut.data.processor.visitors.finders.SaveOneMethod;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.data.processor.visitors.finders.UpdateByMethod;
import io.micronaut.data.processor.visitors.finders.UpdateEntityMethod;
import io.micronaut.data.processor.visitors.finders.UpdateMethod;
import io.micronaut.data.processor.visitors.finders.page.FindPageByMethod;
import io.micronaut.data.processor.visitors.finders.page.ListPageMethod;
import io.micronaut.data.processor.visitors.finders.slice.FindSliceByMethod;
import io.micronaut.data.processor.visitors.finders.slice.ListSliceMethod;
import io.micronaut.data.processor.visitors.finders.specification.CountSpecificationMethod;
import io.micronaut.data.processor.visitors.finders.specification.FindAllSpecificationMethod;
import io.micronaut.data.processor.visitors.finders.specification.FindOneSpecificationMethod;
import io.micronaut.data.processor.visitors.finders.specification.FindPageSpecificationMethod;
import io.micronaut.data.repository.GenericRepository;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

@Internal
public class RepositoryTypeElementVisitor
implements TypeElementVisitor<Repository, Object> {
    public static final String SPRING_REPO = "org.springframework.data.repository.Repository";
    private ClassElement currentClass;
    private ClassElement currentRepository;
    private QueryBuilder queryEncoder;
    private Map<String, String> typeRoles = new HashMap<String, String>();
    private List<MethodCandidate> finders;
    private boolean failing = false;
    private Set<String> visitedRepositories = new HashSet<String>();
    private Map<String, DataType> dataTypes = Collections.emptyMap();
    private Map<String, SourcePersistentEntity> entityMap = new HashMap<String, SourcePersistentEntity>(50);
    private final Function<ClassElement, SourcePersistentEntity> entityResolver = new Function<ClassElement, SourcePersistentEntity>(){

        @Override
        public SourcePersistentEntity apply(ClassElement classElement) {
            return RepositoryTypeElementVisitor.this.entityMap.computeIfAbsent(classElement.getName(), s -> new SourcePersistentEntity(classElement, this));
        }
    };

    public RepositoryTypeElementVisitor() {
        this.typeRoles.put(Pageable.class.getName(), "pageable");
        this.typeRoles.put(Sort.class.getName(), "sort");
        this.typeRoles.put(Page.class.getName(), "page");
        this.typeRoles.put(Slice.class.getName(), "slice");
    }

    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public void start(VisitorContext visitorContext) {
        if (this.finders == null) {
            this.finders = this.initializeMethodCandidates(visitorContext);
        }
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        String interfaceName = element.getName();
        if (this.failing) {
            return;
        }
        if (this.visitedRepositories.contains(interfaceName)) {
            this.currentRepository = null;
            this.currentClass = null;
            return;
        }
        this.currentClass = element;
        if (element.hasDeclaredStereotype(Repository.class)) {
            this.visitedRepositories.add(interfaceName);
            this.currentRepository = element;
            this.queryEncoder = QueryBuilder.newQueryBuilder((AnnotationMetadata)element.getAnnotationMetadata());
            this.dataTypes = MappedEntityVisitor.getConfiguredDataTypes(this.currentRepository);
            AnnotationMetadata annotationMetadata = element.getAnnotationMetadata();
            List roleArray = annotationMetadata.findAnnotation(RepositoryConfiguration.class).map(av -> av.getAnnotations("typeRoles", TypeRole.class)).orElse(Collections.emptyList());
            for (AnnotationValue parameterRole : roleArray) {
                String role = parameterRole.stringValue("role").orElse(null);
                AnnotationClassValue cv = parameterRole.get((CharSequence)"type", AnnotationClassValue.class).orElse(null);
                if (!StringUtils.isNotEmpty((CharSequence)role) || cv == null) continue;
                context.getClassElement(cv.getName()).ifPresent(ce -> this.typeRoles.put(ce.getName(), role));
            }
            if (element.isAssignable(SPRING_REPO)) {
                context.getClassElement("org.springframework.data.domain.Pageable").ifPresent(ce -> this.typeRoles.put(ce.getName(), "pageable"));
                context.getClassElement("org.springframework.data.domain.Page").ifPresent(ce -> this.typeRoles.put(ce.getName(), "page"));
                context.getClassElement("org.springframework.data.domain.Slice").ifPresent(ce -> this.typeRoles.put(ce.getName(), "slice"));
                context.getClassElement("org.springframework.data.domain.Sort").ifPresent(ce -> this.typeRoles.put(ce.getName(), "sort"));
            }
            if (this.queryEncoder == null) {
                context.fail("QueryEncoder not present on annotation processor path", (Element)element);
                this.failing = true;
            }
        }
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        if (this.currentRepository == null || this.failing) {
            return;
        }
        ClassElement genericReturnType = element.getGenericReturnType();
        if (this.queryEncoder != null && this.currentClass != null && element.isAbstract() && !element.isStatic() && this.finders != null) {
            ParameterElement[] parameters = element.getParameters();
            HashMap<String, Element> parametersInRole = new HashMap<String, Element>(2);
            for (ParameterElement parameter : parameters) {
                ClassElement type = parameter.getType();
                this.typeRoles.entrySet().stream().filter(entry -> {
                    String roleType = (String)entry.getKey();
                    return type.isAssignable(roleType);
                }).forEach(entry -> {
                    Element cfr_ignored_0 = (Element)parametersInRole.put((String)entry.getValue(), (Element)parameter);
                });
            }
            if (element.hasDeclaredAnnotation(DataMethod.class)) {
                return;
            }
            MatchContext matchContext = new MatchContext(this.queryEncoder, this.currentRepository, context, element, this.typeRoles, genericReturnType, parameters);
            for (MethodCandidate finder : this.finders) {
                MethodMatchInfo methodInfo;
                if (!finder.isMethodMatch(element, matchContext)) continue;
                SourcePersistentEntity entity = this.resolvePersistentEntity(element, parametersInRole, context);
                if (entity == null) {
                    matchContext.fail("Unable to establish persistent entity to query for method: " + element.getName());
                    this.failing = matchContext.isFailing();
                    return;
                }
                String idType = this.resolveIdType(entity);
                MethodMatchContext methodMatchContext = new MethodMatchContext(this.queryEncoder, this.currentRepository, entity, context, genericReturnType, element, parametersInRole, this.typeRoles, parameters, this.entityResolver);
                try {
                    methodInfo = finder.buildMatchInfo(methodMatchContext);
                }
                catch (Exception e) {
                    matchContext.fail(e.getMessage());
                    return;
                }
                if (methodInfo != null) {
                    ClassElement runtimeInterceptor;
                    for (Map.Entry<String, Element> entry2 : methodMatchContext.getParametersInRole().entrySet()) {
                        methodInfo.addParameterRole(entry2.getKey(), entry2.getValue().getName());
                    }
                    QueryModel queryObject = methodInfo.getQuery();
                    QueryResult preparedCount = null;
                    Map parameterBinding = null;
                    Map parameterTypes = Collections.emptyMap();
                    boolean rawCount = false;
                    boolean encodeEntityParameters = false;
                    boolean supportsImplicitQueries = matchContext.supportsImplicitQueries();
                    if (queryObject != null) {
                        if (queryObject instanceof RawQuery) {
                            RawQuery rawQuery = (RawQuery)queryObject;
                            parameterBinding = rawQuery.getParameterBinding();
                            if (matchContext.isTypeInRole(genericReturnType, "page") || element.isPresent(Query.class, "countQuery")) {
                                String cq = matchContext.getAnnotationMetadata().stringValue(Query.class, "countQuery").orElse(null);
                                if (StringUtils.isEmpty((CharSequence)cq)) {
                                    methodMatchContext.fail("Query returns a Page and does not specify a 'countQuery' member.");
                                    this.failing = true;
                                    return;
                                }
                                rawCount = true;
                            }
                        } else {
                            QueryResult encodedQuery;
                            AnnotationMetadataHierarchy annotationMetadataHierarchy = new AnnotationMetadataHierarchy(this.currentRepository.getAnnotationMetadata(), matchContext.getAnnotationMetadata());
                            try {
                                switch (methodInfo.getOperationType()) {
                                    case DELETE: {
                                        encodedQuery = this.queryEncoder.buildDelete((AnnotationMetadata)annotationMetadataHierarchy, queryObject);
                                        break;
                                    }
                                    case UPDATE: {
                                        boolean isEntityArgument;
                                        encodedQuery = this.queryEncoder.buildUpdate((AnnotationMetadata)annotationMetadataHierarchy, queryObject, methodInfo.getUpdateProperties());
                                        boolean bl = isEntityArgument = parameters.length == 1 && parameters[0].getGenericType().getName().equals(entity.getName());
                                        if (isEntityArgument) {
                                            encodeEntityParameters = true;
                                        }
                                        break;
                                    }
                                    case INSERT: {
                                        encodedQuery = this.queryEncoder.buildInsert((AnnotationMetadata)annotationMetadataHierarchy, (PersistentEntity)entity);
                                        encodeEntityParameters = true;
                                        break;
                                    }
                                    default: {
                                        encodedQuery = this.queryEncoder.buildQuery((AnnotationMetadata)annotationMetadataHierarchy, queryObject);
                                        break;
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (this.currentRepository != null) {
                                    methodMatchContext.fail("Invalid query method [" + element.getName() + "] of repository [" + this.currentRepository.getName() + "]: " + e.getMessage());
                                } else {
                                    methodMatchContext.fail("Invalid query method [" + element.getName() + "]: " + e.getMessage());
                                }
                                this.failing = true;
                                return;
                            }
                            if (encodedQuery != null) {
                                parameterBinding = encodedQuery.getParameters();
                                parameterTypes = encodedQuery.getParameterTypes();
                                Set requiredParams = encodedQuery.getAdditionalRequiredParameters();
                                if (CollectionUtils.isNotEmpty((Collection)requiredParams)) {
                                    for (Iterator requiredParam : requiredParams) {
                                        boolean hasNoParameter = Arrays.stream(parameters).noneMatch(arg_0 -> RepositoryTypeElementVisitor.lambda$visitMethod$8((String)((Object)requiredParam), arg_0));
                                        if (!hasNoParameter) continue;
                                        methodMatchContext.fail("A @Where(..) definition requires a parameter called [" + (String)((Object)requiredParam) + "] which is not present in the method signature.");
                                    }
                                }
                                if (TypeUtils.isReactiveOrFuture(genericReturnType)) {
                                    genericReturnType = genericReturnType.getFirstTypeArgument().orElse(entity.getType());
                                }
                                if (matchContext.isTypeInRole(genericReturnType, "page")) {
                                    QueryModel countQuery = QueryModel.from((PersistentEntity)queryObject.getPersistentEntity());
                                    countQuery.projections().count();
                                    QueryModel.Junction junction = queryObject.getCriteria();
                                    for (QueryModel.Criterion criterion : junction.getCriteria()) {
                                        countQuery.add(criterion);
                                    }
                                    for (JoinPath joinPath : queryObject.getJoinPaths()) {
                                        Join.Type joinType = joinPath.getJoinType();
                                        switch (joinType) {
                                            case INNER: 
                                            case FETCH: {
                                                joinType = Join.Type.DEFAULT;
                                                break;
                                            }
                                            case LEFT_FETCH: {
                                                joinType = Join.Type.LEFT;
                                                break;
                                            }
                                            case RIGHT_FETCH: {
                                                joinType = Join.Type.RIGHT;
                                                break;
                                            }
                                        }
                                        countQuery.join(joinPath.getAssociation(), joinType);
                                    }
                                    QueryResult finalPreparedCount = preparedCount = this.queryEncoder.buildQuery(countQuery);
                                    element.annotate(Query.class, annotationBuilder -> {
                                        annotationBuilder.value(encodedQuery.getQuery());
                                        annotationBuilder.member("countQuery", finalPreparedCount.getQuery());
                                    });
                                } else {
                                    element.annotate(Query.class, annotationBuilder -> annotationBuilder.value(encodedQuery.getQuery()));
                                }
                            }
                        }
                    }
                    if ((runtimeInterceptor = methodInfo.getRuntimeInterceptor()) != null) {
                        Map finalParameterBinding = parameterBinding;
                        QueryResult finalPreparedCount1 = preparedCount;
                        boolean finalRawCount = rawCount;
                        Map finalParameterTypes = parameterTypes;
                        boolean finalEncodeEntityParameters = encodeEntityParameters;
                        element.annotate(DataMethod.class, annotationBuilder -> {
                            TypedElement resultType;
                            annotationBuilder.member("rootEntity", new AnnotationClassValue[]{new AnnotationClassValue(entity.getName())});
                            methodInfo.getParameterRoles().forEach((arg_0, arg_1) -> ((AnnotationValueBuilder)annotationBuilder).member(arg_0, arg_1));
                            if (methodInfo.isDto()) {
                                annotationBuilder.member("dto", true);
                            }
                            if ((resultType = methodInfo.getResultType()) != null) {
                                annotationBuilder.member("resultType", new AnnotationClassValue[]{new AnnotationClassValue(resultType.getName())});
                                ClassElement type = resultType.getType();
                                if (!type.getName().equals("void")) {
                                    annotationBuilder.member("resultDataType", (Enum)TypeUtils.resolveDataType(type, this.dataTypes));
                                }
                            }
                            if (idType != null) {
                                annotationBuilder.member("idType", idType);
                            }
                            annotationBuilder.member("interceptor", new AnnotationClassValue[]{new AnnotationClassValue(runtimeInterceptor.getName())});
                            if (CollectionUtils.isNotEmpty((Map)finalParameterBinding)) {
                                if (!supportsImplicitQueries && !finalEncodeEntityParameters) {
                                    this.addParameterTypeDefinitions(methodMatchContext, finalParameterBinding, parameters, (AnnotationValueBuilder<DataMethod>)annotationBuilder, finalParameterTypes);
                                }
                                if (finalEncodeEntityParameters) {
                                    annotationBuilder.member("parameterBindingPaths", finalParameterBinding.values().toArray(new String[0]));
                                } else if (finalRawCount) {
                                    String cq = element.stringValue(Query.class, "countQuery").orElse(null);
                                    if (cq != null) {
                                        cq = this.replaceNamedParameters(this.queryEncoder, cq);
                                        String finalCq = cq;
                                        element.annotate(Query.class, builder -> builder.member("rawCountQuery", finalCq));
                                    }
                                    this.parameterBindingToIndex((AnnotationValueBuilder<DataMethod>)annotationBuilder, parameters, finalParameterBinding, methodMatchContext, supportsImplicitQueries, "countParameters", "parameterBinding");
                                } else {
                                    this.parameterBindingToIndex((AnnotationValueBuilder<DataMethod>)annotationBuilder, parameters, finalParameterBinding, methodMatchContext, supportsImplicitQueries, "parameterBinding");
                                }
                            }
                            if (finalPreparedCount1 != null) {
                                this.parameterBindingToIndex((AnnotationValueBuilder<DataMethod>)annotationBuilder, parameters, finalPreparedCount1.getParameters(), methodMatchContext, supportsImplicitQueries, "countParameters");
                            }
                            Optional<ParameterElement> entityParam = Arrays.stream(parameters).filter(p -> {
                                ClassElement t = p.getGenericType();
                                return t.isAssignable(entity.getName());
                            }).findFirst();
                            entityParam.ifPresent(parameterElement -> annotationBuilder.member("entity", parameterElement.getName()));
                            for (Map.Entry<String, String> entry : methodInfo.getParameterRoles().entrySet()) {
                                annotationBuilder.member(entry.getKey(), entry.getValue());
                            }
                            if (queryObject != null) {
                                long offset;
                                int max;
                                if (queryObject instanceof RawQuery) {
                                    element.annotate(Query.class, builder -> {
                                        String q = element.stringValue(Query.class).orElse(null);
                                        q = this.replaceNamedParameters(this.queryEncoder, q);
                                        builder.member("rawQuery", q);
                                    });
                                }
                                if ((max = queryObject.getMax()) > -1) {
                                    annotationBuilder.member("pageSize", max);
                                }
                                if ((offset = queryObject.getOffset()) > 0L) {
                                    annotationBuilder.member("pageIndex", offset);
                                }
                            }
                        });
                        return;
                    }
                    methodMatchContext.fail("Unable to implement Repository method: " + this.currentRepository.getSimpleName() + "." + element.getName() + "(..). No possible runtime implementations found.");
                    this.failing = true;
                    return;
                }
                this.failing = methodMatchContext.isFailing();
            }
            this.failing = true;
            if (matchContext.isPossiblyFailing()) {
                matchContext.logPossibleFailures();
            } else {
                String messageStart = matchContext.getUnableToImplementMessage();
                context.fail(messageStart + "No possible implementations found.", (Element)element);
            }
        }
    }

    private String replaceNamedParameters(QueryBuilder queryEncoder, String query) {
        if (queryEncoder instanceof SqlQueryBuilder && StringUtils.isNotEmpty((CharSequence)query)) {
            Matcher matcher = QueryBuilder.VARIABLE_PATTERN.matcher(query);
            query = matcher.replaceAll("$1?");
        }
        return query;
    }

    private void parameterBindingToIndex(AnnotationValueBuilder<DataMethod> annotationBuilder, ParameterElement[] parameters, Map<String, String> finalParameterBinding, MethodMatchContext methodMatchContext, boolean includeNames, String ... members) {
        List parameterNames = Arrays.stream(parameters).map(parameterElement -> parameterElement.stringValue(Parameter.class).orElse(parameterElement.getName())).collect(Collectors.toList());
        int len = finalParameterBinding.size();
        String[] parameterPaths = new String[len];
        String[] nameIndex = new String[len];
        AtomicInteger ai = new AtomicInteger(0);
        int[] parameterIndices = finalParameterBinding.entrySet().stream().map(entry -> {
            String parameterName = (String)entry.getValue();
            int pathIndex = ai.getAndIncrement();
            parameterPaths[pathIndex] = "";
            nameIndex[pathIndex] = (String)entry.getKey();
            int i = parameterNames.indexOf(parameterName);
            if (i > -1) {
                return i;
            }
            int j = parameterName.indexOf(46);
            if (j > -1) {
                String prop = parameterName.substring(0, j);
                int paramIndex = parameterNames.indexOf(prop);
                parameterPaths[pathIndex] = paramIndex + "." + parameterName.substring(j + 1);
                return -1;
            }
            Map<String, Element> parametersInRole = methodMatchContext.getParametersInRole();
            for (Map.Entry<String, Element> roleEntry : parametersInRole.entrySet()) {
                String name;
                Element element = roleEntry.getValue();
                if (!(element instanceof PropertyElement) || !(name = element.getName()).equals(parameterName)) continue;
                parameterPaths[pathIndex] = name;
                break;
            }
            return -1;
        }).mapToInt(i -> i).toArray();
        for (String member : members) {
            annotationBuilder.member(member, parameterIndices);
            annotationBuilder.member(member + "Paths", parameterPaths);
            if (!includeNames) continue;
            annotationBuilder.member(member + "Names", nameIndex);
        }
    }

    private void addParameterTypeDefinitions(MethodMatchContext matchContext, Map<String, String> parameterBinding, ParameterElement[] parameters, AnnotationValueBuilder<DataMethod> annotationBuilder, Map<String, DataType> parameterTypes) {
        if (!matchContext.supportsImplicitQueries()) {
            Map<String, ParameterElement> paramMap = Arrays.stream(parameters).collect(Collectors.toMap(Element::getName, p -> p));
            DataType[] parameterDataTypes = new DataType[parameterBinding.size()];
            int i = 0;
            for (String value : parameterBinding.values()) {
                ParameterElement parameter = paramMap.get(value);
                if (parameter != null) {
                    DataType dt = parameterTypes.get(parameter.getName());
                    ClassElement genericType = parameter.getGenericType();
                    if (TypeUtils.isEntityContainerType(genericType) || genericType.hasStereotype(MappedEntity.class)) {
                        dt = DataType.ENTITY;
                    }
                    if (dt == null) {
                        if (TypeUtils.isContainerType(genericType)) {
                            genericType = genericType.getFirstTypeArgument().orElse(genericType);
                        }
                        ClassElement finalGenericType = genericType;
                        dt = parameter.enumValue(TypeDef.class, "type", DataType.class).orElseGet(() -> TypeUtils.resolveDataType(finalGenericType, this.dataTypes));
                    }
                    parameterDataTypes[i++] = dt;
                    continue;
                }
                int dot = value.indexOf(46);
                if (dot > -1) {
                    String val = value.substring(0, dot);
                    ParameterElement parameterElement = paramMap.get(val);
                    if (parameterElement != null) {
                        SourcePersistentEntity sourcePersistentEntity = this.resolvePersistentEntity(parameterElement.getGenericType());
                        if (sourcePersistentEntity != null) {
                            String name = value.substring(dot + 1);
                            SourcePersistentProperty subProp = this.findProp(sourcePersistentEntity, name);
                            if (subProp != null) {
                                parameterDataTypes[i++] = subProp.getDataType();
                                continue;
                            }
                            parameterDataTypes[i++] = DataType.OBJECT;
                            continue;
                        }
                        parameterDataTypes[i++] = DataType.OBJECT;
                        continue;
                    }
                    parameterDataTypes[i++] = DataType.OBJECT;
                    continue;
                }
                SourcePersistentProperty prop = this.findProp(matchContext, value);
                if (prop != null) {
                    parameterDataTypes[i++] = prop.getDataType();
                    continue;
                }
                parameterDataTypes[i++] = DataType.OBJECT;
            }
            annotationBuilder.member("parameterTypeDefs", (Enum[])parameterDataTypes);
        }
    }

    private SourcePersistentProperty findProp(MethodMatchContext matchContext, String name) {
        SourcePersistentEntity rootEntity = matchContext.getRootEntity();
        return this.findProp(rootEntity, name);
    }

    private SourcePersistentProperty findProp(SourcePersistentEntity rootEntity, String name) {
        SourcePersistentProperty identity;
        SourcePersistentProperty prop = rootEntity.getPropertyByName(name);
        if (prop == null && (identity = rootEntity.getIdentity()) != null && identity.getName().equals(name)) {
            prop = identity;
        }
        return prop;
    }

    private AnnotationValue<?>[] parameterBindingToAnnotationValues(Map<String, String> finalParameterBinding) {
        AnnotationValue[] annotationParameters = new AnnotationValue[finalParameterBinding.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : finalParameterBinding.entrySet()) {
            annotationParameters[i++] = AnnotationValue.builder(Property.class).member("name", entry.getKey()).member("value", entry.getValue()).build();
        }
        return annotationParameters;
    }

    private List<MethodCandidate> initializeMethodCandidates(VisitorContext context) {
        List<MethodCandidate> finderList = Arrays.asList(new FindByFinder(), new ExistsByFinder(), new SaveEntityMethod(), new SaveOneMethod(), new SaveAllMethod(), new ListMethod(), new CountMethod(), new DeleteByMethod(), new DeleteMethod(), new CountByMethod(), new UpdateMethod(), new UpdateEntityMethod(), new UpdateByMethod(), new ListSliceMethod(), new FindSliceByMethod(), new ListSliceMethod(), new FindPageByMethod(), new ListPageMethod(), new FindOneMethod(), new FindByIdsMethod(), new FindOneSpecificationMethod(), new CountSpecificationMethod(), new FindAllSpecificationMethod(), new FindPageSpecificationMethod());
        SoftServiceLoader otherCandidates = SoftServiceLoader.load(MethodCandidate.class);
        for (ServiceDefinition definition : otherCandidates) {
            if (!definition.isPresent()) continue;
            try {
                finderList.add((MethodCandidate)definition.load());
            }
            catch (Exception e) {
                context.warn("Could not load Data method candidate [" + definition.getName() + "]: " + e.getMessage(), null);
            }
        }
        OrderUtil.sort(finderList);
        return finderList;
    }

    @Nullable
    private String resolveIdType(PersistentEntity entity) {
        ClassElement ce;
        Map typeArguments = this.currentRepository.getTypeArguments(GenericRepository.class);
        String varName = "ID";
        if (typeArguments.isEmpty()) {
            typeArguments = this.currentRepository.getTypeArguments(SPRING_REPO);
        }
        if (!typeArguments.isEmpty() && (ce = (ClassElement)typeArguments.get(varName)) != null) {
            return ce.getName();
        }
        PersistentProperty identity = entity.getIdentity();
        if (identity != null) {
            return identity.getName();
        }
        return null;
    }

    @Nullable
    private SourcePersistentEntity resolvePersistentEntity(MethodElement element, Map<String, Element> parametersInRole, VisitorContext context) {
        ClassElement returnType = element.getGenericReturnType();
        SourcePersistentEntity entity = this.resolveEntityForCurrentClass();
        if (entity == null) {
            entity = this.resolvePersistentEntity(returnType);
        }
        if (entity != null) {
            List propertiesInRole = entity.getPersistentProperties().stream().filter(pp -> pp.getAnnotationMetadata().hasStereotype(TypeRole.class)).collect(Collectors.toList());
            for (PersistentProperty persistentProperty : propertiesInRole) {
                String role = persistentProperty.getAnnotationMetadata().getValue(TypeRole.class, "role", String.class).orElse(null);
                if (role == null) continue;
                parametersInRole.put(role, (Element)((SourcePersistentProperty)persistentProperty).getPropertyElement());
            }
            return entity;
        }
        context.fail("Could not resolved root entity. Either implement the Repository interface or define the entity as part of the signature", (Element)element);
        return null;
    }

    private SourcePersistentEntity resolveEntityForCurrentClass() {
        ClassElement ce;
        SourcePersistentEntity entity = null;
        Map typeArguments = this.currentRepository.getTypeArguments(GenericRepository.class);
        String argName = "E";
        if (typeArguments.isEmpty()) {
            argName = "T";
            typeArguments = this.currentRepository.getTypeArguments(SPRING_REPO);
        }
        if (!typeArguments.isEmpty() && (ce = (ClassElement)typeArguments.get(argName)) != null) {
            return this.entityResolver.apply(ce);
        }
        return entity;
    }

    private SourcePersistentEntity resolvePersistentEntity(ClassElement returnType) {
        if (returnType != null) {
            if (returnType.hasAnnotation(MappedEntity.class) || returnType.hasStereotype(Embeddable.class)) {
                return this.entityResolver.apply(returnType);
            }
            Collection typeArguments = returnType.getTypeArguments().values();
            for (ClassElement typeArgument : typeArguments) {
                SourcePersistentEntity entity = this.resolvePersistentEntity(typeArgument);
                if (entity == null) continue;
                return entity;
            }
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$visitMethod$8(String requiredParam, ParameterElement p) {
        return p.stringValue(Parameter.class).orElse(p.getName()).equals(requiredParam);
    }
}

