/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.annotation.Where;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.visitors.AnnotationMetadataHierarchy;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractPatternBasedMethod;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.ProjectionMethodExpression;
import io.micronaut.data.processor.visitors.finders.RawQuery;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractListMethod
extends AbstractPatternBasedMethod {
    protected AbstractListMethod(String ... prefixes) {
        super(AbstractListMethod.computePattern(prefixes));
    }

    @Override
    @Nullable
    public MethodMatchInfo buildMatchInfo(@NonNull MethodMatchContext matchContext) {
        List<ParameterElement> queryParams = matchContext.getParametersNotInRole();
        RawQuery query = null;
        MethodElement methodElement = matchContext.getMethodElement();
        SourcePersistentEntity rootEntity = matchContext.getRootEntity();
        ClassElement queryResultType = rootEntity.getClassElement();
        if (methodElement.hasAnnotation(Query.class)) {
            query = this.buildRawQuery(matchContext);
        } else {
            List<AnnotationValue<Join>> joinSpecs;
            String methodName;
            Matcher matcher;
            if (CollectionUtils.isNotEmpty(queryParams)) {
                query = QueryModel.from((PersistentEntity)rootEntity);
                for (ParameterElement queryParam : queryParams) {
                    String paramName = queryParam.getName();
                    PersistentProperty prop = rootEntity.getPropertyByName(paramName);
                    if (prop == null) {
                        SourcePersistentProperty identity = rootEntity.getIdentity();
                        if (identity != null && identity.getName().equals(paramName)) {
                            query.idEq(new QueryParameter(queryParam.getName()));
                            continue;
                        }
                        matchContext.fail("Cannot query entity [" + rootEntity.getSimpleName() + "] on non-existent property: " + paramName);
                        return null;
                    }
                    query.eq(prop.getName(), new QueryParameter(queryParam.getName()));
                }
            }
            if ((matcher = this.pattern.matcher(methodName = methodElement.getName())).find()) {
                String querySequence = matcher.group(3);
                ArrayList<Sort.Order> orderBys = new ArrayList<Sort.Order>(2);
                querySequence = this.matchOrder(querySequence, orderBys);
                if (CollectionUtils.isNotEmpty(orderBys)) {
                    if (query == null) {
                        query = QueryModel.from((PersistentEntity)rootEntity);
                    }
                    if (this.applyOrderBy(matchContext, query, orderBys)) {
                        return null;
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)querySequence)) {
                    ArrayList<ProjectionMethodExpression> projections = new ArrayList<ProjectionMethodExpression>();
                    this.matchProjections(matchContext, projections, querySequence);
                    if (CollectionUtils.isNotEmpty(projections)) {
                        if (query == null) {
                            query = QueryModel.from((PersistentEntity)rootEntity);
                        }
                        for (ProjectionMethodExpression projection : projections) {
                            projection.apply(matchContext, query);
                            queryResultType = projection.getExpectedResultType();
                        }
                        if (projections.size() > 1) {
                            queryResultType = matchContext.getVisitorContext().getClassElement(Object.class).orElse(rootEntity.getClassElement());
                        }
                        for (ProjectionMethodExpression projection : query.getProjections()) {
                            QueryModel.PropertyProjection pp;
                            String prop;
                            Optional path;
                            if (!(projection instanceof QueryModel.PropertyProjection) || (path = rootEntity.getPath(prop = (pp = (QueryModel.PropertyProjection)projection).getPropertyName())).isPresent()) continue;
                            matchContext.fail("Cannot project on non-existent property: " + prop);
                            return null;
                        }
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(joinSpecs = this.joinSpecsAtMatchContext(matchContext))) {
                if (query == null) {
                    query = QueryModel.from((PersistentEntity)rootEntity);
                }
                if (this.applyJoinSpecs(matchContext, query, rootEntity, joinSpecs)) {
                    return null;
                }
            }
        }
        if (query != null) {
            return this.buildInfo(matchContext, queryResultType, query);
        }
        if (matchContext.supportsImplicitQueries() && this.hasNoWhereDeclaration(matchContext)) {
            return this.buildInfo(matchContext, queryResultType, null);
        }
        return this.buildInfo(matchContext, queryResultType, QueryModel.from((PersistentEntity)rootEntity));
    }

    private boolean hasNoWhereDeclaration(@NonNull MethodMatchContext matchContext) {
        boolean repositoryHasWhere = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{matchContext.getRepositoryClass(), matchContext.getMethodElement()}).hasAnnotation(Where.class);
        boolean entityHasWhere = matchContext.getRootEntity().hasAnnotation(Where.class);
        return !repositoryHasWhere && !entityHasWhere;
    }

    private static Pattern computePattern(String[] prefixes) {
        String prefixPattern = String.join((CharSequence)"|", prefixes);
        return Pattern.compile("^((" + prefixPattern + ")(\\S*?))$");
    }
}

