/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.data.intercept.SaveAllInterceptor;
import io.micronaut.data.intercept.async.SaveAllAsyncInterceptor;
import io.micronaut.data.intercept.reactive.SaveAllReactiveInterceptor;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractPatternBasedMethod;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import java.util.regex.Pattern;

public class SaveAllMethod
extends AbstractPatternBasedMethod {
    private static final String METHOD_PATTERN = "^((save|persist|store|insert)(\\S*?))$";

    public SaveAllMethod() {
        super(Pattern.compile(METHOD_PATTERN));
    }

    @Override
    public boolean isMethodMatch(MethodElement methodElement, MatchContext matchContext) {
        ParameterElement[] parameters = methodElement.getParameters();
        if (parameters.length == 1 && super.isMethodMatch(methodElement, matchContext)) {
            ParameterElement firstParameter = parameters[0];
            ClassElement parameterType = firstParameter.getGenericType();
            if (TypeUtils.isReactiveOrFuture(parameterType)) {
                parameterType = parameterType.getFirstTypeArgument().orElse(null);
            }
            return TypeUtils.isIterableOfEntity(parameterType);
        }
        return false;
    }

    @Override
    @Nullable
    public MethodMatchInfo buildMatchInfo(@NonNull MethodMatchContext matchContext) {
        ClassElement returnType = matchContext.getReturnType();
        Class interceptor = TypeUtils.isFutureType(returnType) ? SaveAllAsyncInterceptor.class : (TypeUtils.isReactiveType(returnType) ? SaveAllReactiveInterceptor.class : SaveAllInterceptor.class);
        if (matchContext.supportsImplicitQueries()) {
            return new MethodMatchInfo(null, null, interceptor, MethodMatchInfo.OperationType.INSERT, new String[0]);
        }
        return new MethodMatchInfo(null, QueryModel.from((PersistentEntity)matchContext.getRootEntity()), interceptor, MethodMatchInfo.OperationType.INSERT, new String[0]);
    }
}

