/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.data.intercept.CountInterceptor;
import io.micronaut.data.intercept.async.CountAsyncInterceptor;
import io.micronaut.data.intercept.reactive.CountReactiveInterceptor;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.query.ProjectionList;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.DynamicFinder;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.TypedElement;

public class CountByMethod
extends DynamicFinder {
    public CountByMethod() {
        super("count");
    }

    @Override
    @Nullable
    protected MethodMatchInfo buildInfo(@NonNull MethodMatchContext matchContext, @NonNull ClassElement queryResultType, @Nullable QueryModel query) {
        return CountByMethod.buildCountInfo(matchContext, query);
    }

    @Override
    public boolean isMethodMatch(MethodElement methodElement, MatchContext matchContext) {
        return super.isMethodMatch(methodElement, matchContext) && CountByMethod.isValidCountReturnType(methodElement, matchContext);
    }

    static MethodMatchInfo buildCountInfo(@NonNull MethodMatchContext matchContext, @Nullable QueryModel query) {
        Class<CountInterceptor> interceptor = CountInterceptor.class;
        ClassElement returnType = matchContext.getReturnType();
        if (TypeUtils.isFutureType(returnType)) {
            interceptor = CountAsyncInterceptor.class;
            returnType = returnType.getGenericType().getFirstTypeArgument().orElse(returnType);
        } else if (TypeUtils.isReactiveType(returnType)) {
            interceptor = CountReactiveInterceptor.class;
            returnType = returnType.getGenericType().getFirstTypeArgument().orElse(returnType);
        }
        if (query != null) {
            ProjectionList projections = query.projections();
            projections.count();
            return new MethodMatchInfo((TypedElement)returnType, query, interceptor);
        }
        return new MethodMatchInfo((TypedElement)returnType, matchContext.supportsImplicitQueries() ? null : QueryModel.from((PersistentEntity)matchContext.getRootEntity()), interceptor);
    }

    static boolean isValidCountReturnType(MethodElement methodElement, MatchContext matchContext) {
        return TypeUtils.doesReturnNumber(methodElement) || TypeUtils.isReactiveOrFuture(matchContext.getReturnType()) && TypeUtils.isNumber(matchContext.getReturnType().getFirstTypeArgument().orElse(null));
    }
}

