/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.inject.ast.TypedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MethodMatchInfo {
    private final TypedElement resultType;
    private final QueryModel query;
    private final Class<? extends DataInterceptor> interceptor;
    private final OperationType operationType;
    private final String[] updateProperties;
    private Map<String, String> parameterRoles = new HashMap<String, String>(2);
    private boolean dto;

    public MethodMatchInfo(@Nullable TypedElement resultType, @Nullable QueryModel query, @Nullable Class<? extends DataInterceptor> interceptor) {
        this(resultType, query, interceptor, OperationType.QUERY, new String[0]);
    }

    public MethodMatchInfo(@Nullable TypedElement resultType, @Nullable QueryModel query, @Nullable Class<? extends DataInterceptor> interceptor, boolean dto) {
        this(resultType, query, interceptor, OperationType.QUERY, new String[0]);
        this.dto = dto;
    }

    public MethodMatchInfo(@Nullable TypedElement resultType, @Nullable QueryModel query, @Nullable Class<? extends DataInterceptor> interceptor, @NonNull OperationType operationType, String ... updateProperties) {
        this.query = query;
        this.interceptor = interceptor;
        this.operationType = operationType;
        this.resultType = resultType;
        this.updateProperties = updateProperties;
    }

    public boolean isDto() {
        return this.dto;
    }

    public void addParameterRole(CharSequence role, String name) {
        this.parameterRoles.put(role.toString(), name);
    }

    public Map<String, String> getParameterRoles() {
        return Collections.unmodifiableMap(this.parameterRoles);
    }

    @NonNull
    public List<String> getUpdateProperties() {
        if (this.updateProperties == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.updateProperties);
    }

    @Nullable
    public TypedElement getResultType() {
        return this.resultType;
    }

    @Nullable
    public QueryModel getQuery() {
        return this.query;
    }

    @Nullable
    public Class<? extends DataInterceptor> getRuntimeInterceptor() {
        return this.interceptor;
    }

    @NonNull
    public OperationType getOperationType() {
        return this.operationType;
    }

    public static enum OperationType {
        QUERY,
        UPDATE,
        DELETE,
        INSERT;

    }
}

