/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MethodMatchContext
extends MatchContext {
    @NonNull
    private final SourcePersistentEntity entity;
    private final Map<String, Element> parametersInRole;
    private final Function<ClassElement, SourcePersistentEntity> entityResolver;

    MethodMatchContext(@NonNull ClassElement repositoryClass, @NonNull SourcePersistentEntity entity, @NonNull VisitorContext visitorContext, @NonNull ClassElement returnType, @NonNull MethodElement methodElement, @NonNull Map<String, Element> parametersInRole, @NonNull Map<String, String> typeRoles, @NonNull ParameterElement[] parameters, @NonNull Function<ClassElement, SourcePersistentEntity> entityResolver) {
        super(repositoryClass, visitorContext, methodElement, typeRoles, returnType, parameters);
        this.entity = entity;
        this.parametersInRole = Collections.unmodifiableMap(parametersInRole);
        this.entityResolver = entityResolver;
    }

    public boolean hasParameterInRole(@NonNull String role) {
        return role != null && this.parametersInRole.containsKey(role);
    }

    @NonNull
    public Map<String, Element> getParametersInRole() {
        return this.parametersInRole;
    }

    @NonNull
    public SourcePersistentEntity getRootEntity() {
        return this.entity;
    }

    @NonNull
    public List<ParameterElement> getParametersNotInRole() {
        return Arrays.stream(this.getParameters()).filter(p -> !this.parametersInRole.containsValue(p)).collect(Collectors.toList());
    }

    @NonNull
    public SourcePersistentEntity getEntity(@NonNull ClassElement element) {
        return this.entityResolver.apply(element);
    }
}

