/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.AssociationQuery;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractPatternBasedMethod;
import io.micronaut.data.processor.visitors.finders.CriterionMethodExpression;
import io.micronaut.data.processor.visitors.finders.MethodCandidate;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.ProjectionMethodExpression;
import io.micronaut.data.processor.visitors.finders.RawQuery;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class DynamicFinder
extends AbstractPatternBasedMethod
implements MethodCandidate {
    public static final String OPERATOR_OR = "Or";
    public static final String OPERATOR_AND = "And";
    public static final String[] OPERATORS = new String[]{"And", "Or"};
    private static final String NOT = "Not";
    private static final Map<String, Constructor> METHOD_EXPRESSIONS = new LinkedHashMap<String, Constructor>();
    private static Pattern methodExpressionPattern;
    private Pattern[] operatorPatterns;
    private String[] operators;

    protected DynamicFinder(String ... prefixes) {
        this(DynamicFinder.compilePattern(prefixes), OPERATORS);
    }

    protected DynamicFinder(Pattern pattern, String[] operators) {
        super(pattern);
        this.operators = operators;
        this.operatorPatterns = new Pattern[operators.length];
        this.populateOperators(operators);
    }

    @Override
    public boolean isMethodMatch(@NonNull MethodElement methodElement, @NonNull MatchContext matchContext) {
        String methodName = methodElement.getName();
        return methodElement.hasAnnotation(Query.class) || this.pattern.matcher(methodName.subSequence(0, methodName.length())).find();
    }

    @Override
    public MethodMatchInfo buildMatchInfo(@NonNull MethodMatchContext matchContext) {
        MethodElement methodElement = matchContext.getMethodElement();
        if (methodElement.hasAnnotation(Query.class)) {
            RawQuery rawQuery = this.buildRawQuery(matchContext);
            if (rawQuery == null) {
                return null;
            }
            return this.buildInfo(matchContext, matchContext.getRootEntity().getClassElement(), rawQuery);
        }
        ArrayList<CriterionMethodExpression> expressions = new ArrayList<CriterionMethodExpression>();
        ArrayList<ProjectionMethodExpression> projectionExpressions = new ArrayList<ProjectionMethodExpression>();
        ParameterElement[] parameters = matchContext.getParameters();
        String methodName = methodElement.getName();
        SourcePersistentEntity entity = matchContext.getRootEntity();
        VisitorContext visitorContext = matchContext.getVisitorContext();
        Matcher match = this.pattern.matcher(methodName);
        match.find();
        int totalRequiredArguments = 0;
        ArrayList<Sort.Order> orderList = new ArrayList<Sort.Order>();
        String querySequence = this.matchOrder(match.group(4), orderList);
        String projectionSequence = match.group(3);
        if (projectionSequence.endsWith("Order") && methodName.contains("OrderBy" + querySequence)) {
            return null;
        }
        boolean containsOperator = false;
        String operatorInUse = null;
        if (querySequence != null) {
            for (int i = 0; i < this.operators.length; ++i) {
                Matcher currentMatcher = this.operatorPatterns[i].matcher(querySequence);
                if (!currentMatcher.find()) continue;
                containsOperator = true;
                operatorInUse = this.operators[i];
                String[] queryParameters = querySequence.split(operatorInUse);
                int argumentCursor = 0;
                for (String queryParameter : queryParameters) {
                    CriterionMethodExpression currentExpression = DynamicFinder.findMethodExpression(entity, queryParameter);
                    int requiredArgs = currentExpression.getArgumentsRequired();
                    String[] currentArguments = new String[requiredArgs];
                    if (argumentCursor + requiredArgs > parameters.length) {
                        visitorContext.fail("Insufficient arguments to method", (Element)methodElement);
                        return null;
                    }
                    int k = 0;
                    while (k < requiredArgs) {
                        ParameterElement argument = parameters[argumentCursor];
                        this.verifyFinderParameter(methodName, entity, currentExpression, argument);
                        currentArguments[k] = argument.getName();
                        ++k;
                        ++argumentCursor;
                    }
                    this.initializeExpression(currentExpression, currentArguments);
                    totalRequiredArguments += currentExpression.argumentsRequired;
                    expressions.add(currentExpression);
                }
                break;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)projectionSequence)) {
            boolean processedThroughOperator = false;
            for (int i = 0; i < this.operators.length; ++i) {
                String[] projections;
                Matcher currentMatcher = this.operatorPatterns[i].matcher(projectionSequence);
                if (!currentMatcher.find()) continue;
                processedThroughOperator = true;
                for (String projection : projections = projectionSequence.split(this.operators[i])) {
                    this.matchProjections(matchContext, projectionExpressions, projection);
                }
                break;
            }
            if (!processedThroughOperator) {
                this.matchProjections(matchContext, projectionExpressions, projectionSequence);
            }
        }
        if (!containsOperator && querySequence != null) {
            CriterionMethodExpression solo = DynamicFinder.findMethodExpression(entity, querySequence);
            int requiredArguments = solo.getArgumentsRequired();
            if (requiredArguments > parameters.length) {
                visitorContext.fail("Insufficient arguments to method", (Element)methodElement);
                return null;
            }
            totalRequiredArguments += requiredArguments;
            String[] soloArgs = new String[requiredArguments];
            for (int i = 0; i < soloArgs.length; ++i) {
                ParameterElement parameter = parameters[i];
                this.verifyFinderParameter(methodName, entity, solo, parameter);
                soloArgs[i] = parameter.getName();
            }
            this.initializeExpression(solo, soloArgs);
            expressions.add(solo);
        }
        if (totalRequiredArguments > parameters.length) {
            visitorContext.fail("Insufficient arguments to method", (Element)methodElement);
            return null;
        }
        QueryModel query = QueryModel.from((PersistentEntity)entity);
        ClassElement queryResultType = entity.getClassElement();
        List joinSpecs = methodElement.getAnnotationValuesByType(Join.class);
        if (CollectionUtils.isNotEmpty((Collection)joinSpecs) && this.applyJoinSpecs(matchContext, query, entity, joinSpecs)) {
            return null;
        }
        if (this.applyOrderBy(matchContext, query, orderList)) {
            return null;
        }
        if (CollectionUtils.isNotEmpty(projectionExpressions)) {
            if (projectionExpressions.size() == 1) {
                ProjectionMethodExpression projection = (ProjectionMethodExpression)projectionExpressions.get(0);
                queryResultType = projection.getExpectedResultType();
                projection.apply(matchContext, query);
            } else {
                for (ProjectionMethodExpression projectionExpression : projectionExpressions) {
                    projectionExpression.apply(matchContext, query);
                }
            }
        }
        if (OPERATOR_OR.equalsIgnoreCase(operatorInUse)) {
            QueryModel.Disjunction disjunction = new QueryModel.Disjunction();
            for (CriterionMethodExpression expression : expressions) {
                disjunction.add(expression.createCriterion());
            }
            query.add((QueryModel.Criterion)disjunction);
        } else {
            for (CriterionMethodExpression expression : expressions) {
                QueryModel.Criterion criterion = expression.createCriterion();
                if (criterion instanceof QueryModel.Equals) {
                    QueryModel.Equals equals = (QueryModel.Equals)criterion;
                    String property = equals.getProperty();
                    SourcePersistentProperty identity = entity.getIdentity();
                    if (identity != null && identity.getName().equals(property)) {
                        query.idEq((QueryParameter)equals.getValue());
                        continue;
                    }
                    query.add(criterion);
                    continue;
                }
                query.add(criterion);
            }
        }
        return this.buildInfo(matchContext, queryResultType, query);
    }

    private void verifyFinderParameter(String methodName, SourcePersistentEntity entity, CriterionMethodExpression methodExpression, ParameterElement parameter) {
        String propertyName = methodExpression.propertyName;
        boolean isID = propertyName.equals("id");
        SourcePersistentProperty persistentProperty = (SourcePersistentProperty)entity.getPropertyByPath(propertyName).orElseGet(() -> {
            SourcePersistentProperty identity;
            if (isID && (identity = entity.getIdentity()) != null) {
                return identity;
            }
            throw new IllegalArgumentException("Cannot query entity [" + entity.getSimpleName() + "] on non-existent property: " + propertyName);
        });
        ClassElement genericType = parameter.getGenericType();
        if (!(TypeUtils.areTypesCompatible(genericType, persistentProperty.getType()) || isID || genericType.isAssignable(Iterable.class))) {
            throw new IllegalArgumentException("Parameter [" + parameter.getName() + "] of method [" + methodName + "] is not compatible with property [" + persistentProperty.getName() + "] of entity: " + entity.getName());
        }
    }

    private void initializeExpression(CriterionMethodExpression currentExpression, String[] currentArguments) {
        currentExpression.setArgumentNames(currentArguments);
    }

    private static Pattern compilePattern(String[] prefixes) {
        if (ArrayUtils.isEmpty((Object[])prefixes)) {
            throw new IllegalArgumentException("At least one prefix required");
        }
        String prefixPattern = String.join((CharSequence)"|", prefixes);
        String patternStr = "((" + prefixPattern + ")([\\w\\d]*?)By)([A-Z]\\w*)";
        return Pattern.compile(patternStr);
    }

    private static CriterionMethodExpression findMethodExpression(SourcePersistentEntity entity, String expression) {
        Object me = null;
        Matcher matcher = methodExpressionPattern.matcher(expression);
        Class methodExpressionClass = CriterionMethodExpression.Equal.class;
        Constructor methodExpressionConstructor = null;
        String clause = methodExpressionClass.getSimpleName();
        if (matcher.find() && (methodExpressionConstructor = METHOD_EXPRESSIONS.get(clause = matcher.group(1))) != null) {
            methodExpressionClass = methodExpressionConstructor.getDeclaringClass();
        }
        String propertyName = DynamicFinder.calcPropertyName(expression, methodExpressionClass.getSimpleName());
        boolean negation = false;
        if (propertyName.endsWith(NOT)) {
            int i = propertyName.lastIndexOf(NOT);
            propertyName = propertyName.substring(0, i);
            negation = true;
        }
        if (StringUtils.isEmpty((CharSequence)propertyName)) {
            throw new IllegalArgumentException("No property name specified in clause: " + clause);
        }
        SourcePersistentProperty prop = entity.getPropertyByName(propertyName = NameUtils.decapitalize((String)propertyName));
        if (prop == null) {
            String associationPath;
            SourcePersistentProperty pp;
            int i;
            String path;
            PersistentProperty persistentProperty;
            Optional propertyPath = entity.getPath(propertyName);
            if (propertyPath.isPresent() && (persistentProperty = (PersistentProperty)entity.getPropertyByPath(path = (String)propertyPath.get()).orElse(null)) != null && (i = path.lastIndexOf(46)) > -1 && (pp = (SourcePersistentProperty)entity.getPropertyByPath(associationPath = path.substring(0, i)).orElse(null)) instanceof Association) {
                final AssociationQuery finalQuery = new AssociationQuery(associationPath, (Association)pp);
                final CriterionMethodExpression finalSubExpression = DynamicFinder.buildCriterionExpression(methodExpressionConstructor, persistentProperty.getName(), negation);
                return new CriterionMethodExpression(path){

                    @Override
                    public QueryModel.Criterion createCriterion() {
                        QueryModel.Criterion c = finalSubExpression.createCriterion();
                        finalQuery.add(c);
                        return finalQuery;
                    }

                    @Override
                    public int getArgumentsRequired() {
                        return finalSubExpression.getArgumentsRequired();
                    }

                    @Override
                    public void setArgumentNames(String[] argumentNames) {
                        finalSubExpression.setArgumentNames(argumentNames);
                    }
                };
            }
            return DynamicFinder.buildCriterionExpression(methodExpressionConstructor, propertyName, negation);
        }
        return DynamicFinder.buildCriterionExpression(methodExpressionConstructor, propertyName, negation);
    }

    private static CriterionMethodExpression buildCriterionExpression(Constructor methodExpressionConstructor, String propertyName, boolean negation) {
        CriterionMethodExpression me = null;
        if (methodExpressionConstructor != null) {
            try {
                me = (CriterionMethodExpression)methodExpressionConstructor.newInstance(propertyName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (me == null) {
            me = new CriterionMethodExpression.Equal(propertyName);
        }
        if (negation) {
            final CriterionMethodExpression.Equal finalMe = me;
            return new CriterionMethodExpression(propertyName){

                @Override
                public QueryModel.Criterion createCriterion() {
                    return new QueryModel.Negation().add(finalMe.createCriterion());
                }

                @Override
                public int getArgumentsRequired() {
                    return finalMe.getArgumentsRequired();
                }

                @Override
                public void setArgumentNames(String[] argumentNames) {
                    finalMe.setArgumentNames(argumentNames);
                }
            };
        }
        return me;
    }

    private static void resetMethodExpressionPattern() {
        String expressionPattern = String.join((CharSequence)"|", METHOD_EXPRESSIONS.keySet());
        methodExpressionPattern = Pattern.compile("\\p{Upper}[\\p{Lower}\\d]+(" + expressionPattern + ")");
    }

    private void populateOperators(String[] operators) {
        for (int i = 0; i < operators.length; ++i) {
            this.operatorPatterns[i] = Pattern.compile("(\\w+)(" + operators[i] + ")(\\p{Upper})(\\w+)");
        }
    }

    private static String calcPropertyName(String queryParameter, String clause) {
        int i;
        String propName = clause != null ? ((i = queryParameter.indexOf(clause)) > -1 ? queryParameter.substring(0, i) : queryParameter) : queryParameter;
        return propName;
    }

    static {
        try {
            Class[] classes = (Class[])Arrays.stream(CriterionMethodExpression.class.getClasses()).filter(c -> CriterionMethodExpression.class.isAssignableFrom((Class<?>)c) && !Modifier.isAbstract(c.getModifiers())).toArray(Class[]::new);
            Class[] constructorParamTypes = new Class[]{String.class};
            for (Class c2 : classes) {
                METHOD_EXPRESSIONS.put(c2.getSimpleName(), c2.getConstructor(constructorParamTypes));
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        DynamicFinder.resetMethodExpressionPattern();
    }
}

