/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Embeddable;
import io.micronaut.data.annotation.Id;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.Transient;
import io.micronaut.data.annotation.Version;
import io.micronaut.data.exceptions.MappingException;
import io.micronaut.data.model.AbstractPersistentEntity;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.processor.model.SourceAssociation;
import io.micronaut.data.processor.model.SourceEmbedded;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

@Internal
public class SourcePersistentEntity
extends AbstractPersistentEntity
implements PersistentEntity,
TypedElement {
    private final ClassElement classElement;
    private final Map<String, PropertyElement> beanProperties;
    private final SourcePersistentProperty[] id;
    private final SourcePersistentProperty version;
    private final Function<ClassElement, SourcePersistentEntity> entityResolver;
    private final List<SourcePersistentProperty> persistentProperties;

    public SourcePersistentEntity(@NonNull ClassElement classElement, @NonNull Function<ClassElement, SourcePersistentEntity> entityResolver) {
        super((AnnotationMetadataProvider)classElement);
        this.entityResolver = entityResolver;
        this.classElement = classElement;
        List beanProperties = classElement.getBeanProperties();
        this.beanProperties = new LinkedHashMap<String, PropertyElement>(beanProperties.size());
        ArrayList<SourcePersistentProperty> id = new ArrayList<SourcePersistentProperty>(2);
        SourcePersistentProperty version = null;
        for (PropertyElement beanProperty : beanProperties) {
            if (beanProperty.getName().equals("metaClass") || beanProperty.hasStereotype(Transient.class)) continue;
            if (beanProperty.hasStereotype(Id.class)) {
                if (beanProperty.enumValue(Relation.class, Relation.Kind.class).map(k -> k == Relation.Kind.EMBEDDED).orElse(false).booleanValue()) {
                    id.add(new SourceEmbedded(this, beanProperty, entityResolver));
                    continue;
                }
                id.add(new SourcePersistentProperty(this, beanProperty));
                continue;
            }
            if (beanProperty.hasStereotype(Version.class)) {
                version = new SourcePersistentProperty(this, beanProperty);
                continue;
            }
            this.beanProperties.put(beanProperty.getName(), beanProperty);
        }
        this.version = version;
        this.id = id.toArray(new SourcePersistentProperty[0]);
        this.persistentProperties = this.beanProperties.values().stream().map(propertyElement -> {
            Optional relation = propertyElement.findAnnotation(Relation.class);
            if (relation.isPresent()) {
                Relation.Kind kind = relation.flatMap(av -> av.enumValue(Relation.Kind.class)).orElse(null);
                if (kind == Relation.Kind.EMBEDDED) {
                    if (!propertyElement.getType().hasStereotype(Embeddable.class)) {
                        throw new MappingException("Type [" + propertyElement.getType().getName() + "] of property [" + propertyElement.getName() + "] of entity [" + this.getName() + "] is missing @Embeddable annotation. @Embedded fields can only be applied to types annotated with @Embeddable");
                    }
                    return new SourceEmbedded(this, (PropertyElement)propertyElement, entityResolver);
                }
                return new SourceAssociation(this, (PropertyElement)propertyElement, entityResolver);
            }
            SourcePersistentProperty pp = new SourcePersistentProperty(this, (PropertyElement)propertyElement);
            if (pp.getDataType() == DataType.ENTITY) {
                return new SourceAssociation(this, (PropertyElement)propertyElement, entityResolver);
            }
            return pp;
        }).collect(Collectors.toList());
    }

    @NonNull
    public String getName() {
        return this.classElement.getName();
    }

    public String getSimpleName() {
        return this.classElement.getSimpleName();
    }

    public boolean isProtected() {
        return this.classElement.isProtected();
    }

    public boolean isPublic() {
        return this.classElement.isPublic();
    }

    public Object getNativeType() {
        return this.classElement.getNativeType();
    }

    @Nullable
    public PersistentProperty[] getCompositeIdentity() {
        return this.id;
    }

    @Nullable
    public SourcePersistentProperty getIdentity() {
        if (ArrayUtils.isNotEmpty((Object[])this.id)) {
            return this.id[0];
        }
        return null;
    }

    @Nullable
    public SourcePersistentProperty getVersion() {
        return this.version;
    }

    @NonNull
    public List<SourcePersistentProperty> getPersistentProperties() {
        return this.persistentProperties;
    }

    @NonNull
    public List<Association> getAssociations() {
        return this.persistentProperties.stream().filter(bp -> bp instanceof Association).map(bp -> (Association)bp).collect(Collectors.toList());
    }

    @NonNull
    public List<Embedded> getEmbedded() {
        return this.persistentProperties.stream().filter(p -> p instanceof Embedded).map(p -> (Embedded)p).collect(Collectors.toList());
    }

    @Nullable
    public SourcePersistentProperty getPropertyByName(String name) {
        PropertyElement prop;
        if (StringUtils.isNotEmpty((CharSequence)name) && (prop = this.beanProperties.get(name)) != null) {
            if (prop.hasStereotype(Relation.class)) {
                if (this.isEmbedded(prop)) {
                    return new SourceEmbedded(this, prop, this.entityResolver);
                }
                return new SourceAssociation(this, prop, this.entityResolver);
            }
            return new SourcePersistentProperty(this, prop);
        }
        return null;
    }

    @NonNull
    public List<String> getPersistentPropertyNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.beanProperties.keySet()));
    }

    public boolean isOwningEntity(PersistentEntity owner) {
        return true;
    }

    @Nullable
    public PersistentEntity getParentEntity() {
        return null;
    }

    public ClassElement getClassElement() {
        return this.classElement;
    }

    @NonNull
    public ClassElement getType() {
        return this.classElement;
    }

    private boolean isEmbedded(PropertyElement bp) {
        return bp.enumValue(Relation.class, Relation.Kind.class).orElse(null) == Relation.Kind.EMBEDDED;
    }

    public String toString() {
        return this.getName();
    }
}

