/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.operations;

import com.mongodb.CursorType;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.mongodb.conf.RequiresSyncMongo;
import io.micronaut.data.mongodb.operations.AbstractMongoRepositoryOperations;
import io.micronaut.data.mongodb.operations.MongoAggregation;
import io.micronaut.data.mongodb.operations.MongoCollectionNameProvider;
import io.micronaut.data.mongodb.operations.MongoDatabaseNameProvider;
import io.micronaut.data.mongodb.operations.MongoDelete;
import io.micronaut.data.mongodb.operations.MongoFind;
import io.micronaut.data.mongodb.operations.MongoPreparedQuery;
import io.micronaut.data.mongodb.operations.MongoRepositoryOperations;
import io.micronaut.data.mongodb.operations.MongoStoredQuery;
import io.micronaut.data.mongodb.operations.MongoUpdate;
import io.micronaut.data.mongodb.operations.MongoUtils;
import io.micronaut.data.mongodb.operations.options.MongoAggregationOptions;
import io.micronaut.data.mongodb.operations.options.MongoFindOptions;
import io.micronaut.data.mongodb.session.MongoConnectionOperations;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.operations.ExecutorAsyncOperations;
import io.micronaut.data.runtime.operations.ExecutorReactiveOperations;
import io.micronaut.data.runtime.operations.internal.AbstractSyncEntitiesOperations;
import io.micronaut.data.runtime.operations.internal.AbstractSyncEntityOperations;
import io.micronaut.data.runtime.operations.internal.OperationContext;
import io.micronaut.data.runtime.operations.internal.SyncCascadeOperations;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

@RequiresSyncMongo
@EachBean(value=MongoClient.class)
@Internal
final class DefaultMongoRepositoryOperations
extends AbstractMongoRepositoryOperations<MongoDatabase>
implements MongoRepositoryOperations,
AsyncCapableRepository,
ReactiveCapableRepository,
SyncCascadeOperations.SyncCascadeOperationsHelper<MongoOperationContext> {
    private final MongoClient mongoClient;
    private final SyncCascadeOperations<MongoOperationContext> cascadeOperations;
    private final MongoConnectionOperations connectionOperations;
    private ExecutorAsyncOperations asyncOperations;
    private ExecutorService executorService;

    DefaultMongoRepositoryOperations(@Nullable @Parameter String serverName, BeanContext beanContext, DateTimeProvider<Object> dateTimeProvider, RuntimeEntityRegistry runtimeEntityRegistry, DataConversionService conversionService, AttributeConverterRegistry attributeConverterRegistry, MongoClient mongoClient, MongoCollectionNameProvider collectionNameProvider, @Named(value="io") @Nullable ExecutorService executorService) {
        super(dateTimeProvider, runtimeEntityRegistry, conversionService, attributeConverterRegistry, collectionNameProvider, (MongoDatabaseNameProvider)beanContext.getBean(MongoDatabaseNameProvider.class, "Primary".equals(serverName) ? null : Qualifiers.byName((String)serverName)));
        this.mongoClient = mongoClient;
        this.cascadeOperations = new SyncCascadeOperations((ConversionService)conversionService, (SyncCascadeOperations.SyncCascadeOperationsHelper)this);
        boolean isPrimary = "Primary".equals(serverName);
        this.connectionOperations = (MongoConnectionOperations)beanContext.getBean(MongoConnectionOperations.class, isPrimary ? null : Qualifiers.byName((String)serverName));
        this.executorService = executorService;
    }

    public <T> T findOne(Class<T> type, Object id) {
        return (T)this.withClientSession(clientSession -> {
            RuntimePersistentEntity persistentEntity = this.runtimeEntityRegistry.getEntity(type);
            MongoDatabase database = this.getDatabase((PersistentEntity)persistentEntity, null);
            MongoCollection collection = this.getCollection(database, persistentEntity, type);
            Bson filter = MongoUtils.filterById((ConversionService)this.conversionService, persistentEntity, id, collection.getCodecRegistry());
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing Mongo 'find' with filter: {}", (Object)filter.toBsonDocument().toJson());
            }
            return collection.find(clientSession, filter, type).first();
        });
    }

    public <T, R> R findOne(PreparedQuery<T, R> preparedQuery) {
        return (R)this.withClientSession(clientSession -> {
            MongoPreparedQuery mongoPreparedQuery = this.getMongoPreparedQuery(preparedQuery);
            if (mongoPreparedQuery.isCount()) {
                return this.getCount((ClientSession)clientSession, mongoPreparedQuery);
            }
            if (mongoPreparedQuery.isAggregate()) {
                return this.findOneAggregated((ClientSession)clientSession, mongoPreparedQuery);
            }
            return this.findOneFiltered((ClientSession)clientSession, mongoPreparedQuery);
        });
    }

    private <T, R> R getCount(ClientSession clientSession, MongoPreparedQuery<T, R> preparedQuery) {
        Class resultType = preparedQuery.getResultType();
        RuntimePersistentEntity<T> persistentEntity = preparedQuery.getPersistentEntity();
        MongoDatabase database = this.getDatabase(preparedQuery);
        if (preparedQuery.isAggregate()) {
            Object result;
            MongoAggregation aggregation = preparedQuery.getAggregation();
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing Mongo 'aggregate' with pipeline: {}", aggregation.getPipeline().stream().map(e -> e.toBsonDocument().toJson()).toList());
            }
            if ((result = this.aggregate(clientSession, preparedQuery, BsonDocument.class).map(bsonDocument -> this.convertResult(database.getCodecRegistry(), resultType, (BsonDocument)bsonDocument, false)).first()) == null) {
                result = this.conversionService.convertRequired((Object)0, resultType);
            }
            return (R)result;
        }
        MongoFind find = preparedQuery.getFind();
        MongoFindOptions options = find.getOptions();
        Bson filter = options == null ? null : options.getFilter();
        Object object = filter = filter == null ? new BsonDocument() : filter;
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Mongo 'countDocuments' with filter: {}", (Object)filter.toBsonDocument().toJson());
        }
        long count = this.getCollection(database, persistentEntity, BsonDocument.class).countDocuments(clientSession, filter);
        return (R)this.conversionService.convertRequired((Object)count, resultType);
    }

    public <T> boolean exists(PreparedQuery<T, Boolean> preparedQuery) {
        return this.withClientSession(clientSession -> {
            MongoPreparedQuery mongoPreparedQuery = this.getMongoPreparedQuery(preparedQuery);
            if (mongoPreparedQuery.isAggregate()) {
                try (MongoCursor iterator = this.aggregate((ClientSession)clientSession, mongoPreparedQuery, (Class)BsonDocument.class).iterator();){
                    Boolean bl = iterator.hasNext();
                    return bl;
                }
            }
            try (MongoCursor iterator = this.find((ClientSession)clientSession, mongoPreparedQuery).limit(1).iterator();){
                Boolean bl = iterator.hasNext();
                return bl;
            }
        });
    }

    public <T> Iterable<T> findAll(PagedQuery<T> query) {
        throw new DataAccessException("Not supported!");
    }

    public <T> long count(PagedQuery<T> pagedQuery) {
        throw new DataAccessException("Not supported!");
    }

    public <T> Stream<T> findStream(PagedQuery<T> query) {
        throw new DataAccessException("Not supported!");
    }

    public <R> Page<R> findPage(PagedQuery<R> query) {
        throw new DataAccessException("Not supported!");
    }

    public <T, R> Iterable<R> findAll(PreparedQuery<T, R> preparedQuery) {
        return this.withClientSession(clientSession -> this.findAll((ClientSession)clientSession, this.getMongoPreparedQuery(preparedQuery), false));
    }

    public <T, R> Stream<R> findStream(PreparedQuery<T, R> preparedQuery) {
        return this.withClientSession(clientSession -> {
            MongoIterable iterable = (MongoIterable)this.findAll((ClientSession)clientSession, this.getMongoPreparedQuery(preparedQuery), true);
            final MongoCursor iterator = iterable.iterator();
            Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<R>(Long.MAX_VALUE, 1040){

                @Override
                public boolean tryAdvance(Consumer<? super R> action) {
                    if (iterator.hasNext()) {
                        action.accept(iterator.next());
                        return true;
                    }
                    iterator.close();
                    return false;
                }
            };
            return (Stream)StreamSupport.stream(spliterator, false).onClose(() -> ((MongoCursor)iterator).close());
        });
    }

    private <T, R> Iterable<R> findAll(ClientSession clientSession, MongoPreparedQuery<T, R> preparedQuery, boolean stream) {
        if (preparedQuery.isCount()) {
            return Collections.singletonList(this.getCount(clientSession, preparedQuery));
        }
        if (preparedQuery.isAggregate()) {
            return this.findAllAggregated(clientSession, preparedQuery, stream);
        }
        return this.findAllFiltered(clientSession, preparedQuery, stream);
    }

    private <T, R> R findOneFiltered(ClientSession clientSession, MongoPreparedQuery<T, R> preparedQuery) {
        return (R)this.find(clientSession, preparedQuery).limit(1).map(r -> {
            Class type = preparedQuery.getRootEntity();
            RuntimePersistentEntity persistentEntity = preparedQuery.getPersistentEntity();
            if (type.isInstance(r)) {
                return this.triggerPostLoad(preparedQuery.getAnnotationMetadata(), persistentEntity, type.cast(r));
            }
            return r;
        }).first();
    }

    private <T, R> R findOneAggregated(ClientSession clientSession, MongoPreparedQuery<T, R> preparedQuery) {
        MongoDatabase database = this.getDatabase(preparedQuery);
        Class type = preparedQuery.getRootEntity();
        Class resultType = preparedQuery.getResultType();
        if (!resultType.isAssignableFrom(type)) {
            BsonDocument result = (BsonDocument)this.aggregate(clientSession, preparedQuery, BsonDocument.class).first();
            return this.convertResult(database.getCodecRegistry(), resultType, result, preparedQuery.isDtoProjection());
        }
        return (R)this.aggregate(clientSession, preparedQuery).map(r -> {
            RuntimePersistentEntity persistentEntity = preparedQuery.getPersistentEntity();
            if (type.isInstance(r)) {
                return this.triggerPostLoad(preparedQuery.getAnnotationMetadata(), persistentEntity, type.cast(r));
            }
            return r;
        }).first();
    }

    private <T, R> Iterable<R> findAllAggregated(ClientSession clientSession, MongoPreparedQuery<T, R> preparedQuery, boolean stream) {
        MongoIterable aggregate;
        Pageable pageable = preparedQuery.getPageable();
        if (pageable.getMode() != Pageable.Mode.OFFSET) {
            throw new UnsupportedOperationException("Mode " + pageable.getMode() + " is not supported by the MongoDB implementation");
        }
        int limit = pageable == Pageable.UNPAGED ? -1 : pageable.getSize();
        Class type = preparedQuery.getRootEntity();
        Class resultType = preparedQuery.getResultType();
        if (!resultType.isAssignableFrom(type)) {
            MongoDatabase database = this.getDatabase(preparedQuery);
            aggregate = this.aggregate(clientSession, preparedQuery, BsonDocument.class).map(result -> this.convertResult(database.getCodecRegistry(), resultType, (BsonDocument)result, preparedQuery.isDtoProjection()));
        } else {
            aggregate = this.aggregate(clientSession, preparedQuery, resultType);
        }
        return stream ? aggregate : aggregate.into(new ArrayList(limit > 0 ? limit : 20));
    }

    private <T, R> Iterable<R> findAllFiltered(ClientSession clientSession, MongoPreparedQuery<T, R> preparedQuery, boolean stream) {
        MongoIterable findIterable;
        Pageable pageable = preparedQuery.getPageable();
        if (pageable.getMode() != Pageable.Mode.OFFSET) {
            throw new UnsupportedOperationException("Mode " + pageable.getMode() + " is not supported by the MongoDB implementation");
        }
        int limit = pageable == Pageable.UNPAGED ? -1 : pageable.getSize();
        Class type = preparedQuery.getRootEntity();
        Class resultType = preparedQuery.getResultType();
        if (!resultType.isAssignableFrom(type)) {
            MongoDatabase database = this.getDatabase(preparedQuery);
            findIterable = this.find(clientSession, preparedQuery, BsonDocument.class).map(result -> this.convertResult(database.getCodecRegistry(), resultType, (BsonDocument)result, preparedQuery.isDtoProjection()));
        } else {
            findIterable = this.find(clientSession, preparedQuery);
        }
        return stream ? findIterable : findIterable.into(new ArrayList(limit > 0 ? limit : 20));
    }

    private <T, R> FindIterable<R> find(ClientSession clientSession, MongoPreparedQuery<T, R> preparedQuery) {
        return this.find(clientSession, preparedQuery, preparedQuery.getResultType());
    }

    private <T, R, MR> FindIterable<MR> find(ClientSession clientSession, MongoPreparedQuery<T, R> preparedQuery, Class<MR> resultType) {
        MongoFind find = preparedQuery.getFind();
        if (QUERY_LOG.isDebugEnabled()) {
            this.logFind(find);
        }
        MongoDatabase database = this.getDatabase(preparedQuery);
        MongoCollection<MR> collection = this.getCollection(database, preparedQuery.getPersistentEntity(), resultType);
        FindIterable findIterable = collection.find(clientSession, resultType);
        return this.applyFindOptions(find.getOptions(), findIterable);
    }

    private <MR> FindIterable<MR> applyFindOptions(@Nullable MongoFindOptions findOptions, FindIterable<MR> findIterable) {
        Boolean showRecordId;
        Boolean returnKey;
        Bson min;
        Bson max;
        Boolean partial;
        Boolean noCursorTimeout;
        CursorType cursorType;
        Bson hint;
        String comment;
        Long maxAwaitTimeMS;
        Long maxTimeMS;
        Boolean allowDiskUse;
        Integer batchSize;
        Bson projection;
        Bson sort;
        Integer limit;
        Integer skip;
        Collation collation;
        if (findOptions == null) {
            return findIterable;
        }
        Bson filter = findOptions.getFilter();
        if (filter != null) {
            findIterable = findIterable.filter(filter);
        }
        if ((collation = findOptions.getCollation()) != null) {
            findIterable = findIterable.collation(collation);
        }
        if ((skip = findOptions.getSkip()) != null) {
            findIterable = findIterable.skip(skip.intValue());
        }
        if ((limit = findOptions.getLimit()) != null) {
            findIterable = findIterable.limit(Math.max(limit, 0));
        }
        if ((sort = findOptions.getSort()) != null) {
            findIterable = findIterable.sort(sort);
        }
        if ((projection = findOptions.getProjection()) != null) {
            findIterable = findIterable.projection(projection);
        }
        if ((batchSize = findOptions.getBatchSize()) != null) {
            findIterable = findIterable.batchSize(batchSize.intValue());
        }
        if ((allowDiskUse = findOptions.getAllowDiskUse()) != null) {
            findIterable = findIterable.allowDiskUse(allowDiskUse);
        }
        if ((maxTimeMS = findOptions.getMaxTimeMS()) != null) {
            findIterable = findIterable.maxTime(maxTimeMS.longValue(), TimeUnit.MILLISECONDS);
        }
        if ((maxAwaitTimeMS = findOptions.getMaxAwaitTimeMS()) != null) {
            findIterable = findIterable.maxAwaitTime(maxAwaitTimeMS.longValue(), TimeUnit.MILLISECONDS);
        }
        if ((comment = findOptions.getComment()) != null) {
            findIterable = findIterable.comment(comment);
        }
        if ((hint = findOptions.getHint()) != null) {
            findIterable = findIterable.hint(hint);
        }
        if ((cursorType = findOptions.getCursorType()) != null) {
            findIterable = findIterable.cursorType(cursorType);
        }
        if ((noCursorTimeout = findOptions.getNoCursorTimeout()) != null) {
            findIterable = findIterable.noCursorTimeout(noCursorTimeout.booleanValue());
        }
        if ((partial = findOptions.getPartial()) != null) {
            findIterable = findIterable.partial(partial.booleanValue());
        }
        if ((max = findOptions.getMax()) != null) {
            findIterable = findIterable.max(max);
        }
        if ((min = findOptions.getMin()) != null) {
            findIterable = findIterable.min(min);
        }
        if ((returnKey = findOptions.getReturnKey()) != null) {
            findIterable = findIterable.returnKey(returnKey.booleanValue());
        }
        if ((showRecordId = findOptions.getShowRecordId()) != null) {
            findIterable = findIterable.showRecordId(showRecordId.booleanValue());
        }
        return findIterable;
    }

    private <T, R, MR> AggregateIterable<MR> aggregate(ClientSession clientSession, MongoPreparedQuery<T, R> preparedQuery, Class<MR> resultType) {
        MongoDatabase database = this.getDatabase(preparedQuery);
        MongoCollection<MR> collection = this.getCollection(database, preparedQuery.getPersistentEntity(), resultType);
        MongoAggregation aggregation = preparedQuery.getAggregation();
        if (QUERY_LOG.isDebugEnabled()) {
            this.logAggregate(aggregation);
        }
        AggregateIterable aggregateIterable = collection.aggregate(clientSession, aggregation.getPipeline(), resultType);
        return this.applyAggregateOptions(aggregation.getOptions(), aggregateIterable);
    }

    private <T, R> AggregateIterable<R> aggregate(ClientSession clientSession, MongoPreparedQuery<T, R> preparedQuery) {
        return this.aggregate(clientSession, preparedQuery, preparedQuery.getResultType());
    }

    private <MR> AggregateIterable<MR> applyAggregateOptions(@Nullable MongoAggregationOptions aggregateOptions, AggregateIterable<MR> aggregateIterable) {
        Bson hint;
        String comment;
        Boolean bypassDocumentValidation;
        Long maxAwaitTimeMS;
        Long maxTimeMS;
        Boolean allowDiskUse;
        if (aggregateOptions == null) {
            return aggregateIterable;
        }
        if (aggregateOptions.getCollation() != null) {
            aggregateIterable = aggregateIterable.collation(aggregateOptions.getCollation());
        }
        if ((allowDiskUse = aggregateOptions.getAllowDiskUse()) != null) {
            aggregateIterable = aggregateIterable.allowDiskUse(allowDiskUse);
        }
        if ((maxTimeMS = aggregateOptions.getMaxTimeMS()) != null) {
            aggregateIterable = aggregateIterable.maxTime(maxTimeMS.longValue(), TimeUnit.MILLISECONDS);
        }
        if ((maxAwaitTimeMS = aggregateOptions.getMaxAwaitTimeMS()) != null) {
            aggregateIterable = aggregateIterable.maxAwaitTime(maxAwaitTimeMS.longValue(), TimeUnit.MILLISECONDS);
        }
        if ((bypassDocumentValidation = aggregateOptions.getBypassDocumentValidation()) != null) {
            aggregateIterable = aggregateIterable.bypassDocumentValidation(bypassDocumentValidation);
        }
        if ((comment = aggregateOptions.getComment()) != null) {
            aggregateIterable = aggregateIterable.comment(comment);
        }
        if ((hint = aggregateOptions.getHint()) != null) {
            aggregateIterable = aggregateIterable.hint(hint);
        }
        return aggregateIterable;
    }

    public <T> T persist(InsertOperation<T> operation) {
        return (T)this.withClientSession(clientSession -> {
            MongoOperationContext ctx = new MongoOperationContext((ClientSession)clientSession, operation.getAnnotationMetadata(), operation.getRepositoryType());
            return this.persistOne(ctx, operation.getEntity(), this.runtimeEntityRegistry.getEntity(operation.getRootEntity()));
        });
    }

    public <T> Iterable<T> persistAll(InsertBatchOperation<T> operation) {
        return this.withClientSession(clientSession -> {
            MongoOperationContext ctx = new MongoOperationContext((ClientSession)clientSession, operation.getAnnotationMetadata(), operation.getRepositoryType());
            return this.persistBatch(ctx, (Iterable)operation, (RuntimePersistentEntity)this.runtimeEntityRegistry.getEntity(operation.getRootEntity()), null);
        });
    }

    public <T> T update(UpdateOperation<T> operation) {
        return (T)this.withClientSession(clientSession -> {
            MongoOperationContext ctx = new MongoOperationContext((ClientSession)clientSession, operation.getAnnotationMetadata(), operation.getRepositoryType());
            StoredQuery storedQuery = operation.getStoredQuery();
            if (storedQuery != null) {
                MongoStoredQuery mongoStoredQuery = this.getMongoStoredQuery(storedQuery);
                MongoEntitiesOperation<Object> op = this.createMongoUpdateOneInBulkOperation(ctx, mongoStoredQuery.getRuntimePersistentEntity(), Collections.singletonList(operation.getEntity()), mongoStoredQuery);
                op.update();
                return op.getEntities().iterator().next();
            }
            return this.updateOne(ctx, operation.getEntity(), this.runtimeEntityRegistry.getEntity(operation.getRootEntity()));
        });
    }

    public <T> Iterable<T> updateAll(UpdateBatchOperation<T> operation) {
        return this.withClientSession(clientSession -> {
            MongoOperationContext ctx = new MongoOperationContext((ClientSession)clientSession, operation.getAnnotationMetadata(), operation.getRepositoryType());
            StoredQuery storedQuery = operation.getStoredQuery();
            if (storedQuery != null) {
                MongoStoredQuery mongoStoredQuery = this.getMongoStoredQuery(storedQuery);
                MongoEntitiesOperation op = this.createMongoUpdateOneInBulkOperation(ctx, (RuntimePersistentEntity)mongoStoredQuery.getRuntimePersistentEntity(), (Iterable)operation, mongoStoredQuery);
                op.update();
                return op.getEntities();
            }
            MongoEntitiesOperation op = this.createMongoReplaceOneInBulkOperation(ctx, (RuntimePersistentEntity)this.runtimeEntityRegistry.getEntity(operation.getRootEntity()), (Iterable)operation);
            op.update();
            return op.getEntities();
        });
    }

    public <T> int delete(DeleteOperation<T> operation) {
        return this.withClientSession(clientSession -> {
            MongoOperationContext ctx = new MongoOperationContext((ClientSession)clientSession, operation.getAnnotationMetadata(), operation.getRepositoryType());
            StoredQuery storedQuery = operation.getStoredQuery();
            if (storedQuery != null) {
                MongoStoredQuery mongoStoredQuery = this.getMongoStoredQuery(storedQuery);
                MongoEntitiesOperation<Object> op = this.createMongoDeleteOneInBulkOperation(ctx, mongoStoredQuery.getRuntimePersistentEntity(), Collections.singletonList(operation.getEntity()), mongoStoredQuery);
                op.delete();
                return (int)op.modifiedCount;
            }
            RuntimePersistentEntity persistentEntity = this.runtimeEntityRegistry.getEntity(operation.getRootEntity());
            MongoEntityOperation<Object> op = this.createMongoDeleteOneOperation(ctx, persistentEntity, operation.getEntity());
            op.delete();
            return (int)op.modifiedCount;
        });
    }

    public <T> Optional<Number> deleteAll(DeleteBatchOperation<T> operation) {
        return this.withClientSession(clientSession -> {
            MongoOperationContext ctx = new MongoOperationContext((ClientSession)clientSession, operation.getAnnotationMetadata(), operation.getRepositoryType());
            StoredQuery storedQuery = operation.getStoredQuery();
            if (storedQuery != null) {
                MongoStoredQuery mongoStoredQuery = this.getMongoStoredQuery(storedQuery);
                MongoEntitiesOperation op = this.createMongoDeleteOneInBulkOperation(ctx, (RuntimePersistentEntity)mongoStoredQuery.getRuntimePersistentEntity(), (Iterable)operation, mongoStoredQuery);
                op.delete();
                return Optional.of(op.modifiedCount);
            }
            RuntimePersistentEntity persistentEntity = this.runtimeEntityRegistry.getEntity(operation.getRootEntity());
            if (operation.all()) {
                MongoDatabase mongoDatabase = this.getDatabase((PersistentEntity)persistentEntity, operation.getRepositoryType());
                long deletedCount = this.getCollection(mongoDatabase, persistentEntity, persistentEntity.getIntrospection().getBeanType()).deleteMany((Bson)EMPTY).getDeletedCount();
                return Optional.of(deletedCount);
            }
            MongoEntitiesOperation op = this.createMongoDeleteManyOperation(ctx, (RuntimePersistentEntity)persistentEntity, (Iterable)operation);
            op.delete();
            return Optional.of(op.modifiedCount);
        });
    }

    public Optional<Number> executeUpdate(PreparedQuery<?, Number> preparedQuery) {
        return this.withClientSession(clientSession -> {
            MongoPreparedQuery mongoPreparedQuery = this.getMongoPreparedQuery(preparedQuery);
            MongoUpdate updateMany = mongoPreparedQuery.getUpdateMany();
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing Mongo 'updateMany' with filter: {} and update: {}", (Object)updateMany.getFilter().toBsonDocument().toJson(), (Object)updateMany.getUpdate().toBsonDocument().toJson());
            }
            UpdateResult updateResult = this.getCollection(mongoPreparedQuery).updateMany(clientSession, updateMany.getFilter(), updateMany.getUpdate(), updateMany.getOptions());
            if (preparedQuery.isOptimisticLock()) {
                this.checkOptimisticLocking(1, (int)updateResult.getModifiedCount());
            }
            return Optional.of(updateResult.getModifiedCount());
        });
    }

    public Optional<Number> executeDelete(PreparedQuery<?, Number> preparedQuery) {
        return this.withClientSession(clientSession -> {
            MongoPreparedQuery mongoPreparedQuery = this.getMongoPreparedQuery(preparedQuery);
            MongoDelete deleteMany = mongoPreparedQuery.getDeleteMany();
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing Mongo 'deleteMany' with filter: {}", (Object)deleteMany.getFilter().toBsonDocument().toJson());
            }
            DeleteResult deleteResult = this.getCollection(mongoPreparedQuery).deleteMany(clientSession, deleteMany.getFilter(), deleteMany.getOptions());
            if (preparedQuery.isOptimisticLock()) {
                this.checkOptimisticLocking(1, (int)deleteResult.getDeletedCount());
            }
            return Optional.of(deleteResult.getDeletedCount());
        });
    }

    private MongoDatabase getDatabase(MongoPreparedQuery<?, ?> preparedQuery) {
        return this.getDatabase((PersistentEntity)preparedQuery.getPersistentEntity(), (Class<?>)preparedQuery.getRepositoryType());
    }

    private <E> MongoCollection<E> getCollection(MongoPreparedQuery<E, ?> preparedQuery) {
        return this.getCollection(this.getDatabase(preparedQuery), preparedQuery.getPersistentEntity(), preparedQuery.getRootEntity());
    }

    private <E> MongoCollection<E> getCollection(MongoOperationContext ctx, RuntimePersistentEntity<E> persistentEntity) {
        return this.getCollection(persistentEntity, ctx.repositoryType, persistentEntity.getIntrospection().getBeanType());
    }

    private <K> K triggerPostLoad(AnnotationMetadata annotationMetadata, RuntimePersistentEntity<K> persistentEntity, K entity) {
        if (persistentEntity.hasPostLoadEventListeners()) {
            entity = this.triggerPostLoad(entity, persistentEntity, annotationMetadata);
        }
        block4: for (PersistentProperty pp : persistentEntity.getPersistentProperties()) {
            RuntimeAssociation runtimeAssociation;
            Object o;
            if (!(pp instanceof RuntimeAssociation) || (o = (runtimeAssociation = (RuntimeAssociation)pp).getProperty().get(entity)) == null) continue;
            RuntimePersistentEntity associatedEntity = runtimeAssociation.getAssociatedEntity();
            switch (runtimeAssociation.getKind()) {
                case MANY_TO_MANY: 
                case ONE_TO_MANY: {
                    if (!(o instanceof Iterable)) continue block4;
                    Iterable iterable = (Iterable)o;
                    for (Object value : iterable) {
                        this.triggerPostLoad(value, associatedEntity, annotationMetadata);
                    }
                    continue block4;
                }
                case MANY_TO_ONE: 
                case ONE_TO_ONE: 
                case EMBEDDED: {
                    this.triggerPostLoad(o, associatedEntity, annotationMetadata);
                    continue block4;
                }
            }
            throw new IllegalStateException("Unknown kind: " + runtimeAssociation.getKind());
        }
        return entity;
    }

    private <T, R> MongoCollection<R> getCollection(MongoDatabase database, RuntimePersistentEntity<T> persistentEntity, Class<R> resultType) {
        return database.getCollection(this.collectionNameProvider.provide((PersistentEntity)persistentEntity), resultType);
    }

    private <T, R> MongoCollection<R> getCollection(RuntimePersistentEntity<T> persistentEntity, Class<?> repositoryClass, Class<R> resultType) {
        return this.getDatabase((PersistentEntity)persistentEntity, repositoryClass).getCollection(this.collectionNameProvider.provide((PersistentEntity)persistentEntity), resultType);
    }

    @Override
    protected MongoDatabase getDatabase(PersistentEntity persistentEntity, Class<?> repositoryClass) {
        return this.mongoClient.getDatabase(this.databaseNameProvider.provide(persistentEntity, repositoryClass));
    }

    @Override
    protected CodecRegistry getCodecRegistry(MongoDatabase mongoDatabase) {
        return mongoDatabase.getCodecRegistry();
    }

    public <T> T persistOne(MongoOperationContext ctx, T value, RuntimePersistentEntity<T> persistentEntity) {
        MongoEntityOperation<T> op = this.createMongoInsertOneOperation(ctx, persistentEntity, value);
        op.persist();
        return (T)op.getEntity();
    }

    public <T> List<T> persistBatch(MongoOperationContext ctx, Iterable<T> values, RuntimePersistentEntity<T> persistentEntity, Predicate<T> predicate) {
        MongoEntitiesOperation<T> op = this.createMongoInsertManyOperation(ctx, persistentEntity, values);
        if (predicate != null) {
            op.veto(predicate);
        }
        op.persist();
        return op.getEntities();
    }

    public <T> T updateOne(MongoOperationContext ctx, T value, RuntimePersistentEntity<T> persistentEntity) {
        MongoEntityOperation<T> op = this.createMongoReplaceOneOperation(ctx, persistentEntity, value);
        op.update();
        return (T)op.getEntity();
    }

    public void persistManyAssociation(MongoOperationContext ctx, RuntimeAssociation runtimeAssociation, Object value, RuntimePersistentEntity<Object> persistentEntity, Object child, RuntimePersistentEntity<Object> childPersistentEntity) {
        String joinCollectionName = runtimeAssociation.getOwner().getNamingStrategy().mappedName((Association)runtimeAssociation);
        MongoDatabase mongoDatabase = this.getDatabase((PersistentEntity)persistentEntity, (Class<?>)ctx.repositoryType);
        MongoCollection collection = mongoDatabase.getCollection(joinCollectionName, BsonDocument.class);
        BsonDocument association = this.association(collection.getCodecRegistry(), value, persistentEntity, child, childPersistentEntity);
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Mongo 'insertOne' for collection: {} with document: {}", (Object)collection.getNamespace().getFullName(), (Object)association);
        }
        collection.insertOne(ctx.clientSession, (Object)association, this.getInsertOneOptions(ctx.annotationMetadata));
    }

    public void persistManyAssociationBatch(MongoOperationContext ctx, RuntimeAssociation runtimeAssociation, Object value, RuntimePersistentEntity<Object> persistentEntity, Iterable<Object> child, RuntimePersistentEntity<Object> childPersistentEntity) {
        String joinCollectionName = runtimeAssociation.getOwner().getNamingStrategy().mappedName((Association)runtimeAssociation);
        MongoCollection collection = this.getDatabase((PersistentEntity)persistentEntity, (Class<?>)ctx.repositoryType).getCollection(joinCollectionName, BsonDocument.class);
        ArrayList<BsonDocument> associations = new ArrayList<BsonDocument>();
        for (Object c : child) {
            associations.add(this.association(collection.getCodecRegistry(), value, persistentEntity, c, childPersistentEntity));
        }
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Mongo 'insertMany' for collection: {} with documents: {}", (Object)collection.getNamespace().getFullName(), associations);
        }
        collection.insertMany(ctx.clientSession, associations, this.getInsertManyOptions(ctx.annotationMetadata));
    }

    private <T> T withClientSession(Function<ClientSession, T> function) {
        return (T)this.connectionOperations.execute(ConnectionDefinition.DEFAULT, status -> function.apply((ClientSession)status.getConnection()));
    }

    private <T> MongoEntityOperation<T> createMongoInsertOneOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, T entity) {
        return new MongoEntityOperation<T>(ctx, (RuntimePersistentEntity)persistentEntity, (Object)entity, true){

            protected void execute() throws RuntimeException {
                MongoDatabase mongoDatabase = DefaultMongoRepositoryOperations.this.getDatabase((PersistentEntity)this.persistentEntity, ((MongoOperationContext)this.ctx).repositoryType);
                MongoCollection collection = DefaultMongoRepositoryOperations.this.getCollection(mongoDatabase, this.persistentEntity, this.persistentEntity.getIntrospection().getBeanType());
                if (AbstractMongoRepositoryOperations.QUERY_LOG.isDebugEnabled()) {
                    AbstractMongoRepositoryOperations.QUERY_LOG.debug("Executing Mongo 'insertOne' with entity: {}", this.entity);
                }
                InsertOneResult insertOneResult = collection.insertOne(((MongoOperationContext)this.ctx).clientSession, this.entity, DefaultMongoRepositoryOperations.this.getInsertOneOptions(((MongoOperationContext)this.ctx).annotationMetadata));
                BsonValue insertedId = insertOneResult.getInsertedId();
                BeanProperty property = this.persistentEntity.getIdentity().getProperty();
                if (property.get(this.entity) == null) {
                    this.entity = this.updateEntityId(property, this.entity, insertedId);
                }
            }
        };
    }

    private <T> MongoEntityOperation<T> createMongoReplaceOneOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, T entity) {
        return new MongoEntityOperation<T>(ctx, (RuntimePersistentEntity)persistentEntity, (Object)entity, false){
            final MongoDatabase mongoDatabase;
            final MongoCollection<BsonDocument> collection;
            Bson filter;
            {
                this.mongoDatabase = DefaultMongoRepositoryOperations.this.getDatabase((PersistentEntity)this.persistentEntity, ((MongoOperationContext)this.ctx).repositoryType);
                this.collection = DefaultMongoRepositoryOperations.this.getCollection(this.mongoDatabase, this.persistentEntity, BsonDocument.class);
            }

            @Override
            protected void collectAutoPopulatedPreviousValues() {
                this.filter = DefaultMongoRepositoryOperations.this.createFilterIdAndVersion(this.persistentEntity, this.entity, this.mongoDatabase.getCodecRegistry());
            }

            protected void execute() throws RuntimeException {
                if (AbstractMongoRepositoryOperations.QUERY_LOG.isDebugEnabled()) {
                    AbstractMongoRepositoryOperations.QUERY_LOG.debug("Executing Mongo 'replaceOne' with filter: {}", (Object)this.filter.toBsonDocument().toJson());
                }
                BsonDocument bsonDocument = BsonDocumentWrapper.asBsonDocument((Object)this.entity, (CodecRegistry)this.mongoDatabase.getCodecRegistry());
                bsonDocument.remove((Object)"_id");
                UpdateResult updateResult = this.collection.replaceOne(((MongoOperationContext)this.ctx).clientSession, this.filter, (Object)bsonDocument, DefaultMongoRepositoryOperations.this.getReplaceOptions(((MongoOperationContext)this.ctx).annotationMetadata));
                this.modifiedCount = updateResult.getModifiedCount();
                if (this.persistentEntity.getVersion() != null) {
                    this.checkOptimisticLocking(1L, (int)this.modifiedCount);
                }
            }
        };
    }

    private <T> MongoEntitiesOperation<T> createMongoUpdateOneInBulkOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities, final MongoStoredQuery<T, ?> storedQuery) {
        return new MongoEntitiesOperation<T>(ctx, persistentEntity, entities, false){

            @Override
            protected void collectAutoPopulatedPreviousValues() {
            }

            protected void execute() throws RuntimeException {
                ArrayList<UpdateOneModel> updates = new ArrayList<UpdateOneModel>(this.entities.size());
                for (AbstractSyncEntitiesOperations.Data d : this.entities) {
                    if (d.vetoed) continue;
                    MongoUpdate updateOne = storedQuery.getUpdateOne(d.entity);
                    if (AbstractMongoRepositoryOperations.QUERY_LOG.isDebugEnabled()) {
                        AbstractMongoRepositoryOperations.QUERY_LOG.debug("Executing Mongo 'updateOne' with filter: {} and update: {}", (Object)updateOne.getFilter().toBsonDocument().toJson(), (Object)updateOne.getUpdate().toBsonDocument().toJson());
                    }
                    updates.add(new UpdateOneModel(updateOne.getFilter(), updateOne.getUpdate(), updateOne.getOptions()));
                }
                BulkWriteResult bulkWriteResult = DefaultMongoRepositoryOperations.this.getCollection((MongoOperationContext)this.ctx, this.persistentEntity).bulkWrite(((MongoOperationContext)this.ctx).clientSession, updates);
                this.modifiedCount += (long)bulkWriteResult.getModifiedCount();
                if (this.persistentEntity.getVersion() != null) {
                    this.checkOptimisticLocking(updates.size(), (int)this.modifiedCount);
                }
            }
        };
    }

    private <T> MongoEntitiesOperation<T> createMongoReplaceOneInBulkOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities) {
        return new MongoEntitiesOperation<T>(ctx, (RuntimePersistentEntity)persistentEntity, (Iterable)entities, false){
            final MongoDatabase mongoDatabase;
            final MongoCollection<BsonDocument> collection;
            Map<AbstractSyncEntitiesOperations.Data, Bson> filters;
            {
                this.mongoDatabase = DefaultMongoRepositoryOperations.this.getDatabase((PersistentEntity)this.persistentEntity, ((MongoOperationContext)this.ctx).repositoryType);
                this.collection = DefaultMongoRepositoryOperations.this.getCollection(this.mongoDatabase, this.persistentEntity, BsonDocument.class);
            }

            @Override
            protected void collectAutoPopulatedPreviousValues() {
                this.filters = this.entities.stream().collect(Collectors.toMap(d -> d, d -> DefaultMongoRepositoryOperations.this.createFilterIdAndVersion(this.persistentEntity, d.entity, this.collection.getCodecRegistry())));
            }

            protected void execute() throws RuntimeException {
                ArrayList<ReplaceOneModel> replaces = new ArrayList<ReplaceOneModel>(this.entities.size());
                for (AbstractSyncEntitiesOperations.Data d : this.entities) {
                    if (d.vetoed) continue;
                    Bson filter = this.filters.get(d);
                    if (AbstractMongoRepositoryOperations.QUERY_LOG.isDebugEnabled()) {
                        AbstractMongoRepositoryOperations.QUERY_LOG.debug("Executing Mongo 'replaceOne' with filter: {}", (Object)filter.toBsonDocument().toJson());
                    }
                    BsonDocument bsonDocument = BsonDocumentWrapper.asBsonDocument((Object)d.entity, (CodecRegistry)this.mongoDatabase.getCodecRegistry());
                    bsonDocument.remove((Object)"_id");
                    replaces.add(new ReplaceOneModel(filter, (Object)bsonDocument, DefaultMongoRepositoryOperations.this.getReplaceOptions(((MongoOperationContext)this.ctx).annotationMetadata)));
                }
                BulkWriteResult bulkWriteResult = this.collection.bulkWrite(((MongoOperationContext)this.ctx).clientSession, replaces);
                this.modifiedCount = bulkWriteResult.getModifiedCount();
                if (this.persistentEntity.getVersion() != null) {
                    this.checkOptimisticLocking(replaces.size(), (int)this.modifiedCount);
                }
            }
        };
    }

    private <T> MongoEntityOperation<T> createMongoDeleteOneOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, T entity) {
        return new MongoEntityOperation<T>(ctx, (RuntimePersistentEntity)persistentEntity, (Object)entity, false){
            final MongoDatabase mongoDatabase;
            final MongoCollection<T> collection;
            Bson filter;
            {
                this.mongoDatabase = DefaultMongoRepositoryOperations.this.getDatabase((PersistentEntity)this.persistentEntity, ((MongoOperationContext)this.ctx).repositoryType);
                this.collection = DefaultMongoRepositoryOperations.this.getCollection(this.mongoDatabase, this.persistentEntity, this.persistentEntity.getIntrospection().getBeanType());
            }

            @Override
            protected void collectAutoPopulatedPreviousValues() {
                this.filter = DefaultMongoRepositoryOperations.this.createFilterIdAndVersion(this.persistentEntity, this.entity, this.collection.getCodecRegistry());
            }

            protected void execute() throws RuntimeException {
                if (AbstractMongoRepositoryOperations.QUERY_LOG.isDebugEnabled()) {
                    AbstractMongoRepositoryOperations.QUERY_LOG.debug("Executing Mongo 'deleteOne' with filter: {}", (Object)this.filter.toBsonDocument().toJson());
                }
                DeleteResult deleteResult = this.collection.deleteOne(((MongoOperationContext)this.ctx).clientSession, this.filter, DefaultMongoRepositoryOperations.this.getDeleteOptions(((MongoOperationContext)this.ctx).annotationMetadata));
                this.modifiedCount = deleteResult.getDeletedCount();
                if (this.persistentEntity.getVersion() != null) {
                    this.checkOptimisticLocking(1L, (int)this.modifiedCount);
                }
            }
        };
    }

    private <T> MongoEntitiesOperation<T> createMongoDeleteManyOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities) {
        return new MongoEntitiesOperation<T>(ctx, (RuntimePersistentEntity)persistentEntity, (Iterable)entities, false){
            final MongoDatabase mongoDatabase;
            final MongoCollection<T> collection;
            Map<AbstractSyncEntitiesOperations.Data, Bson> filters;
            {
                this.mongoDatabase = DefaultMongoRepositoryOperations.this.getDatabase((PersistentEntity)this.persistentEntity, ((MongoOperationContext)this.ctx).repositoryType);
                this.collection = DefaultMongoRepositoryOperations.this.getCollection(this.mongoDatabase, this.persistentEntity, this.persistentEntity.getIntrospection().getBeanType());
            }

            @Override
            protected void collectAutoPopulatedPreviousValues() {
                this.filters = this.entities.stream().collect(Collectors.toMap(d -> d, d -> DefaultMongoRepositoryOperations.this.createFilterIdAndVersion(this.persistentEntity, d.entity, this.collection.getCodecRegistry())));
            }

            protected void execute() throws RuntimeException {
                List<Bson> filters = this.entities.stream().filter(d -> !d.vetoed).map(d -> this.filters.get(d)).toList();
                if (!filters.isEmpty()) {
                    Bson filter = Filters.or(filters);
                    if (AbstractMongoRepositoryOperations.QUERY_LOG.isDebugEnabled()) {
                        AbstractMongoRepositoryOperations.QUERY_LOG.debug("Executing Mongo 'deleteMany' with filter: {}", (Object)filter.toBsonDocument().toJson());
                    }
                    DeleteResult deleteResult = this.collection.deleteMany(((MongoOperationContext)this.ctx).clientSession, filter, DefaultMongoRepositoryOperations.this.getDeleteOptions(((MongoOperationContext)this.ctx).annotationMetadata));
                    this.modifiedCount = deleteResult.getDeletedCount();
                }
                if (this.persistentEntity.getVersion() != null) {
                    int expected = (int)this.entities.stream().filter(d -> !d.vetoed).count();
                    this.checkOptimisticLocking(expected, (int)this.modifiedCount);
                }
            }
        };
    }

    private <T> MongoEntitiesOperation<T> createMongoDeleteOneInBulkOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities, final MongoStoredQuery<T, ?> storedQuery) {
        return new MongoEntitiesOperation<T>(ctx, persistentEntity, entities, false){

            protected void execute() throws RuntimeException {
                ArrayList<DeleteOneModel> deletes = new ArrayList<DeleteOneModel>(this.entities.size());
                for (AbstractSyncEntitiesOperations.Data d : this.entities) {
                    if (d.vetoed) continue;
                    MongoDelete deleteOne = storedQuery.getDeleteOne(d.entity);
                    if (AbstractMongoRepositoryOperations.QUERY_LOG.isDebugEnabled()) {
                        AbstractMongoRepositoryOperations.QUERY_LOG.debug("Executing Mongo 'deleteOne' with filter: {} ", (Object)deleteOne.getFilter().toBsonDocument().toJson());
                    }
                    deletes.add(new DeleteOneModel(deleteOne.getFilter(), deleteOne.getOptions()));
                }
                BulkWriteResult bulkWriteResult = DefaultMongoRepositoryOperations.this.getCollection((MongoOperationContext)this.ctx, this.persistentEntity).bulkWrite(((MongoOperationContext)this.ctx).clientSession, deletes);
                this.modifiedCount = bulkWriteResult.getDeletedCount();
                if (this.persistentEntity.getVersion() != null) {
                    this.checkOptimisticLocking(deletes.size(), (int)this.modifiedCount);
                }
            }
        };
    }

    private <T> MongoEntitiesOperation<T> createMongoInsertManyOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities) {
        return new MongoEntitiesOperation<T>(ctx, (RuntimePersistentEntity)persistentEntity, (Iterable)entities, true){

            protected void execute() throws RuntimeException {
                List<Object> toInsert = this.entities.stream().filter(d -> !d.vetoed).map(d -> d.entity).toList();
                if (toInsert.isEmpty()) {
                    return;
                }
                if (AbstractMongoRepositoryOperations.QUERY_LOG.isDebugEnabled()) {
                    AbstractMongoRepositoryOperations.QUERY_LOG.debug("Executing Mongo 'insertMany' with entities: {}", toInsert);
                }
                MongoDatabase mongoDatabase = DefaultMongoRepositoryOperations.this.getDatabase((PersistentEntity)this.persistentEntity, ((MongoOperationContext)this.ctx).repositoryType);
                InsertManyResult insertManyResult = DefaultMongoRepositoryOperations.this.getCollection(mongoDatabase, this.persistentEntity, this.persistentEntity.getIntrospection().getBeanType()).insertMany(((MongoOperationContext)this.ctx).clientSession, toInsert, DefaultMongoRepositoryOperations.this.getInsertManyOptions(((MongoOperationContext)this.ctx).annotationMetadata));
                if (this.hasGeneratedId) {
                    Map insertedIds = insertManyResult.getInsertedIds();
                    RuntimePersistentProperty identity = this.persistentEntity.getIdentity();
                    BeanProperty idProperty = identity.getProperty();
                    int index = 0;
                    for (AbstractSyncEntitiesOperations.Data d2 : this.entities) {
                        if (!d2.vetoed) {
                            BsonValue id = (BsonValue)insertedIds.get(index);
                            if (id == null) {
                                throw new DataAccessException("Failed to generate ID for entity: " + d2.entity);
                            }
                            d2.entity = this.updateEntityId(idProperty, d2.entity, id);
                        }
                        ++index;
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ExecutorAsyncOperations async() {
        ExecutorAsyncOperations asyncOperations = this.asyncOperations;
        if (asyncOperations == null) {
            DefaultMongoRepositoryOperations defaultMongoRepositoryOperations = this;
            synchronized (defaultMongoRepositoryOperations) {
                asyncOperations = this.asyncOperations;
                if (asyncOperations == null) {
                    this.asyncOperations = asyncOperations = new ExecutorAsyncOperations((RepositoryOperations)this, (Executor)(this.executorService != null ? this.executorService : this.newLocalThreadPool()));
                }
            }
        }
        return asyncOperations;
    }

    @NonNull
    private ExecutorService newLocalThreadPool() {
        this.executorService = Executors.newCachedThreadPool();
        return this.executorService;
    }

    @NonNull
    public ReactiveRepositoryOperations reactive() {
        return new ExecutorReactiveOperations(this.async(), this.conversionService);
    }

    protected static class MongoOperationContext
    extends OperationContext {
        private final ClientSession clientSession;

        public MongoOperationContext(ClientSession clientSession, AnnotationMetadata annotationMetadata, Class<?> repositoryType) {
            super(annotationMetadata, repositoryType);
            this.clientSession = clientSession;
        }
    }

    private abstract class MongoEntityOperation<T>
    extends AbstractSyncEntityOperations<MongoOperationContext, T, RuntimeException> {
        protected long modifiedCount;

        protected MongoEntityOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, T entity, boolean insert) {
            super((OperationContext)ctx, DefaultMongoRepositoryOperations.this.cascadeOperations, DefaultMongoRepositoryOperations.this.entityEventRegistry, persistentEntity, (ConversionService)DefaultMongoRepositoryOperations.this.conversionService, entity, insert);
        }

        protected void collectAutoPopulatedPreviousValues() {
        }
    }

    private abstract class MongoEntitiesOperation<T>
    extends AbstractSyncEntitiesOperations<MongoOperationContext, T, RuntimeException> {
        protected long modifiedCount;

        protected MongoEntitiesOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities, boolean insert) {
            super((OperationContext)ctx, DefaultMongoRepositoryOperations.this.cascadeOperations, (ConversionService)DefaultMongoRepositoryOperations.this.conversionService, DefaultMongoRepositoryOperations.this.entityEventRegistry, persistentEntity, entities, insert);
        }

        protected void collectAutoPopulatedPreviousValues() {
        }
    }
}

