/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.serde;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.data.annotation.GeneratedValue;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.mongodb.operations.MongoUtils;
import io.micronaut.data.mongodb.serde.DataSerdeRegistry;
import io.micronaut.data.mongodb.serde.MappedCodec;
import org.bson.BsonValue;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.types.ObjectId;

@Internal
class MappedEntityCodec<T>
extends MappedCodec<T>
implements CollectibleCodec<T> {
    private final boolean isGeneratedId;
    private final boolean isGeneratedObjectIdAsString;
    private final boolean isGeneratedObjectId;
    private final BeanProperty<T, Object> identityProperty;

    MappedEntityCodec(DataSerdeRegistry dataSerdeRegistry, RuntimePersistentEntity<T> persistentEntity, Class<T> type, CodecRegistry codecRegistry) {
        super(dataSerdeRegistry, persistentEntity, type, codecRegistry);
        RuntimePersistentProperty identity = persistentEntity.getIdentity();
        if (identity == null) {
            throw new IllegalStateException("Identity not found!");
        }
        this.identityProperty = identity.getProperty();
        this.isGeneratedId = identity.isAnnotationPresent(GeneratedValue.class);
        this.isGeneratedObjectId = this.isGeneratedId && identity.getType().isAssignableFrom(ObjectId.class);
        this.isGeneratedObjectIdAsString = !this.isGeneratedObjectId && identity.getType().isAssignableFrom(String.class);
    }

    public T generateIdIfAbsentFromDocument(T document) {
        if (this.isGeneratedId) {
            if (this.isGeneratedObjectId) {
                return (T)this.identityProperty.withValue(document, (Object)new ObjectId());
            }
            if (this.isGeneratedObjectIdAsString) {
                return (T)this.identityProperty.withValue(document, (Object)new ObjectId().toHexString());
            }
            throw new IllegalStateException("Cannot generate id for entity: " + String.valueOf(this.persistentEntity));
        }
        return document;
    }

    public boolean documentHasId(T document) {
        return this.identityProperty.get(document) != null;
    }

    public BsonValue getDocumentId(T document) {
        return MongoUtils.idValue(null, this.persistentEntity, document, this.codecRegistry);
    }
}

