/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.operations;

import com.mongodb.CursorType;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.data.connection.reactive.ReactorConnectionOperations;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.mongodb.conf.RequiresReactiveMongo;
import io.micronaut.data.mongodb.operations.AbstractMongoRepositoryOperations;
import io.micronaut.data.mongodb.operations.MongoAggregation;
import io.micronaut.data.mongodb.operations.MongoCollectionNameProvider;
import io.micronaut.data.mongodb.operations.MongoDatabaseNameProvider;
import io.micronaut.data.mongodb.operations.MongoDelete;
import io.micronaut.data.mongodb.operations.MongoFind;
import io.micronaut.data.mongodb.operations.MongoPreparedQuery;
import io.micronaut.data.mongodb.operations.MongoReactorRepositoryOperations;
import io.micronaut.data.mongodb.operations.MongoStoredQuery;
import io.micronaut.data.mongodb.operations.MongoUpdate;
import io.micronaut.data.mongodb.operations.MongoUtils;
import io.micronaut.data.mongodb.operations.options.MongoAggregationOptions;
import io.micronaut.data.mongodb.operations.options.MongoFindOptions;
import io.micronaut.data.operations.reactive.ReactorReactiveRepositoryOperations;
import io.micronaut.data.runtime.config.DataSettings;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.operations.internal.AbstractReactiveEntitiesOperations;
import io.micronaut.data.runtime.operations.internal.AbstractReactiveEntityOperations;
import io.micronaut.data.runtime.operations.internal.OperationContext;
import io.micronaut.data.runtime.operations.internal.ReactiveCascadeOperations;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@RequiresReactiveMongo
@EachBean(value=MongoClient.class)
@Internal
public final class DefaultReactiveMongoRepositoryOperations
extends AbstractMongoRepositoryOperations<MongoDatabase>
implements MongoReactorRepositoryOperations,
ReactorReactiveRepositoryOperations,
ReactiveCascadeOperations.ReactiveCascadeOperationsHelper<MongoOperationContext> {
    private static final Logger QUERY_LOG = DataSettings.QUERY_LOG;
    private final MongoClient mongoClient;
    private final ReactiveCascadeOperations<MongoOperationContext> cascadeOperations;
    private final ReactorConnectionOperations<ClientSession> connectionOperations;

    DefaultReactiveMongoRepositoryOperations(@Parameter String serverName, BeanContext beanContext, DateTimeProvider<Object> dateTimeProvider, RuntimeEntityRegistry runtimeEntityRegistry, DataConversionService conversionService, AttributeConverterRegistry attributeConverterRegistry, MongoClient mongoClient, MongoCollectionNameProvider collectionNameProvider, @Parameter ReactorConnectionOperations<ClientSession> connectionOperations) {
        super(dateTimeProvider, runtimeEntityRegistry, conversionService, attributeConverterRegistry, collectionNameProvider, (MongoDatabaseNameProvider)beanContext.getBean(MongoDatabaseNameProvider.class, "Primary".equals(serverName) ? null : Qualifiers.byName((String)serverName)));
        this.mongoClient = mongoClient;
        this.cascadeOperations = new ReactiveCascadeOperations((ConversionService)conversionService, (ReactiveCascadeOperations.ReactiveCascadeOperationsHelper)this);
        this.connectionOperations = connectionOperations;
    }

    public <T> Mono<T> findOne(Class<T> type, Object id) {
        return this.withClientSession(clientSession -> {
            RuntimePersistentEntity persistentEntity = this.runtimeEntityRegistry.getEntity(type);
            MongoDatabase database = this.getDatabase((PersistentEntity)persistentEntity, null);
            MongoCollection collection = this.getCollection(database, persistentEntity, type);
            Bson filter = MongoUtils.filterById((ConversionService)this.conversionService, persistentEntity, id, collection.getCodecRegistry());
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing Mongo 'find' with filter: {}", (Object)filter.toBsonDocument().toJson());
            }
            return Mono.from((Publisher)collection.find(clientSession, filter, type).first());
        });
    }

    public <T, R> Mono<R> findOne(PreparedQuery<T, R> preparedQuery) {
        return this.withClientSession(clientSession -> {
            MongoPreparedQuery mongoPreparedQuery = this.getMongoPreparedQuery(preparedQuery);
            if (mongoPreparedQuery.isCount()) {
                return this.getCount((ClientSession)clientSession, mongoPreparedQuery);
            }
            if (mongoPreparedQuery.isAggregate()) {
                return this.findOneAggregated((ClientSession)clientSession, mongoPreparedQuery);
            }
            return this.findOneFiltered((ClientSession)clientSession, mongoPreparedQuery);
        });
    }

    public <T> Mono<Boolean> exists(PreparedQuery<T, Boolean> preparedQuery) {
        return this.withClientSession(clientSession -> {
            MongoPreparedQuery mongoPreparedQuery = this.getMongoPreparedQuery(preparedQuery);
            if (mongoPreparedQuery.isAggregate()) {
                return Flux.from(this.aggregate((ClientSession)clientSession, mongoPreparedQuery, (Class)BsonDocument.class)).hasElements();
            }
            return Flux.from((Publisher)this.find((ClientSession)clientSession, mongoPreparedQuery, (Class)BsonDocument.class).limit(1)).hasElements();
        });
    }

    public <T> Flux<T> findAll(PagedQuery<T> query) {
        throw new DataAccessException("Not supported!");
    }

    public <T> Mono<Long> count(PagedQuery<T> pagedQuery) {
        throw new DataAccessException("Not supported!");
    }

    public <T, R> Flux<R> findAll(PreparedQuery<T, R> preparedQuery) {
        return this.withClientSessionMany(clientSession -> this.findAll((ClientSession)clientSession, this.getMongoPreparedQuery(preparedQuery)));
    }

    public <T> Mono<T> findOptional(Class<T> type, Object id) {
        return this.findOne(type, id);
    }

    public <T, R> Mono<R> findOptional(PreparedQuery<T, R> preparedQuery) {
        return this.findOne(preparedQuery);
    }

    public <R> Mono<Page<R>> findPage(PagedQuery<R> pagedQuery) {
        throw new DataAccessException("Not supported!");
    }

    public <T> Mono<T> persist(InsertOperation<T> operation) {
        return this.withClientSession(clientSession -> {
            MongoOperationContext ctx = new MongoOperationContext((ClientSession)clientSession, operation.getRepositoryType(), operation.getAnnotationMetadata());
            return this.persistOne(ctx, operation.getEntity(), this.runtimeEntityRegistry.getEntity(operation.getRootEntity()));
        });
    }

    public <T> Flux<T> persistAll(InsertBatchOperation<T> operation) {
        return this.withClientSessionMany(clientSession -> {
            MongoOperationContext ctx = new MongoOperationContext((ClientSession)clientSession, operation.getRepositoryType(), operation.getAnnotationMetadata());
            return this.persistBatch(ctx, (Iterable)operation, (RuntimePersistentEntity)this.runtimeEntityRegistry.getEntity(operation.getRootEntity()), null);
        });
    }

    public <T> Mono<T> update(UpdateOperation<T> operation) {
        return this.withClientSession(clientSession -> {
            MongoOperationContext ctx = new MongoOperationContext((ClientSession)clientSession, operation.getRepositoryType(), operation.getAnnotationMetadata());
            StoredQuery storedQuery = operation.getStoredQuery();
            if (storedQuery != null) {
                MongoStoredQuery mongoStoredQuery = this.getMongoStoredQuery(storedQuery);
                MongoReactiveEntitiesOperation<Object> op = this.createMongoUpdateOneInBulkOperation(ctx, mongoStoredQuery.getRuntimePersistentEntity(), Collections.singletonList(operation.getEntity()), mongoStoredQuery);
                op.update();
                return op.getEntities().next();
            }
            return this.updateOne(ctx, operation.getEntity(), this.runtimeEntityRegistry.getEntity(operation.getRootEntity()));
        });
    }

    public <T> Flux<T> updateAll(UpdateBatchOperation<T> operation) {
        return this.withClientSessionMany(clientSession -> {
            MongoOperationContext ctx = new MongoOperationContext((ClientSession)clientSession, operation.getRepositoryType(), operation.getAnnotationMetadata());
            StoredQuery storedQuery = operation.getStoredQuery();
            if (storedQuery != null) {
                MongoStoredQuery mongoStoredQuery = this.getMongoStoredQuery(storedQuery);
                MongoReactiveEntitiesOperation op = this.createMongoUpdateOneInBulkOperation(ctx, (RuntimePersistentEntity)mongoStoredQuery.getRuntimePersistentEntity(), (Iterable)operation, mongoStoredQuery);
                op.update();
                return op.getEntities();
            }
            return this.updateBatch(ctx, (Iterable)operation, (RuntimePersistentEntity)this.runtimeEntityRegistry.getEntity(operation.getRootEntity()));
        });
    }

    public <T> Mono<Number> delete(DeleteOperation<T> operation) {
        return this.withClientSession(clientSession -> {
            MongoOperationContext ctx = new MongoOperationContext((ClientSession)clientSession, operation.getRepositoryType(), operation.getAnnotationMetadata());
            StoredQuery storedQuery = operation.getStoredQuery();
            if (storedQuery != null) {
                MongoStoredQuery mongoStoredQuery = this.getMongoStoredQuery(storedQuery);
                MongoReactiveEntitiesOperation<Object> op = this.createMongoDeleteOneInBulkOperation(ctx, mongoStoredQuery.getRuntimePersistentEntity(), Collections.singletonList(operation.getEntity()), mongoStoredQuery);
                op.update();
                return op.getRowsUpdated();
            }
            RuntimePersistentEntity persistentEntity = this.runtimeEntityRegistry.getEntity(operation.getRootEntity());
            MongoReactiveEntityOperation<Object> op = this.createMongoDeleteOneOperation(ctx, persistentEntity, operation.getEntity());
            op.delete();
            return op.getRowsUpdated();
        });
    }

    public <T> Mono<Number> deleteAll(DeleteBatchOperation<T> operation) {
        return this.withClientSession(clientSession -> {
            MongoOperationContext ctx = new MongoOperationContext((ClientSession)clientSession, operation.getRepositoryType(), operation.getAnnotationMetadata());
            StoredQuery storedQuery = operation.getStoredQuery();
            if (storedQuery != null) {
                MongoStoredQuery mongoStoredQuery = this.getMongoStoredQuery(storedQuery);
                MongoReactiveEntitiesOperation op = this.createMongoDeleteOneInBulkOperation(ctx, (RuntimePersistentEntity)mongoStoredQuery.getRuntimePersistentEntity(), (Iterable)operation, mongoStoredQuery);
                op.update();
                return op.getRowsUpdated();
            }
            RuntimePersistentEntity persistentEntity = this.runtimeEntityRegistry.getEntity(operation.getRootEntity());
            if (operation.all()) {
                MongoDatabase mongoDatabase = this.getDatabase((PersistentEntity)persistentEntity, ctx.repositoryType);
                return Mono.from((Publisher)this.getCollection(mongoDatabase, persistentEntity, persistentEntity.getIntrospection().getBeanType()).deleteMany((Bson)EMPTY)).map(DeleteResult::getDeletedCount);
            }
            MongoReactiveEntitiesOperation op = this.createMongoDeleteManyOperation(ctx, (RuntimePersistentEntity)persistentEntity, (Iterable)operation);
            op.delete();
            return op.getRowsUpdated();
        });
    }

    public Mono<Number> executeUpdate(PreparedQuery<?, Number> preparedQuery) {
        return this.withClientSession(clientSession -> {
            MongoPreparedQuery mongoPreparedQuery = this.getMongoPreparedQuery(preparedQuery);
            MongoUpdate updateMany = mongoPreparedQuery.getUpdateMany();
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing Mongo 'updateMany' with filter: {} and update: {}", (Object)updateMany.getFilter().toBsonDocument().toJson(), (Object)updateMany.getUpdate().toBsonDocument().toJson());
            }
            return Mono.from((Publisher)this.getCollection(mongoPreparedQuery).updateMany(clientSession, updateMany.getFilter(), updateMany.getUpdate(), updateMany.getOptions())).map(updateResult -> {
                if (mongoPreparedQuery.isOptimisticLock()) {
                    this.checkOptimisticLocking(1, (int)updateResult.getModifiedCount());
                }
                return updateResult.getModifiedCount();
            });
        });
    }

    public Mono<Number> executeDelete(PreparedQuery<?, Number> preparedQuery) {
        return this.withClientSession(clientSession -> {
            MongoPreparedQuery mongoPreparedQuery = this.getMongoPreparedQuery(preparedQuery);
            MongoDelete deleteMany = mongoPreparedQuery.getDeleteMany();
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing Mongo 'deleteMany' with filter: {}", (Object)deleteMany.getFilter().toBsonDocument().toJson());
            }
            return Mono.from((Publisher)this.getCollection(mongoPreparedQuery).deleteMany(clientSession, deleteMany.getFilter(), deleteMany.getOptions())).map(deleteResult -> {
                if (mongoPreparedQuery.isOptimisticLock()) {
                    this.checkOptimisticLocking(1, (int)deleteResult.getDeletedCount());
                }
                return deleteResult.getDeletedCount();
            });
        });
    }

    private <T, R> Flux<R> findAll(ClientSession clientSession, MongoPreparedQuery<T, R> preparedQuery) {
        if (preparedQuery.isCount()) {
            return this.getCount(clientSession, preparedQuery).flux();
        }
        if (preparedQuery.isAggregate()) {
            return this.findAllAggregated(clientSession, preparedQuery, preparedQuery.isDtoProjection());
        }
        return Flux.from(this.find(clientSession, preparedQuery));
    }

    private <T, R> Mono<R> getCount(ClientSession clientSession, MongoPreparedQuery<T, R> preparedQuery) {
        Class resultType = preparedQuery.getResultType();
        MongoDatabase database = this.getDatabase(preparedQuery);
        RuntimePersistentEntity<T> persistentEntity = preparedQuery.getPersistentEntity();
        if (preparedQuery.isAggregate()) {
            MongoAggregation aggregation = preparedQuery.getAggregation();
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing Mongo 'aggregate' with pipeline: {}", aggregation.getPipeline().stream().map(e -> e.toBsonDocument().toJson()).toList());
            }
            return Mono.from((Publisher)this.aggregate(clientSession, preparedQuery, BsonDocument.class).first()).map(bsonDocument -> this.convertResult(database.getCodecRegistry(), resultType, (BsonDocument)bsonDocument, false)).switchIfEmpty(Mono.defer(() -> Mono.just((Object)this.conversionService.convertRequired((Object)0, resultType))));
        }
        MongoFind find = preparedQuery.getFind();
        MongoFindOptions options = find.getOptions();
        Bson filter = options == null ? null : options.getFilter();
        Object object = filter = filter == null ? new BsonDocument() : filter;
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Mongo 'countDocuments' with filter: {}", (Object)filter.toBsonDocument().toJson());
        }
        return Mono.from((Publisher)this.getCollection(database, persistentEntity, BsonDocument.class).countDocuments(clientSession, filter)).map(count -> this.conversionService.convertRequired(count, resultType));
    }

    private <T, R> Mono<R> findOneFiltered(ClientSession clientSession, MongoPreparedQuery<T, R> preparedQuery) {
        return Mono.from((Publisher)this.find(clientSession, preparedQuery).limit(1).first()).map(r -> {
            Class type = preparedQuery.getRootEntity();
            RuntimePersistentEntity persistentEntity = preparedQuery.getPersistentEntity();
            if (type.isInstance(r)) {
                return this.triggerPostLoad(preparedQuery.getAnnotationMetadata(), persistentEntity, type.cast(r));
            }
            return r;
        });
    }

    private <T, R> Mono<R> findOneAggregated(ClientSession clientSession, MongoPreparedQuery<T, R> preparedQuery) {
        Class type;
        Class resultType = preparedQuery.getResultType();
        if (!resultType.isAssignableFrom(type = preparedQuery.getRootEntity())) {
            MongoDatabase database = this.getDatabase(preparedQuery);
            return Mono.from((Publisher)this.aggregate(clientSession, preparedQuery, BsonDocument.class).first()).map(bsonDocument -> this.convertResult(database.getCodecRegistry(), resultType, (BsonDocument)bsonDocument, preparedQuery.isDtoProjection()));
        }
        return Mono.from((Publisher)this.aggregate(clientSession, preparedQuery).first()).map(r -> {
            RuntimePersistentEntity persistentEntity = preparedQuery.getPersistentEntity();
            if (type.isInstance(r)) {
                return this.triggerPostLoad(preparedQuery.getAnnotationMetadata(), persistentEntity, type.cast(r));
            }
            return r;
        });
    }

    private <T, R> Flux<R> findAllAggregated(ClientSession clientSession, MongoPreparedQuery<T, R> preparedQuery, boolean isDtoProjection) {
        Flux aggregate;
        Class type = preparedQuery.getRootEntity();
        Class resultType = preparedQuery.getResultType();
        if (!resultType.isAssignableFrom(type)) {
            MongoDatabase database = this.getDatabase(preparedQuery);
            aggregate = Flux.from(this.aggregate(clientSession, preparedQuery, BsonDocument.class)).map(result -> this.convertResult(database.getCodecRegistry(), resultType, (BsonDocument)result, isDtoProjection));
        } else {
            aggregate = Flux.from(this.aggregate(clientSession, preparedQuery));
        }
        return aggregate;
    }

    private <T, R> FindPublisher<R> find(ClientSession clientSession, MongoPreparedQuery<T, R> preparedQuery) {
        return this.find(clientSession, preparedQuery, preparedQuery.getResultType());
    }

    private <T, R, MR> FindPublisher<MR> find(ClientSession clientSession, MongoPreparedQuery<T, R> preparedQuery, Class<MR> resultType) {
        MongoFind find = preparedQuery.getFind();
        if (QUERY_LOG.isDebugEnabled()) {
            this.logFind(find);
        }
        MongoDatabase database = this.getDatabase(preparedQuery);
        MongoCollection<MR> collection = this.getCollection(database, preparedQuery.getPersistentEntity(), resultType);
        FindPublisher findIterable = collection.find(clientSession, resultType);
        return this.applyFindOptions(find.getOptions(), findIterable);
    }

    private <MR> FindPublisher<MR> applyFindOptions(@Nullable MongoFindOptions findOptions, FindPublisher<MR> findIterable) {
        Boolean showRecordId;
        Boolean returnKey;
        Bson min;
        Bson max;
        Boolean partial;
        Boolean noCursorTimeout;
        CursorType cursorType;
        Bson hint;
        String comment;
        Long maxAwaitTimeMS;
        Long maxTimeMS;
        Boolean allowDiskUse;
        Integer batchSize;
        Bson projection;
        Bson sort;
        Integer limit;
        Integer skip;
        Collation collation;
        if (findOptions == null) {
            return findIterable;
        }
        Bson filter = findOptions.getFilter();
        if (filter != null) {
            findIterable = findIterable.filter(filter);
        }
        if ((collation = findOptions.getCollation()) != null) {
            findIterable = findIterable.collation(collation);
        }
        if ((skip = findOptions.getSkip()) != null) {
            findIterable = findIterable.skip(skip.intValue());
        }
        if ((limit = findOptions.getLimit()) != null) {
            findIterable = findIterable.limit(Math.max(limit, 0));
        }
        if ((sort = findOptions.getSort()) != null) {
            findIterable = findIterable.sort(sort);
        }
        if ((projection = findOptions.getProjection()) != null) {
            findIterable = findIterable.projection(projection);
        }
        if ((batchSize = findOptions.getBatchSize()) != null) {
            findIterable = findIterable.batchSize(batchSize.intValue());
        }
        if ((allowDiskUse = findOptions.getAllowDiskUse()) != null) {
            findIterable = findIterable.allowDiskUse(allowDiskUse);
        }
        if ((maxTimeMS = findOptions.getMaxTimeMS()) != null) {
            findIterable = findIterable.maxTime(maxTimeMS.longValue(), TimeUnit.MILLISECONDS);
        }
        if ((maxAwaitTimeMS = findOptions.getMaxAwaitTimeMS()) != null) {
            findIterable = findIterable.maxAwaitTime(maxAwaitTimeMS.longValue(), TimeUnit.MILLISECONDS);
        }
        if ((comment = findOptions.getComment()) != null) {
            findIterable = findIterable.comment(comment);
        }
        if ((hint = findOptions.getHint()) != null) {
            findIterable = findIterable.hint(hint);
        }
        if ((cursorType = findOptions.getCursorType()) != null) {
            findIterable = findIterable.cursorType(cursorType);
        }
        if ((noCursorTimeout = findOptions.getNoCursorTimeout()) != null) {
            findIterable = findIterable.noCursorTimeout(noCursorTimeout.booleanValue());
        }
        if ((partial = findOptions.getPartial()) != null) {
            findIterable = findIterable.partial(partial.booleanValue());
        }
        if ((max = findOptions.getMax()) != null) {
            findIterable = findIterable.max(max);
        }
        if ((min = findOptions.getMin()) != null) {
            findIterable = findIterable.min(min);
        }
        if ((returnKey = findOptions.getReturnKey()) != null) {
            findIterable = findIterable.returnKey(returnKey.booleanValue());
        }
        if ((showRecordId = findOptions.getShowRecordId()) != null) {
            findIterable = findIterable.showRecordId(showRecordId.booleanValue());
        }
        return findIterable;
    }

    private <T, R, MR> AggregatePublisher<MR> aggregate(ClientSession clientSession, MongoPreparedQuery<T, R> preparedQuery, Class<MR> resultType) {
        MongoDatabase database = this.getDatabase(preparedQuery);
        MongoCollection<MR> collection = this.getCollection(database, preparedQuery.getPersistentEntity(), resultType);
        MongoAggregation aggregation = preparedQuery.getAggregation();
        if (QUERY_LOG.isDebugEnabled()) {
            this.logAggregate(aggregation);
        }
        AggregatePublisher aggregateIterable = collection.aggregate(clientSession, aggregation.getPipeline(), resultType);
        return this.applyAggregateOptions(aggregation.getOptions(), aggregateIterable);
    }

    private <T, R> AggregatePublisher<R> aggregate(ClientSession clientSession, MongoPreparedQuery<T, R> preparedQuery) {
        return this.aggregate(clientSession, preparedQuery, preparedQuery.getResultType());
    }

    private <MR> AggregatePublisher<MR> applyAggregateOptions(@Nullable MongoAggregationOptions aggregateOptions, AggregatePublisher<MR> aggregateIterable) {
        Bson hint;
        String comment;
        Boolean bypassDocumentValidation;
        Long maxTimeMS;
        Boolean allowDiskUse;
        if (aggregateOptions == null) {
            return aggregateIterable;
        }
        if (aggregateOptions.getCollation() != null) {
            aggregateIterable = aggregateIterable.collation(aggregateOptions.getCollation());
        }
        if ((allowDiskUse = aggregateOptions.getAllowDiskUse()) != null) {
            aggregateIterable = aggregateIterable.allowDiskUse(allowDiskUse);
        }
        if ((maxTimeMS = aggregateOptions.getMaxTimeMS()) != null) {
            aggregateIterable = aggregateIterable.maxTime(maxTimeMS.longValue(), TimeUnit.MILLISECONDS);
        }
        Long maxAwaitTimeMS = aggregateOptions.getMaxAwaitTimeMS();
        if (maxTimeMS != null) {
            aggregateIterable = aggregateIterable.maxAwaitTime(maxAwaitTimeMS.longValue(), TimeUnit.MILLISECONDS);
        }
        if ((bypassDocumentValidation = aggregateOptions.getBypassDocumentValidation()) != null) {
            aggregateIterable = aggregateIterable.bypassDocumentValidation(bypassDocumentValidation);
        }
        if ((comment = aggregateOptions.getComment()) != null) {
            aggregateIterable = aggregateIterable.comment(comment);
        }
        if ((hint = aggregateOptions.getHint()) != null) {
            aggregateIterable = aggregateIterable.hint(hint);
        }
        return aggregateIterable;
    }

    private <K> K triggerPostLoad(AnnotationMetadata annotationMetadata, RuntimePersistentEntity<K> persistentEntity, K entity) {
        if (persistentEntity.hasPostLoadEventListeners()) {
            entity = this.triggerPostLoad(entity, persistentEntity, annotationMetadata);
        }
        block4: for (PersistentProperty pp : persistentEntity.getPersistentProperties()) {
            RuntimeAssociation runtimeAssociation;
            Object o;
            if (!(pp instanceof RuntimeAssociation) || (o = (runtimeAssociation = (RuntimeAssociation)pp).getProperty().get(entity)) == null) continue;
            RuntimePersistentEntity associatedEntity = runtimeAssociation.getAssociatedEntity();
            switch (runtimeAssociation.getKind()) {
                case MANY_TO_MANY: 
                case ONE_TO_MANY: {
                    if (!(o instanceof Iterable)) continue block4;
                    Iterable iterable = (Iterable)o;
                    for (Object value : iterable) {
                        this.triggerPostLoad(value, associatedEntity, annotationMetadata);
                    }
                    continue block4;
                }
                case MANY_TO_ONE: 
                case ONE_TO_ONE: 
                case EMBEDDED: {
                    this.triggerPostLoad(o, associatedEntity, annotationMetadata);
                    continue block4;
                }
            }
            throw new IllegalStateException("Unknown kind: " + String.valueOf(runtimeAssociation.getKind()));
        }
        return entity;
    }

    private <T> MongoCollection<T> getCollection(RuntimePersistentEntity<T> persistentEntity, Class<?> repositoryClass) {
        return this.getDatabase((PersistentEntity)persistentEntity, repositoryClass).getCollection(persistentEntity.getPersistedName(), persistentEntity.getIntrospection().getBeanType());
    }

    public <T> Mono<T> persistOne(MongoOperationContext ctx, T value, RuntimePersistentEntity<T> persistentEntity) {
        MongoReactiveEntityOperation<T> op = this.createMongoInsertOneOperation(ctx, persistentEntity, value);
        op.persist();
        return op.getEntity();
    }

    public <T> Flux<T> persistBatch(MongoOperationContext ctx, Iterable<T> values, RuntimePersistentEntity<T> persistentEntity, Predicate<T> predicate) {
        MongoReactiveEntitiesOperation<T> op = this.createMongoInsertManyOperation(ctx, persistentEntity, values);
        if (predicate != null) {
            op.veto(predicate);
        }
        op.persist();
        return op.getEntities();
    }

    public <T> Mono<T> updateOne(MongoOperationContext ctx, T value, RuntimePersistentEntity<T> persistentEntity) {
        MongoReactiveEntityOperation<T> op = this.createMongoReplaceOneOperation(ctx, persistentEntity, value);
        op.update();
        return op.getEntity();
    }

    private <T> Flux<T> updateBatch(MongoOperationContext ctx, Iterable<T> values, RuntimePersistentEntity<T> persistentEntity) {
        MongoReactiveEntitiesOperation<T> op = this.createMongoReplaceOneInBulkOperation(ctx, persistentEntity, values);
        op.update();
        return op.getEntities();
    }

    @Override
    protected MongoDatabase getDatabase(PersistentEntity persistentEntity, Class<?> repository) {
        return this.mongoClient.getDatabase(this.databaseNameProvider.provide(persistentEntity, repository));
    }

    private MongoDatabase getDatabase(MongoPreparedQuery<?, ?> preparedQuery) {
        return this.getDatabase((PersistentEntity)preparedQuery.getPersistentEntity(), (Class<?>)preparedQuery.getRepositoryType());
    }

    private <E> MongoCollection<E> getCollection(MongoPreparedQuery<E, ?> preparedQuery) {
        return this.getCollection(this.getDatabase(preparedQuery), preparedQuery.getPersistentEntity(), preparedQuery.getRootEntity());
    }

    private <E> MongoCollection<E> getCollection(MongoOperationContext ctx, RuntimePersistentEntity<E> persistentEntity) {
        return this.getCollection(persistentEntity, ctx.repositoryType, persistentEntity.getIntrospection().getBeanType());
    }

    private <T, R> MongoCollection<R> getCollection(MongoDatabase database, RuntimePersistentEntity<T> persistentEntity, Class<R> resultType) {
        return database.getCollection(this.collectionNameProvider.provide((PersistentEntity)persistentEntity), resultType);
    }

    private <T, R> MongoCollection<R> getCollection(RuntimePersistentEntity<T> persistentEntity, Class<?> repositoryClass, Class<R> resultType) {
        return this.getDatabase((PersistentEntity)persistentEntity, repositoryClass).getCollection(this.collectionNameProvider.provide((PersistentEntity)persistentEntity), resultType);
    }

    @Override
    protected CodecRegistry getCodecRegistry(MongoDatabase mongoDatabase) {
        return mongoDatabase.getCodecRegistry();
    }

    public Mono<Void> persistManyAssociation(MongoOperationContext ctx, RuntimeAssociation runtimeAssociation, Object value, RuntimePersistentEntity<Object> persistentEntity, Object child, RuntimePersistentEntity<Object> childPersistentEntity) {
        String joinCollectionName = runtimeAssociation.getOwner().getNamingStrategy().mappedName((Association)runtimeAssociation);
        MongoDatabase mongoDatabase = this.getDatabase((PersistentEntity)persistentEntity, (Class<?>)ctx.repositoryType);
        MongoCollection collection = mongoDatabase.getCollection(joinCollectionName, BsonDocument.class);
        BsonDocument association = this.association(collection.getCodecRegistry(), value, persistentEntity, child, childPersistentEntity);
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Mongo 'insertOne' for collection: {} with document: {}", (Object)collection.getNamespace().getFullName(), (Object)association);
        }
        return Mono.from((Publisher)collection.insertOne(ctx.clientSession, (Object)association, this.getInsertOneOptions(ctx.annotationMetadata))).then();
    }

    public Mono<Void> persistManyAssociationBatch(MongoOperationContext ctx, RuntimeAssociation runtimeAssociation, Object value, RuntimePersistentEntity<Object> persistentEntity, Iterable<Object> child, RuntimePersistentEntity<Object> childPersistentEntity, Predicate<Object> veto) {
        String joinCollectionName = runtimeAssociation.getOwner().getNamingStrategy().mappedName((Association)runtimeAssociation);
        MongoCollection collection = this.getDatabase((PersistentEntity)persistentEntity, (Class<?>)ctx.repositoryType).getCollection(joinCollectionName, BsonDocument.class);
        ArrayList<BsonDocument> associations = new ArrayList<BsonDocument>();
        for (Object c : child) {
            associations.add(this.association(collection.getCodecRegistry(), value, persistentEntity, c, childPersistentEntity));
        }
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Mongo 'insertMany' for collection: {} with associations: {}", (Object)collection.getNamespace().getFullName(), associations);
        }
        return Mono.from((Publisher)collection.insertMany(ctx.clientSession, associations, this.getInsertManyOptions(ctx.annotationMetadata))).then();
    }

    @Override
    public <T> Mono<T> withClientSession(Function<ClientSession, Mono<T>> function) {
        return this.connectionOperations.withConnectionMono(status -> (Mono)function.apply((ClientSession)status.getConnection()));
    }

    @Override
    public <T> Flux<T> withClientSessionMany(Function<ClientSession, Flux<T>> function) {
        return this.connectionOperations.withConnectionFlux(status -> (Flux)function.apply((ClientSession)status.getConnection()));
    }

    private <T> MongoReactiveEntityOperation<T> createMongoInsertOneOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, T entity) {
        return new MongoReactiveEntityOperation<T>(ctx, (RuntimePersistentEntity)persistentEntity, (Object)entity, true){

            protected void execute() throws RuntimeException {
                MongoDatabase mongoDatabase = DefaultReactiveMongoRepositoryOperations.this.getDatabase((PersistentEntity)this.persistentEntity, ((MongoOperationContext)this.ctx).repositoryType);
                MongoCollection collection = DefaultReactiveMongoRepositoryOperations.this.getCollection(mongoDatabase, this.persistentEntity, this.persistentEntity.getIntrospection().getBeanType());
                this.data = this.data.flatMap(d -> {
                    if (QUERY_LOG.isDebugEnabled()) {
                        QUERY_LOG.debug("Executing Mongo 'insertOne' with entity: {}", d.entity);
                    }
                    return Mono.from((Publisher)collection.insertOne(((MongoOperationContext)this.ctx).clientSession, d.entity, DefaultReactiveMongoRepositoryOperations.this.getInsertOneOptions(((MongoOperationContext)this.ctx).annotationMetadata))).map(insertOneResult -> {
                        BsonValue insertedId = insertOneResult.getInsertedId();
                        BeanProperty property = this.persistentEntity.getIdentity().getProperty();
                        if (property.get(d.entity) == null) {
                            d.entity = this.updateEntityId(property, d.entity, insertedId);
                        }
                        return d;
                    });
                });
            }
        };
    }

    private <T> MongoReactiveEntityOperation<T> createMongoReplaceOneOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, T entity) {
        return new MongoReactiveEntityOperation<T>(ctx, (RuntimePersistentEntity)persistentEntity, (Object)entity, false){
            final MongoDatabase mongoDatabase;
            final MongoCollection<BsonDocument> collection;
            {
                this.mongoDatabase = DefaultReactiveMongoRepositoryOperations.this.getDatabase((PersistentEntity)this.persistentEntity, ((MongoOperationContext)this.ctx).repositoryType);
                this.collection = DefaultReactiveMongoRepositoryOperations.this.getCollection(this.mongoDatabase, this.persistentEntity, BsonDocument.class);
            }

            @Override
            protected void collectAutoPopulatedPreviousValues() {
                this.data = this.data.map(d -> {
                    d.filter = DefaultReactiveMongoRepositoryOperations.this.createFilterIdAndVersion(this.persistentEntity, d.entity, this.collection.getCodecRegistry());
                    return d;
                });
            }

            protected void execute() throws RuntimeException {
                this.data = this.data.flatMap(d -> {
                    Bson filter = (Bson)d.filter;
                    if (QUERY_LOG.isDebugEnabled()) {
                        QUERY_LOG.debug("Executing Mongo 'replaceOne' with filter: {}", (Object)filter.toBsonDocument().toJson());
                    }
                    BsonDocument bsonDocument = BsonDocumentWrapper.asBsonDocument((Object)d.entity, (CodecRegistry)this.mongoDatabase.getCodecRegistry());
                    bsonDocument.remove((Object)"_id");
                    return Mono.from((Publisher)this.collection.replaceOne(((MongoOperationContext)this.ctx).clientSession, filter, (Object)bsonDocument, DefaultReactiveMongoRepositoryOperations.this.getReplaceOptions(((MongoOperationContext)this.ctx).annotationMetadata))).map(updateResult -> {
                        d.rowsUpdated = updateResult.getModifiedCount();
                        if (this.persistentEntity.getVersion() != null) {
                            this.checkOptimisticLocking(1L, (int)d.rowsUpdated);
                        }
                        return d;
                    });
                });
            }
        };
    }

    private <T> MongoReactiveEntitiesOperation<T> createMongoReplaceOneInBulkOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities) {
        return new MongoReactiveEntitiesOperation<T>(ctx, (RuntimePersistentEntity)persistentEntity, (Iterable)entities, false){
            final MongoDatabase mongoDatabase;
            final MongoCollection<BsonDocument> collection;
            {
                this.mongoDatabase = DefaultReactiveMongoRepositoryOperations.this.getDatabase((PersistentEntity)this.persistentEntity, ((MongoOperationContext)this.ctx).repositoryType);
                this.collection = DefaultReactiveMongoRepositoryOperations.this.getCollection(this.mongoDatabase, this.persistentEntity, BsonDocument.class);
            }

            @Override
            protected void collectAutoPopulatedPreviousValues() {
                this.entities = this.entities.map(list -> {
                    for (AbstractReactiveEntitiesOperations.Data d : list) {
                        if (d.vetoed) continue;
                        d.filter = DefaultReactiveMongoRepositoryOperations.this.createFilterIdAndVersion(this.persistentEntity, d.entity, this.collection.getCodecRegistry());
                    }
                    return list;
                });
            }

            protected void execute() throws RuntimeException {
                Mono entitiesWithRowsUpdated = this.entities.flatMap(list -> {
                    ArrayList<ReplaceOneModel> replaces = new ArrayList<ReplaceOneModel>(list.size());
                    for (AbstractReactiveEntitiesOperations.Data d : list) {
                        if (d.vetoed) continue;
                        Bson filter = (Bson)d.filter;
                        if (QUERY_LOG.isDebugEnabled()) {
                            QUERY_LOG.debug("Executing Mongo 'replaceOne' with filter: {}", (Object)filter.toBsonDocument().toJson());
                        }
                        BsonDocument bsonDocument = BsonDocumentWrapper.asBsonDocument((Object)d.entity, (CodecRegistry)this.mongoDatabase.getCodecRegistry());
                        bsonDocument.remove((Object)"_id");
                        replaces.add(new ReplaceOneModel(filter, (Object)bsonDocument, DefaultReactiveMongoRepositoryOperations.this.getReplaceOptions(((MongoOperationContext)this.ctx).annotationMetadata)));
                    }
                    return Mono.from((Publisher)this.collection.bulkWrite(((MongoOperationContext)this.ctx).clientSession, replaces)).map(bulkWriteResult -> {
                        if (this.persistentEntity.getVersion() != null) {
                            this.checkOptimisticLocking(replaces.size(), bulkWriteResult.getModifiedCount());
                        }
                        return Tuples.of((Object)list, (Object)bulkWriteResult.getModifiedCount());
                    });
                }).cache();
                this.entities = entitiesWithRowsUpdated.flatMap(t -> Mono.just((Object)((List)t.getT1())));
                this.rowsUpdated = entitiesWithRowsUpdated.map(Tuple2::getT2);
            }
        };
    }

    private <T> MongoReactiveEntitiesOperation<T> createMongoUpdateOneInBulkOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities, final MongoStoredQuery<T, ?> storedQuery) {
        return new MongoReactiveEntitiesOperation<T>(ctx, persistentEntity, entities, false){

            protected void execute() throws RuntimeException {
                Mono entitiesWithRowsUpdated = this.entities.flatMap(list -> {
                    ArrayList<UpdateOneModel> updates = new ArrayList<UpdateOneModel>(list.size());
                    for (AbstractReactiveEntitiesOperations.Data d : list) {
                        if (d.vetoed) continue;
                        MongoUpdate updateOne = storedQuery.getUpdateOne(d.entity);
                        updates.add(new UpdateOneModel(updateOne.getFilter(), updateOne.getUpdate(), updateOne.getOptions()));
                    }
                    Mono modifiedCount = Mono.from((Publisher)DefaultReactiveMongoRepositoryOperations.this.getCollection((MongoOperationContext)this.ctx, this.persistentEntity).bulkWrite(((MongoOperationContext)this.ctx).clientSession, updates)).map(result -> {
                        if (storedQuery.isOptimisticLock()) {
                            this.checkOptimisticLocking(updates.size(), result.getModifiedCount());
                        }
                        return result.getModifiedCount();
                    });
                    return modifiedCount.map(count -> Tuples.of((Object)list, (Object)count));
                }).cache();
                this.entities = entitiesWithRowsUpdated.flatMap(t -> Mono.just((Object)((List)t.getT1())));
                this.rowsUpdated = entitiesWithRowsUpdated.map(Tuple2::getT2);
            }
        };
    }

    private <T> MongoReactiveEntityOperation<T> createMongoDeleteOneOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, T entity) {
        return new MongoReactiveEntityOperation<T>(ctx, (RuntimePersistentEntity)persistentEntity, (Object)entity, false){
            final MongoDatabase mongoDatabase;
            final MongoCollection<T> collection;
            {
                this.mongoDatabase = DefaultReactiveMongoRepositoryOperations.this.getDatabase((PersistentEntity)this.persistentEntity, ((MongoOperationContext)this.ctx).repositoryType);
                this.collection = DefaultReactiveMongoRepositoryOperations.this.getCollection(this.mongoDatabase, this.persistentEntity, this.persistentEntity.getIntrospection().getBeanType());
            }

            @Override
            protected void collectAutoPopulatedPreviousValues() {
                this.data = this.data.map(d -> {
                    if (d.vetoed) {
                        return d;
                    }
                    d.filter = DefaultReactiveMongoRepositoryOperations.this.createFilterIdAndVersion(this.persistentEntity, d.entity, this.collection.getCodecRegistry());
                    return d;
                });
            }

            protected void execute() throws RuntimeException {
                this.data = this.data.flatMap(d -> {
                    Bson filter = (Bson)d.filter;
                    if (QUERY_LOG.isDebugEnabled()) {
                        QUERY_LOG.debug("Executing Mongo 'deleteOne' with filter: {}", (Object)filter.toBsonDocument().toJson());
                    }
                    return Mono.from((Publisher)DefaultReactiveMongoRepositoryOperations.this.getCollection(this.persistentEntity, ((MongoOperationContext)this.ctx).repositoryType).deleteOne(((MongoOperationContext)this.ctx).clientSession, filter, DefaultReactiveMongoRepositoryOperations.this.getDeleteOptions(((MongoOperationContext)this.ctx).annotationMetadata))).map(deleteResult -> {
                        d.rowsUpdated = (int)deleteResult.getDeletedCount();
                        if (this.persistentEntity.getVersion() != null) {
                            this.checkOptimisticLocking(1L, d.rowsUpdated);
                        }
                        return d;
                    });
                });
            }
        };
    }

    private <T> MongoReactiveEntitiesOperation<T> createMongoDeleteManyOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities) {
        return new MongoReactiveEntitiesOperation<T>(ctx, (RuntimePersistentEntity)persistentEntity, (Iterable)entities, false){
            final MongoDatabase mongoDatabase;
            final MongoCollection<T> collection;
            {
                this.mongoDatabase = DefaultReactiveMongoRepositoryOperations.this.getDatabase((PersistentEntity)this.persistentEntity, ((MongoOperationContext)this.ctx).repositoryType);
                this.collection = DefaultReactiveMongoRepositoryOperations.this.getCollection(this.mongoDatabase, this.persistentEntity, this.persistentEntity.getIntrospection().getBeanType());
            }

            @Override
            protected void collectAutoPopulatedPreviousValues() {
                this.entities = this.entities.map(list -> {
                    for (AbstractReactiveEntitiesOperations.Data d : list) {
                        if (d.vetoed) continue;
                        d.filter = DefaultReactiveMongoRepositoryOperations.this.createFilterIdAndVersion(this.persistentEntity, d.entity, this.collection.getCodecRegistry());
                    }
                    return list;
                });
            }

            protected void execute() throws RuntimeException {
                Mono entitiesWithRowsUpdated = this.entities.flatMap(list -> {
                    Mono modifiedCount;
                    List<Bson> filters = list.stream().filter(d -> !d.vetoed).map(d -> (Bson)d.filter).toList();
                    if (!filters.isEmpty()) {
                        Bson filter = Filters.or(filters);
                        if (QUERY_LOG.isDebugEnabled()) {
                            QUERY_LOG.debug("Executing Mongo 'deleteMany' with filter: {}", (Object)filter.toBsonDocument().toJson());
                        }
                        modifiedCount = Mono.from((Publisher)this.collection.deleteMany(((MongoOperationContext)this.ctx).clientSession, filter, DefaultReactiveMongoRepositoryOperations.this.getDeleteOptions(((MongoOperationContext)this.ctx).annotationMetadata))).map(DeleteResult::getDeletedCount);
                    } else {
                        modifiedCount = Mono.just((Object)0L);
                    }
                    if (this.persistentEntity.getVersion() != null) {
                        modifiedCount = modifiedCount.map(count -> {
                            this.checkOptimisticLocking(filters.size(), (long)count);
                            return count;
                        });
                    }
                    return modifiedCount.map(count -> Tuples.of((Object)list, (Object)count));
                }).cache();
                this.entities = entitiesWithRowsUpdated.flatMap(t -> Mono.just((Object)((List)t.getT1())));
                this.rowsUpdated = entitiesWithRowsUpdated.map(Tuple2::getT2);
            }
        };
    }

    private <T> MongoReactiveEntitiesOperation<T> createMongoDeleteOneInBulkOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities, final MongoStoredQuery<T, Number> storedQuery) {
        return new MongoReactiveEntitiesOperation<T>(ctx, persistentEntity, entities, false){

            protected void execute() throws RuntimeException {
                Mono entitiesWithRowsUpdated = this.entities.flatMap(list -> {
                    ArrayList<DeleteOneModel> deletes = new ArrayList<DeleteOneModel>(list.size());
                    for (AbstractReactiveEntitiesOperations.Data d : list) {
                        if (d.vetoed) continue;
                        MongoDelete deleteOne = storedQuery.getDeleteOne(d.entity);
                        deletes.add(new DeleteOneModel(deleteOne.getFilter(), deleteOne.getOptions()));
                    }
                    return Mono.from((Publisher)DefaultReactiveMongoRepositoryOperations.this.getCollection((MongoOperationContext)this.ctx, this.persistentEntity).bulkWrite(((MongoOperationContext)this.ctx).clientSession, deletes)).map(bulkWriteResult -> {
                        if (storedQuery.isOptimisticLock()) {
                            this.checkOptimisticLocking(deletes.size(), bulkWriteResult.getDeletedCount());
                        }
                        return Tuples.of((Object)list, (Object)bulkWriteResult.getDeletedCount());
                    });
                }).cache();
                this.entities = entitiesWithRowsUpdated.flatMap(t -> Mono.just((Object)((List)t.getT1())));
                this.rowsUpdated = entitiesWithRowsUpdated.map(Tuple2::getT2);
            }
        };
    }

    private <T> MongoReactiveEntitiesOperation<T> createMongoInsertManyOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities) {
        return new MongoReactiveEntitiesOperation<T>(ctx, (RuntimePersistentEntity)persistentEntity, (Iterable)entities, true){

            protected void execute() throws RuntimeException {
                this.entities = this.entities.flatMap(list -> {
                    List<Object> toInsert = list.stream().filter(d -> !d.vetoed).map(d -> d.entity).toList();
                    if (toInsert.isEmpty()) {
                        return Mono.just((Object)list);
                    }
                    MongoCollection collection = DefaultReactiveMongoRepositoryOperations.this.getCollection(this.persistentEntity, ((MongoOperationContext)this.ctx).repositoryType);
                    if (QUERY_LOG.isDebugEnabled()) {
                        QUERY_LOG.debug("Executing Mongo 'insertMany' for collection: {} with documents: {}", (Object)collection.getNamespace().getFullName(), toInsert);
                    }
                    return Mono.from((Publisher)collection.insertMany(((MongoOperationContext)this.ctx).clientSession, toInsert, DefaultReactiveMongoRepositoryOperations.this.getInsertManyOptions(((MongoOperationContext)this.ctx).annotationMetadata))).flatMap(insertManyResult -> {
                        if (this.hasGeneratedId) {
                            Map insertedIds = insertManyResult.getInsertedIds();
                            RuntimePersistentProperty identity = this.persistentEntity.getIdentity();
                            BeanProperty idProperty = identity.getProperty();
                            int index = 0;
                            for (AbstractReactiveEntitiesOperations.Data d : list) {
                                if (!d.vetoed) {
                                    BsonValue id = (BsonValue)insertedIds.get(index);
                                    if (id == null) {
                                        throw new DataAccessException("Failed to generate ID for entity: " + String.valueOf(d.entity));
                                    }
                                    d.entity = this.updateEntityId(idProperty, d.entity, id);
                                }
                                ++index;
                            }
                        }
                        return Mono.just((Object)list);
                    });
                });
            }
        };
    }

    protected static final class MongoOperationContext
    extends OperationContext {
        private final ClientSession clientSession;

        public MongoOperationContext(ClientSession clientSession, Class<?> repositoryType, AnnotationMetadata annotationMetadata) {
            super(annotationMetadata, repositoryType);
            this.clientSession = clientSession;
        }
    }

    private abstract class MongoReactiveEntityOperation<T>
    extends AbstractReactiveEntityOperations<MongoOperationContext, T, RuntimeException> {
        protected MongoReactiveEntityOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, T entity, boolean insert) {
            super((OperationContext)ctx, DefaultReactiveMongoRepositoryOperations.this.cascadeOperations, (ConversionService)DefaultReactiveMongoRepositoryOperations.this.conversionService, DefaultReactiveMongoRepositoryOperations.this.entityEventRegistry, persistentEntity, entity, insert);
        }

        protected void collectAutoPopulatedPreviousValues() {
        }
    }

    private abstract class MongoReactiveEntitiesOperation<T>
    extends AbstractReactiveEntitiesOperations<MongoOperationContext, T, RuntimeException> {
        protected MongoReactiveEntitiesOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities, boolean insert) {
            super((OperationContext)ctx, DefaultReactiveMongoRepositoryOperations.this.cascadeOperations, (ConversionService)DefaultReactiveMongoRepositoryOperations.this.conversionService, DefaultReactiveMongoRepositoryOperations.this.entityEventRegistry, persistentEntity, entities, insert);
        }

        protected void collectAutoPopulatedPreviousValues() {
        }
    }
}

