/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.operations;

import com.mongodb.client.model.Collation;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.UpdateOptions;
import io.micronaut.aop.InvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.model.runtime.convert.AttributeConverter;
import io.micronaut.data.mongodb.annotation.MongoCollation;
import io.micronaut.data.mongodb.annotation.MongoProjection;
import io.micronaut.data.mongodb.annotation.MongoSort;
import io.micronaut.data.mongodb.operations.MongoAggregation;
import io.micronaut.data.mongodb.operations.MongoDelete;
import io.micronaut.data.mongodb.operations.MongoFind;
import io.micronaut.data.mongodb.operations.MongoStoredQuery;
import io.micronaut.data.mongodb.operations.MongoUpdate;
import io.micronaut.data.mongodb.operations.MongoUtils;
import io.micronaut.data.mongodb.operations.options.MongoAggregationOptions;
import io.micronaut.data.mongodb.operations.options.MongoFindOptions;
import io.micronaut.data.mongodb.operations.options.MongoOptionsUtils;
import io.micronaut.data.runtime.operations.internal.query.BindableParametersStoredQuery;
import io.micronaut.data.runtime.operations.internal.query.DefaultBindableParametersStoredQuery;
import io.micronaut.data.runtime.query.internal.DefaultStoredQuery;
import io.micronaut.data.runtime.query.internal.DelegateStoredQuery;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonObjectId;
import org.bson.BsonRegularExpression;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
final class DefaultMongoStoredQuery<E, R>
extends DefaultBindableParametersStoredQuery<E, R>
implements DelegateStoredQuery<E, R>,
MongoStoredQuery<E, R> {
    private static final Pattern MONGO_PARAM_PATTERN = Pattern.compile("\\W*(\\$mn_qp:(\\d)+)\\W*");
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMongoStoredQuery.class);
    private static final BsonDocument EMPTY = new BsonDocument();
    private final StoredQuery<E, R> storedQuery;
    private final Supplier<CodecRegistry> codecRegistry;
    private final AttributeConverterRegistry attributeConverterRegistry;
    private final RuntimeEntityRegistry runtimeEntityRegistry;
    private final ConversionService conversionService;
    private final RuntimePersistentEntity<E> persistentEntity;
    private final UpdateData updateData;
    private final FindData findData;
    private final AggregateData aggregateData;
    private final DeleteData deleteData;
    private final boolean isCount;

    DefaultMongoStoredQuery(StoredQuery<E, R> storedQuery, Supplier<CodecRegistry> codecRegistry, AttributeConverterRegistry attributeConverterRegistry, RuntimeEntityRegistry runtimeEntityRegistry, ConversionService conversionService, RuntimePersistentEntity<E> persistentEntity) {
        this(storedQuery, codecRegistry, attributeConverterRegistry, runtimeEntityRegistry, conversionService, persistentEntity, storedQuery.getAnnotationMetadata().stringValue(Query.class, "update").orElse(null));
    }

    DefaultMongoStoredQuery(StoredQuery<E, R> storedQuery, Supplier<CodecRegistry> codecRegistry, AttributeConverterRegistry attributeConverterRegistry, RuntimeEntityRegistry runtimeEntityRegistry, ConversionService conversionService, RuntimePersistentEntity<E> persistentEntity, String updateJson) {
        super(storedQuery, persistentEntity);
        String query;
        this.storedQuery = storedQuery;
        this.codecRegistry = codecRegistry;
        this.attributeConverterRegistry = attributeConverterRegistry;
        this.runtimeEntityRegistry = runtimeEntityRegistry;
        this.conversionService = conversionService;
        this.persistentEntity = persistentEntity;
        StoredQuery.OperationType operationType = storedQuery.getOperationType();
        if (operationType == StoredQuery.OperationType.QUERY || operationType == StoredQuery.OperationType.EXISTS || operationType == StoredQuery.OperationType.COUNT) {
            query = storedQuery.getQuery();
            String filterParameter = this.getParameterInRole("filter");
            String filterOptionsParameter = this.getParameterInRole("findOptions");
            String pipelineParameter = this.getParameterInRole("pipeline");
            if (filterParameter != null || filterOptionsParameter != null) {
                this.aggregateData = null;
                this.findData = new FindData(filterParameter, filterOptionsParameter);
            } else if (pipelineParameter != null) {
                this.aggregateData = new AggregateData(pipelineParameter, this.getParameterInRole("aggregateOptions"));
                this.findData = null;
            } else if (StringUtils.isEmpty((CharSequence)query)) {
                this.aggregateData = null;
                this.findData = new FindData((Bson)BsonDocument.parse((String)query));
            } else if (query.startsWith("[")) {
                this.aggregateData = new AggregateData(this.parseAggregation(query, storedQuery.isCount()));
                this.findData = null;
            } else {
                this.aggregateData = null;
                this.findData = new FindData((Bson)BsonDocument.parse((String)query));
            }
            this.isCount = operationType == StoredQuery.OperationType.COUNT || storedQuery.isCount() || query.contains("$count");
        } else {
            this.aggregateData = null;
            this.findData = null;
            this.isCount = false;
        }
        this.deleteData = operationType == StoredQuery.OperationType.DELETE ? new DeleteData((Bson)(StringUtils.isEmpty((CharSequence)(query = storedQuery.getQuery())) ? EMPTY : BsonDocument.parse((String)query)), this.getParameterInRole("filter"), this.getParameterInRole("deleteOptions")) : null;
        if (operationType == StoredQuery.OperationType.UPDATE) {
            if (StringUtils.isEmpty((CharSequence)updateJson)) {
                throw new IllegalStateException("Update query is expected!");
            }
            query = storedQuery.getQuery();
            this.updateData = new UpdateData((Bson)BsonDocument.parse((String)updateJson), (Bson)(StringUtils.isEmpty((CharSequence)query) ? EMPTY : BsonDocument.parse((String)query)), this.getParameterInRole("filter"), this.getParameterInRole("update"), this.getParameterInRole("updateOptions"));
        } else {
            this.updateData = null;
        }
    }

    private List<Bson> parseAggregation(String query, boolean isCount) {
        List<Bson> pipeline = BsonArray.parse((String)query).stream().map(BsonValue::asDocument).toList();
        if (isCount && pipeline.stream().noneMatch(p -> p.toBsonDocument().containsKey((Object)"$count"))) {
            ArrayList<Bson> countPipeline = new ArrayList<Bson>(pipeline);
            countPipeline.add((Bson)BsonDocument.parse((String)"{ $count: \"totalCount\" }"));
            return countPipeline;
        }
        return pipeline;
    }

    public boolean isCount() {
        return this.isCount;
    }

    @Nullable
    private String getParameterInRole(String role) {
        if (this.storedQuery instanceof DefaultStoredQuery) {
            return this.storedQuery.getAnnotationMetadata().getAnnotation(DataMethod.class).stringValue(role).orElse(null);
        }
        return null;
    }

    @Nullable
    private int getParameterIndexByName(@Nullable String name) {
        if (name == null) {
            return -1;
        }
        StoredQuery<E, R> storedQuery = this.storedQuery;
        if (storedQuery instanceof DefaultStoredQuery) {
            DefaultStoredQuery defaultStoredQuery = (DefaultStoredQuery)storedQuery;
            String[] argumentNames = defaultStoredQuery.getMethod().getArgumentNames();
            for (int i = 0; i < argumentNames.length; ++i) {
                String argumentName = argumentNames[i];
                if (!argumentName.equals(name)) continue;
                return i;
            }
            throw new IllegalStateException("Unknown parameter with name: " + name);
        }
        throw new IllegalStateException("Expected DefaultStoredQuery");
    }

    @Nullable
    private <X> X getParameterAtIndex(InvocationContext<?, ?> invocationContext, int index) {
        this.requireInvocationContext(invocationContext);
        return (X)invocationContext.getParameterValues()[index];
    }

    @Override
    public RuntimePersistentEntity<E> getRuntimePersistentEntity() {
        return this.persistentEntity;
    }

    @Override
    public boolean isAggregate() {
        return this.aggregateData != null;
    }

    @Override
    public MongoAggregation getAggregation(InvocationContext<?, ?> invocationContext) {
        if (this.aggregateData == null) {
            throw new IllegalStateException("Expected aggregation query!");
        }
        return this.aggregateData.getAggregation(invocationContext);
    }

    @Override
    public MongoFind getFind(InvocationContext<?, ?> invocationContext) {
        if (this.findData == null) {
            throw new IllegalStateException("Expected find query!");
        }
        return this.findData.getFind(invocationContext);
    }

    @Override
    public MongoUpdate getUpdateMany(InvocationContext<?, ?> invocationContext) {
        if (this.updateData == null) {
            throw new IllegalStateException("Expected update query!");
        }
        return this.updateData.getUpdateMany(invocationContext);
    }

    @Override
    public MongoUpdate getUpdateOne(E entity) {
        if (this.updateData == null) {
            throw new IllegalStateException("Expected update query!");
        }
        return this.updateData.getUpdateOne(entity);
    }

    @Override
    public MongoDelete getDeleteMany(InvocationContext<?, ?> invocationContext) {
        if (this.deleteData == null) {
            throw new IllegalStateException("Expected delete query!");
        }
        return this.deleteData.getDeleteMany(invocationContext);
    }

    @Override
    public MongoDelete getDeleteOne(E entity) {
        if (this.deleteData == null) {
            throw new IllegalStateException("Expected delete query!");
        }
        return this.deleteData.getDeleteOne(entity);
    }

    private boolean needsProcessing(Bson value) {
        if (value == null) {
            return false;
        }
        if (value instanceof BsonDocument) {
            return this.needsProcessingValue((BsonValue)value.toBsonDocument());
        }
        throw new IllegalStateException("Unrecognized value: " + String.valueOf(value));
    }

    private boolean needsProcessing(List<Bson> values) {
        if (values == null) {
            return false;
        }
        for (Bson value : values) {
            if (!this.needsProcessing(value)) continue;
            return true;
        }
        return false;
    }

    private boolean needsProcessingValue(BsonValue value) {
        if (value instanceof BsonDocument) {
            BsonDocument bsonDocument = (BsonDocument)value;
            BsonInt32 queryParameterIndex = bsonDocument.getInt32((Object)"$mn_qp", null);
            if (queryParameterIndex != null) {
                return true;
            }
            for (Map.Entry entry : bsonDocument.entrySet()) {
                BsonValue bsonValue = (BsonValue)entry.getValue();
                if (!this.needsProcessingValue(bsonValue)) continue;
                return true;
            }
            return false;
        }
        if (value instanceof BsonArray) {
            BsonArray bsonArray = (BsonArray)value;
            for (BsonValue bsonValue : bsonArray) {
                if (!this.needsProcessingValue(bsonValue)) continue;
                return true;
            }
        }
        if (value instanceof BsonRegularExpression) {
            BsonRegularExpression bsonRegularExpression = (BsonRegularExpression)value;
            String pattern = bsonRegularExpression.getPattern();
            return MONGO_PARAM_PATTERN.matcher(pattern).matches();
        }
        return false;
    }

    private Bson replaceQueryParameters(Bson value, @Nullable InvocationContext<?, ?> invocationContext, @Nullable E entity) {
        if (value instanceof BsonDocument) {
            BsonDocument bsonDocument = (BsonDocument)value;
            return (BsonDocument)this.replaceQueryParametersInBsonValue((BsonValue)bsonDocument.clone(), invocationContext, entity);
        }
        throw new IllegalStateException("Unrecognized value: " + String.valueOf(value));
    }

    private List<Bson> replaceQueryParametersInList(List<Bson> values, @Nullable InvocationContext<?, ?> invocationContext, @Nullable E entity) {
        values = new ArrayList<Bson>(values);
        for (int i = 0; i < values.size(); ++i) {
            Bson newValue;
            Bson value = values.get(i);
            if (value == (newValue = this.replaceQueryParameters(value, invocationContext, entity))) continue;
            values.set(i, newValue);
        }
        return values;
    }

    private Map.Entry<QueryParameterBinding, Object> bind(QueryParameterBinding queryParameterBinding, @Nullable InvocationContext<?, ?> invocationContext, @Nullable E entity) {
        final Object[] holder = new Object[1];
        this.bindParameter(new BindableParametersStoredQuery.Binder(){

            public Object autoPopulateRuntimeProperty(RuntimePersistentProperty<?> persistentProperty, Object previousValue) {
                return DefaultMongoStoredQuery.this.runtimeEntityRegistry.autoPopulateRuntimeProperty(persistentProperty, previousValue);
            }

            public Object convert(Object value, RuntimePersistentProperty<?> property) {
                AttributeConverter converter = property.getConverter();
                if (converter != null) {
                    return converter.convertToPersistedValue(value, this.createTypeConversionContext(property, property.getArgument()));
                }
                return value;
            }

            public Object convert(Class<?> converterClass, Object value, Argument<?> argument) {
                if (converterClass == null) {
                    return value;
                }
                AttributeConverter converter = DefaultMongoStoredQuery.this.attributeConverterRegistry.getConverter(converterClass);
                ConversionContext conversionContext = this.createTypeConversionContext(null, argument);
                return converter.convertToPersistedValue(value, conversionContext);
            }

            private ConversionContext createTypeConversionContext(RuntimePersistentProperty<?> property, Argument<?> argument) {
                if (argument != null) {
                    return ConversionContext.of(argument);
                }
                if (property != null) {
                    return ConversionContext.of((Argument)property.getArgument());
                }
                return ConversionContext.DEFAULT;
            }

            public void bindOne(QueryParameterBinding binding, Object value) {
                holder[0] = new AbstractMap.SimpleEntry<QueryParameterBinding, Object>(binding, value);
            }

            public void bindMany(QueryParameterBinding binding, Collection<Object> values) {
                this.bindOne(binding, values);
            }
        }, invocationContext, entity, null, queryParameterBinding);
        return (Map.Entry)holder[0];
    }

    private BsonValue replaceQueryParametersInBsonValue(BsonValue value, @Nullable InvocationContext<?, ?> invocationContext, @Nullable E entity) {
        BsonRegularExpression bsonRegularExpression;
        String pattern;
        Matcher matcher;
        if (value instanceof BsonDocument) {
            BsonDocument bsonDocument = (BsonDocument)value;
            BsonInt32 queryParameterIndex = bsonDocument.getInt32((Object)"$mn_qp", null);
            if (queryParameterIndex != null) {
                int index = queryParameterIndex.getValue();
                QueryParameterBinding queryParameterBinding = (QueryParameterBinding)this.getQueryBindings().get(index);
                Map.Entry<QueryParameterBinding, Object> e = this.bind(queryParameterBinding, invocationContext, entity);
                if (e == null) {
                    throw new DataAccessException("Cannot bind a value at index: " + index);
                }
                return this.getValue(e.getKey(), e.getValue());
            }
            for (Map.Entry entry : bsonDocument.entrySet()) {
                BsonValue newValue;
                BsonValue bsonValue = (BsonValue)entry.getValue();
                if (bsonValue == (newValue = this.replaceQueryParametersInBsonValue(bsonValue, invocationContext, entity))) continue;
                entry.setValue(newValue);
            }
            return bsonDocument;
        }
        if (value instanceof BsonArray) {
            BsonArray bsonArray = (BsonArray)value;
            for (int i = 0; i < bsonArray.size(); ++i) {
                BsonValue newValue;
                BsonValue bsonValue = bsonArray.get(i);
                if (bsonValue == (newValue = this.replaceQueryParametersInBsonValue(bsonValue, invocationContext, entity))) continue;
                if (newValue.isNull()) {
                    bsonArray.remove(i);
                    --i;
                    continue;
                }
                if (newValue.isArray()) {
                    bsonArray.remove(i);
                    List values = newValue.asArray().getValues();
                    bsonArray.addAll(i, (Collection)values);
                    i += values.size() - 1;
                    continue;
                }
                bsonArray.set(i, newValue);
            }
        } else if (value instanceof BsonRegularExpression && (matcher = MONGO_PARAM_PATTERN.matcher(pattern = (bsonRegularExpression = (BsonRegularExpression)value).getPattern())).matches()) {
            Integer queryParamIndex = null;
            try {
                String queryParamIndexStr = matcher.group(2);
                queryParamIndex = Integer.parseInt(queryParamIndexStr);
            }
            catch (Exception e) {
                LOG.info("Failed to get mongo parameter for regex {}", (Throwable)e);
            }
            if (queryParamIndex != null) {
                QueryParameterBinding queryParameterBinding = (QueryParameterBinding)this.getQueryBindings().get(queryParamIndex);
                Map.Entry<QueryParameterBinding, Object> e = this.bind(queryParameterBinding, invocationContext, entity);
                if (e == null) {
                    throw new DataAccessException("Cannot bind a value at index: " + queryParamIndex);
                }
                pattern = pattern.replace(matcher.group(1), e.getValue().toString());
                return new BsonRegularExpression(pattern, bsonRegularExpression.getOptions());
            }
        }
        return value;
    }

    private BsonValue getValue(QueryParameterBinding queryParameterBinding, Object value) {
        boolean isIdentity = false;
        if (queryParameterBinding.getPropertyPath() != null) {
            PersistentPropertyPath pp = this.getRequiredPropertyPath(queryParameterBinding, this.persistentEntity);
            RuntimePersistentProperty persistentProperty = (RuntimePersistentProperty)pp.getProperty();
            if (persistentProperty instanceof RuntimeAssociation) {
                RuntimeAssociation runtimeAssociation = (RuntimeAssociation)persistentProperty;
                RuntimePersistentProperty identity = runtimeAssociation.getAssociatedEntity().getIdentity();
                isIdentity = identity != null && identity.getType() == String.class && identity.isGenerated();
            } else {
                boolean bl = isIdentity = persistentProperty.getOwner().getIdentity() == persistentProperty && persistentProperty.getType() == String.class && persistentProperty.isGenerated();
            }
        }
        if (isIdentity && value instanceof String) {
            return new BsonObjectId(new ObjectId((String)((Object)value)));
        }
        if (value instanceof Object[]) {
            Object[] objects = (Object[])value;
            List<Object> valueList = Arrays.asList(objects);
            if (isIdentity) {
                ListIterator<Object> iterator = valueList.listIterator();
                while (iterator.hasNext()) {
                    Object item = iterator.next();
                    if (item instanceof String) {
                        String string = (String)item;
                        item = new BsonObjectId(new ObjectId(string));
                    }
                    iterator.set(item);
                }
            }
            value = valueList;
        }
        if (value instanceof Collection) {
            Collection values = value;
            boolean isIdentityField = isIdentity;
            return new BsonArray(values.stream().map(val -> {
                if (isIdentityField && val instanceof String) {
                    String string = (String)val;
                    return new BsonObjectId(new ObjectId(string));
                }
                return MongoUtils.toBsonValue(this.conversionService, val, this.codecRegistry.get());
            }).toList());
        }
        return MongoUtils.toBsonValue(this.conversionService, value, this.codecRegistry.get());
    }

    public StoredQuery<E, R> getStoredQueryDelegate() {
        return this.storedQuery;
    }

    private final class AggregateData
    extends CollationSupported {
        private final List<Bson> pipeline;
        private final boolean pipelineNeedsProcessing;
        @Nullable
        private final MongoAggregationOptions options;
        private final int pipelineParameterIndex;
        private final int optionsParameterIndex;

        private AggregateData(List<Bson> pipeline) {
            this(pipeline, null, null);
        }

        private AggregateData(String pipelineParameter, String optionsParameter) {
            this(null, pipelineParameter, optionsParameter);
        }

        private AggregateData(List<Bson> pipeline, String pipelineParameter, String optionsParameter) {
            this.pipeline = pipeline;
            this.pipelineParameterIndex = DefaultMongoStoredQuery.this.getParameterIndexByName(pipelineParameter);
            this.optionsParameterIndex = DefaultMongoStoredQuery.this.getParameterIndexByName(optionsParameter);
            this.pipelineNeedsProcessing = DefaultMongoStoredQuery.this.needsProcessing(pipeline);
            this.options = MongoOptionsUtils.buildAggregateOptions(DefaultMongoStoredQuery.this.storedQuery.getAnnotationMetadata()).orElse(null);
        }

        public MongoAggregation getAggregation(InvocationContext<?, ?> invocationContext) {
            List<Bson> pipeline = this.getPipeline(invocationContext);
            MongoAggregationOptions options = this.getOptions(invocationContext);
            Collation collation = this.getCollation(invocationContext, null);
            if (collation != null) {
                if (options == null) {
                    options = new MongoAggregationOptions();
                }
                options.collation(collation);
            }
            return new MongoAggregation(pipeline, options);
        }

        private List<Bson> getPipeline(InvocationContext<?, ?> invocationContext) {
            if (this.pipelineParameterIndex != -1) {
                return (List)DefaultMongoStoredQuery.this.getParameterAtIndex(invocationContext, this.pipelineParameterIndex);
            }
            if (this.pipelineNeedsProcessing) {
                return DefaultMongoStoredQuery.this.replaceQueryParametersInList(this.pipeline, invocationContext, null);
            }
            return this.pipeline;
        }

        @Nullable
        private MongoAggregationOptions getOptions(InvocationContext<?, ?> invocationContext) {
            if (this.optionsParameterIndex != -1) {
                MongoAggregationOptions paramOptions = (MongoAggregationOptions)DefaultMongoStoredQuery.this.getParameterAtIndex(invocationContext, this.optionsParameterIndex);
                if (this.options == null) {
                    return paramOptions;
                }
                if (paramOptions != null) {
                    MongoAggregationOptions options = new MongoAggregationOptions(this.options);
                    options.copyNotNullFrom(paramOptions);
                    return options;
                }
            }
            return this.options;
        }
    }

    private final class FindData
    extends CollationSupported {
        private final Bson filter;
        private final boolean filterNeedsProcessing;
        private final Bson sort;
        private final boolean sortNeedsProcessing;
        private final Bson projection;
        private final boolean projectionNeedsProcessing;
        @Nullable
        private final MongoFindOptions options;
        private final int filterParameterIndex;
        private final int optionsParameterIndex;

        private FindData(Bson filter) {
            this(filter, null, null);
        }

        private FindData(String filterParameter, String optionsParameter) {
            this(null, filterParameter, optionsParameter);
        }

        private FindData(Bson filter, String filterParameter, String optionsParameter) {
            this.filterParameterIndex = DefaultMongoStoredQuery.this.getParameterIndexByName(filterParameter);
            this.optionsParameterIndex = DefaultMongoStoredQuery.this.getParameterIndexByName(optionsParameter);
            this.sort = DefaultMongoStoredQuery.this.storedQuery.getAnnotationMetadata().stringValue(MongoSort.class).map(BsonDocument::parse).orElse(null);
            this.sortNeedsProcessing = DefaultMongoStoredQuery.this.needsProcessing(this.sort);
            this.projection = DefaultMongoStoredQuery.this.storedQuery.getAnnotationMetadata().stringValue(MongoProjection.class).map(BsonDocument::parse).orElse(null);
            this.projectionNeedsProcessing = DefaultMongoStoredQuery.this.needsProcessing(this.projection);
            this.filter = filter;
            this.filterNeedsProcessing = DefaultMongoStoredQuery.this.needsProcessing(filter);
            this.options = MongoOptionsUtils.buildFindOptions(DefaultMongoStoredQuery.this.storedQuery.getAnnotationMetadata()).orElse(null);
        }

        public MongoFind getFind(InvocationContext<?, ?> invocationContext) {
            Bson projection;
            Bson sort;
            Collation collation;
            MongoFindOptions options = this.getFilterOptions(invocationContext);
            Bson filter = this.getFilter(invocationContext, null);
            if (filter != null) {
                options.filter(filter);
            }
            if ((collation = this.getCollation(invocationContext, null)) != null) {
                options.collation(collation);
            }
            if ((sort = this.getSort(invocationContext, null)) != null) {
                options.sort(sort);
            }
            if ((projection = this.getProjection(invocationContext, null)) != null) {
                options.projection(projection);
            }
            return new MongoFind(options.isEmpty() ? null : options);
        }

        @NonNull
        private MongoFindOptions getFilterOptions(@Nullable InvocationContext<?, ?> invocationContext) {
            MongoFindOptions paramOptions;
            if (this.optionsParameterIndex != -1 && (paramOptions = (MongoFindOptions)DefaultMongoStoredQuery.this.getParameterAtIndex(invocationContext, this.optionsParameterIndex)) != null) {
                if (this.options == null) {
                    return paramOptions;
                }
                MongoFindOptions options = new MongoFindOptions(this.options);
                options.copyNotNullFrom(paramOptions);
                return options;
            }
            if (this.options != null) {
                return new MongoFindOptions(this.options);
            }
            return new MongoFindOptions();
        }

        private Bson getFilter(@Nullable InvocationContext<?, ?> invocationContext, E entity) {
            if (this.filterParameterIndex != -1) {
                return (Bson)DefaultMongoStoredQuery.this.getParameterAtIndex(invocationContext, this.filterParameterIndex);
            }
            if (this.filter == null) {
                return null;
            }
            return this.filterNeedsProcessing ? DefaultMongoStoredQuery.this.replaceQueryParameters(this.filter, invocationContext, entity) : this.filter;
        }

        private Bson getSort(@Nullable InvocationContext<?, ?> invocationContext, @Nullable E entity) {
            if (this.sort == null) {
                return null;
            }
            return this.sortNeedsProcessing ? DefaultMongoStoredQuery.this.replaceQueryParameters(this.sort, invocationContext, entity) : this.sort;
        }

        private Bson getProjection(@Nullable InvocationContext<?, ?> invocationContext, @Nullable E entity) {
            if (this.projection == null) {
                return null;
            }
            return this.projectionNeedsProcessing ? DefaultMongoStoredQuery.this.replaceQueryParameters(this.projection, invocationContext, entity) : this.projection;
        }
    }

    private final class DeleteData
    extends CollationSupported {
        private final Bson filter;
        private final boolean filterNeedsProcessing;
        @Nullable
        private final DeleteOptions options;
        private final int filterParameterIndex;
        private final int optionsParameterIndex;

        private DeleteData(Bson filter, String filterParameter, String optionsParameter) {
            this.filter = filter;
            this.filterNeedsProcessing = DefaultMongoStoredQuery.this.needsProcessing(filter);
            this.filterParameterIndex = DefaultMongoStoredQuery.this.getParameterIndexByName(filterParameter);
            this.optionsParameterIndex = DefaultMongoStoredQuery.this.getParameterIndexByName(optionsParameter);
            this.options = MongoOptionsUtils.buildDeleteOptions(DefaultMongoStoredQuery.this.storedQuery.getAnnotationMetadata(), false).orElse(null);
        }

        public MongoDelete getDeleteMany(InvocationContext<?, ?> invocationContext) {
            DeleteOptions options = this.getOptions(invocationContext);
            return new MongoDelete(this.getFilter(invocationContext, null), options);
        }

        public MongoDelete getDeleteOne(E entity) {
            DeleteOptions options = this.getOptions(null);
            return new MongoDelete(this.getFilter(null, entity), options);
        }

        @NonNull
        private DeleteOptions getOptions(InvocationContext<?, ?> invocationContext) {
            Collation collation;
            DeleteOptions paramOptions;
            DeleteOptions options = this.options;
            if (this.optionsParameterIndex != -1 && (paramOptions = (DeleteOptions)DefaultMongoStoredQuery.this.getParameterAtIndex(invocationContext, this.optionsParameterIndex)) != null) {
                if (options == null) {
                    options = paramOptions;
                } else {
                    options = this.copy(options);
                    this.copyNonNullFrom(options, paramOptions);
                }
            }
            if (options == null) {
                options = new DeleteOptions();
            }
            if ((collation = this.getCollation(invocationContext, null)) != null) {
                if (this.options == options) {
                    options = this.copy(options);
                }
                options.collation(collation);
            }
            return options;
        }

        private DeleteOptions copy(DeleteOptions options) {
            DeleteOptions newOptions = new DeleteOptions();
            newOptions.collation(options.getCollation());
            newOptions.hint(options.getHint());
            newOptions.hintString(options.getHintString());
            return newOptions;
        }

        private void copyNonNullFrom(DeleteOptions to, DeleteOptions from) {
            if (from.getCollation() != null) {
                to.collation(from.getCollation());
            }
            if (from.getHint() != null) {
                to.hint(from.getHint());
            }
            if (from.getHintString() != null) {
                to.hintString(from.getHintString());
            }
        }

        private Bson getFilter(@Nullable InvocationContext<?, ?> invocationContext, E entity) {
            if (this.filterParameterIndex != -1) {
                return (Bson)DefaultMongoStoredQuery.this.getParameterAtIndex(invocationContext, this.filterParameterIndex);
            }
            return this.filterNeedsProcessing ? DefaultMongoStoredQuery.this.replaceQueryParameters(this.filter, invocationContext, entity) : this.filter;
        }
    }

    private final class UpdateData
    extends CollationSupported {
        private final Bson update;
        private final boolean updateNeedsProcessing;
        private final Bson filter;
        private final boolean filterNeedsProcessing;
        @Nullable
        private final UpdateOptions options;
        private final int filterParameterIndex;
        private final int updateParameterIndex;
        private final int optionsParameterIndex;

        private UpdateData(Bson update, Bson filter, String filterParameter, String updateParameter, String optionsParameter) {
            this.update = update;
            this.updateNeedsProcessing = DefaultMongoStoredQuery.this.needsProcessing(update);
            this.filter = filter;
            this.filterNeedsProcessing = DefaultMongoStoredQuery.this.needsProcessing(filter);
            this.filterParameterIndex = DefaultMongoStoredQuery.this.getParameterIndexByName(filterParameter);
            this.updateParameterIndex = DefaultMongoStoredQuery.this.getParameterIndexByName(updateParameter);
            this.optionsParameterIndex = DefaultMongoStoredQuery.this.getParameterIndexByName(optionsParameter);
            this.options = MongoOptionsUtils.buildUpdateOptions(DefaultMongoStoredQuery.this.storedQuery.getAnnotationMetadata(), false).orElse(null);
        }

        private UpdateOptions copy(UpdateOptions options) {
            UpdateOptions newOptions = new UpdateOptions();
            newOptions.collation(options.getCollation());
            newOptions.upsert(options.isUpsert());
            newOptions.bypassDocumentValidation(options.getBypassDocumentValidation());
            newOptions.hint(options.getHint());
            newOptions.hintString(options.getHintString());
            newOptions.arrayFilters(options.getArrayFilters());
            return newOptions;
        }

        private void copyNonNullFrom(UpdateOptions to, UpdateOptions from) {
            if (from.getCollation() != null) {
                to.collation(from.getCollation());
            }
            if (from.isUpsert()) {
                to.upsert(from.isUpsert());
            }
            if (from.getBypassDocumentValidation() != null) {
                to.bypassDocumentValidation(from.getBypassDocumentValidation());
            }
            if (from.getHint() != null) {
                to.hint(from.getHint());
            }
            if (from.getHintString() != null) {
                to.hintString(from.getHintString());
            }
            if (from.getArrayFilters() != null) {
                to.arrayFilters(from.getArrayFilters());
            }
        }

        public MongoUpdate getUpdateMany(InvocationContext<?, ?> invocationContext) {
            return new MongoUpdate(this.getUpdate(invocationContext, null), this.getFilter(invocationContext, null), this.getOptions(invocationContext));
        }

        public MongoUpdate getUpdateOne(E entity) {
            if (DefaultMongoStoredQuery.this.updateData == null) {
                throw new IllegalStateException("Expected update query!");
            }
            Bson update = this.getUpdate(null, entity);
            UpdateOptions options = this.getOptions(null);
            return new MongoUpdate(update, this.getFilter(null, entity), options);
        }

        private Bson getUpdate(InvocationContext<?, ?> invocationContext, E entity) {
            Bson update = this.update;
            if (this.updateParameterIndex != -1) {
                update = (Bson)DefaultMongoStoredQuery.this.getParameterAtIndex(invocationContext, this.updateParameterIndex);
            }
            if (update == null) {
                throw new IllegalStateException("Update query is not provided!");
            }
            Bson bson = update = this.updateNeedsProcessing ? DefaultMongoStoredQuery.this.replaceQueryParameters(update, invocationContext, entity) : update;
            if (update == null) {
                throw new IllegalStateException("Update query is not provided!");
            }
            return update;
        }

        @NonNull
        private UpdateOptions getOptions(InvocationContext<?, ?> invocationContext) {
            Collation collation;
            UpdateOptions paramOptions;
            UpdateOptions options = this.options;
            if (this.optionsParameterIndex != -1 && (paramOptions = (UpdateOptions)DefaultMongoStoredQuery.this.getParameterAtIndex(invocationContext, this.optionsParameterIndex)) != null) {
                if (options == null) {
                    options = paramOptions;
                } else {
                    options = this.copy(this.options);
                    this.copyNonNullFrom(options, paramOptions);
                }
            }
            if (options == null) {
                options = new UpdateOptions();
            }
            if ((collation = this.getCollation(invocationContext, null)) != null) {
                if (options == this.options) {
                    options = this.copy(options);
                }
                options.collation(collation);
            }
            return options;
        }

        private Bson getFilter(@Nullable InvocationContext<?, ?> invocationContext, E entity) {
            if (this.filterParameterIndex != -1) {
                return (Bson)DefaultMongoStoredQuery.this.getParameterAtIndex(invocationContext, this.filterParameterIndex);
            }
            return this.filterNeedsProcessing ? DefaultMongoStoredQuery.this.replaceQueryParameters(this.filter, invocationContext, entity) : this.filter;
        }
    }

    private abstract class CollationSupported {
        private final Bson collationAsBson;
        private final boolean collationNeedsProcessing;
        private final Collation collation;

        protected CollationSupported() {
            this.collationAsBson = DefaultMongoStoredQuery.this.storedQuery.getAnnotationMetadata().stringValue(MongoCollation.class).map(BsonDocument::parse).orElse(null);
            this.collationNeedsProcessing = DefaultMongoStoredQuery.this.needsProcessing(this.collationAsBson);
            this.collation = this.collationAsBson == null || this.collationNeedsProcessing ? null : MongoOptionsUtils.bsonDocumentAsCollation(this.collationAsBson.toBsonDocument());
        }

        protected Collation getCollation(@Nullable InvocationContext<?, ?> invocationContext, @Nullable E entity) {
            if (this.collation != null) {
                return this.collation;
            }
            if (this.collationAsBson == null) {
                return null;
            }
            Bson collationAsBson = this.collationNeedsProcessing ? DefaultMongoStoredQuery.this.replaceQueryParameters(this.collationAsBson, invocationContext, entity) : this.collationAsBson;
            return MongoOptionsUtils.bsonDocumentAsCollation(collationAsBson.toBsonDocument());
        }
    }
}

