/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.serde;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.GeneratedValue;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.document.serde.CustomConverterDeserializer;
import io.micronaut.data.document.serde.IdDeserializer;
import io.micronaut.data.document.serde.IdPropertyNamingStrategy;
import io.micronaut.data.document.serde.OneRelationDeserializer;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.convert.AttributeConverter;
import io.micronaut.data.mongodb.conf.MongoDataConfiguration;
import io.micronaut.data.mongodb.serde.DataSerdeRegistry;
import io.micronaut.data.mongodb.serde.MappedCodec;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.bson.BsonReaderDecoder;
import io.micronaut.serde.bson.custom.CodecBsonDecoder;
import io.micronaut.serde.config.naming.PropertyNamingStrategy;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.reference.PropertyReference;
import java.io.IOException;
import java.util.Collection;
import org.bson.BsonDocument;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.IterableCodec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.types.ObjectId;

@Internal
final class DataDecoderContext
implements Deserializer.DecoderContext {
    private final Argument<ObjectId> OBJECT_ID = Argument.of(ObjectId.class);
    private MongoDataConfiguration mongoDataConfiguration;
    private final AttributeConverterRegistry attributeConverterRegistry;
    private final Argument argument;
    private final RuntimePersistentEntity<Object> runtimePersistentEntity;
    private final Deserializer.DecoderContext parent;
    private final CodecRegistry codecRegistry;

    DataDecoderContext(MongoDataConfiguration mongoDataConfiguration, AttributeConverterRegistry attributeConverterRegistry, Argument argument, RuntimePersistentEntity<Object> runtimePersistentEntity, Deserializer.DecoderContext parent, CodecRegistry codecRegistry) {
        this.mongoDataConfiguration = mongoDataConfiguration;
        this.attributeConverterRegistry = attributeConverterRegistry;
        this.argument = argument;
        this.runtimePersistentEntity = runtimePersistentEntity;
        this.parent = parent;
        this.codecRegistry = codecRegistry;
    }

    public <B, P> PropertyReference<B, P> resolveReference(PropertyReference<B, P> reference) {
        return this.parent.resolveReference(reference);
    }

    public <T, D extends Deserializer<? extends T>> D findCustomDeserializer(Class<? extends D> deserializerClass) throws SerdeException {
        if (deserializerClass == OneRelationDeserializer.class) {
            OneRelationDeserializer oneRelationDeserializer = new OneRelationDeserializer(){

                public Deserializer<Object> createSpecific(Deserializer.DecoderContext decoderContext, Argument<? super Object> type) throws SerdeException {
                    final Deserializer<? super Object> relationDeser = DataDecoderContext.this.findDeserializer(type);
                    return new Deserializer<Object>(){

                        public Object deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> type) throws IOException {
                            if (decoder.decodeNull()) {
                                return null;
                            }
                            CodecBsonDecoder codecBsonDecoder = new CodecBsonDecoder((Codec)new BsonDocumentCodec(DataDecoderContext.this.codecRegistry));
                            BsonDocument document = (BsonDocument)codecBsonDecoder.deserialize(decoder, decoderContext, type);
                            if (document == null || document.size() <= 1) {
                                return null;
                            }
                            return relationDeser.deserialize((Decoder)new BsonReaderDecoder(document.asBsonReader()), decoderContext, type);
                        }
                    };
                }

                public Object deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> type) throws IOException {
                    throw new IllegalStateException("Create specific call is required!");
                }
            };
            return (D)oneRelationDeserializer;
        }
        if (deserializerClass == IdDeserializer.class) {
            IdDeserializer idDeserializer = new IdDeserializer(){

                public Deserializer<Object> createSpecific(Deserializer.DecoderContext decoderContext, Argument<? super Object> type) throws SerdeException {
                    if (type.getType().isAssignableFrom(String.class) && type.isAnnotationPresent(GeneratedValue.class)) {
                        Deserializer deserializer = DataDecoderContext.this.findDeserializer(DataDecoderContext.this.OBJECT_ID);
                        return (decoder, decoderContext2, objectIdType) -> {
                            ObjectId objectId = (ObjectId)deserializer.deserialize(decoder, decoderContext2, DataDecoderContext.this.OBJECT_ID);
                            return objectId == null ? null : objectId.toHexString();
                        };
                    }
                    Deserializer<? super Object> deserializer = DataDecoderContext.this.findDeserializer(type);
                    return deserializer.createSpecific(decoderContext, type);
                }

                public Object deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> type) throws IOException {
                    throw new IllegalStateException("Create specific call is required!");
                }
            };
            return (D)idDeserializer;
        }
        if (deserializerClass == CustomConverterDeserializer.class) {
            CustomConverterDeserializer customConverterDeserializer = new CustomConverterDeserializer(){

                public Deserializer<Object> createSpecific(Deserializer.DecoderContext decoderContext, Argument<? super Object> type) throws SerdeException {
                    Class converterClass = (Class)type.getAnnotationMetadata().classValue(MappedProperty.class, "converter").orElseThrow(IllegalStateException::new);
                    Class converterPersistedType = (Class)type.getAnnotationMetadata().classValue(MappedProperty.class, "converterPersistedType").orElseThrow(IllegalStateException::new);
                    final Argument convertedType = Argument.of((Class)converterPersistedType);
                    final AttributeConverter converter = DataDecoderContext.this.attributeConverterRegistry.getConverter(converterClass);
                    final Deserializer deserializer = DataDecoderContext.this.findDeserializer(convertedType);
                    return new Deserializer<Object>(){

                        public Object deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> type) throws IOException {
                            if (decoder.decodeNull()) {
                                return null;
                            }
                            Object deserialized = deserializer.deserialize(decoder, decoderContext, convertedType);
                            return converter.convertToEntityValue(deserialized, (ConversionContext)ConversionContext.of((Argument)convertedType));
                        }
                    };
                }

                public Object deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> type) throws IOException {
                    throw new IllegalStateException("Create specific call is required!");
                }
            };
            return (D)customConverterDeserializer;
        }
        return (D)this.parent.findCustomDeserializer(deserializerClass);
    }

    public <T> Deserializer<? extends T> findDeserializer(Argument<? extends T> type) throws SerdeException {
        Codec codec = this.codecRegistry.get(type.getType(), this.codecRegistry);
        if (codec instanceof MappedCodec) {
            return ((MappedCodec)codec).deserializer;
        }
        if (codec != null && !(codec instanceof IterableCodec)) {
            return new CodecBsonDecoder(codec);
        }
        return this.parent.findDeserializer(type);
    }

    public <D extends PropertyNamingStrategy> D findNamingStrategy(Class<? extends D> namingStrategyClass) throws SerdeException {
        if (namingStrategyClass == IdPropertyNamingStrategy.class) {
            return (D)DataSerdeRegistry.ID_PROPERTY_NAMING_STRATEGY;
        }
        return (D)this.parent.findNamingStrategy(namingStrategyClass);
    }

    public <T> Collection<BeanIntrospection<? extends T>> getDeserializableSubtypes(Class<T> superType) {
        return this.parent.getDeserializableSubtypes(superType);
    }

    public <B, P> void pushManagedRef(PropertyReference<B, P> reference) {
        this.parent.pushManagedRef(reference);
    }

    public void popManagedRef() {
        this.parent.popManagedRef();
    }

    public boolean hasView(Class<?> ... views) {
        return this.mongoDataConfiguration.isIgnoreJsonViews() || this.parent.hasView((Class[])views);
    }
}

