/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.database;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.mongodb.conf.RequiresReactiveMongo;
import io.micronaut.data.mongodb.operations.DefaultReactiveMongoRepositoryOperations;
import io.micronaut.data.mongodb.operations.MongoRepositoryOperations;
import io.micronaut.data.operations.HintsCapableRepository;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.reactive.BlockingReactorRepositoryOperations;
import io.micronaut.data.operations.reactive.ReactorReactiveRepositoryOperations;
import io.micronaut.data.runtime.operations.ExecutorAsyncOperations;
import io.micronaut.data.runtime.query.MethodContextAwareStoredQueryDecorator;
import io.micronaut.data.runtime.query.PreparedQueryDecorator;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@RequiresReactiveMongo
@Internal
@Factory
final class MongoReactiveFactory {
    MongoReactiveFactory() {
    }

    @EachBean(value=DefaultReactiveMongoRepositoryOperations.class)
    @Singleton
    MongoRepositoryOperations syncOperations(DefaultReactiveMongoRepositoryOperations reactiveOperations) {
        return new MongoReactiveBlockingRepositoryOperations(reactiveOperations);
    }

    private static final class MongoReactiveBlockingRepositoryOperations
    implements MongoRepositoryOperations,
    BlockingReactorRepositoryOperations,
    AsyncCapableRepository,
    HintsCapableRepository,
    MethodContextAwareStoredQueryDecorator,
    PreparedQueryDecorator {
        private final DefaultReactiveMongoRepositoryOperations reactiveOperations;
        private ExecutorService executorService;
        private ExecutorAsyncOperations asyncOperations;

        private MongoReactiveBlockingRepositoryOperations(DefaultReactiveMongoRepositoryOperations reactiveOperations) {
            this.reactiveOperations = reactiveOperations;
        }

        public ConversionService<?> getConversionService() {
            return this.reactiveOperations.getConversionService();
        }

        public Map<String, Object> getQueryHints(StoredQuery<?, ?> storedQuery) {
            return this.reactiveOperations.getQueryHints(storedQuery);
        }

        public ReactorReactiveRepositoryOperations reactive() {
            return this.reactiveOperations;
        }

        public ApplicationContext getApplicationContext() {
            return this.reactiveOperations.getApplicationContext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public ExecutorAsyncOperations async() {
            ExecutorAsyncOperations asyncOperations = this.asyncOperations;
            if (asyncOperations == null) {
                MongoReactiveBlockingRepositoryOperations mongoReactiveBlockingRepositoryOperations = this;
                synchronized (mongoReactiveBlockingRepositoryOperations) {
                    asyncOperations = this.asyncOperations;
                    if (asyncOperations == null) {
                        if (this.executorService == null) {
                            this.executorService = Executors.newCachedThreadPool();
                        }
                        this.asyncOperations = asyncOperations = new ExecutorAsyncOperations((RepositoryOperations)this, (Executor)this.executorService);
                    }
                }
            }
            return asyncOperations;
        }

        public <E, R> StoredQuery<E, R> decorate(MethodInvocationContext<?, ?> context, StoredQuery<E, R> storedQuery) {
            return this.reactiveOperations.decorate((MethodInvocationContext)context, (StoredQuery)storedQuery);
        }

        public <E, R> PreparedQuery<E, R> decorate(PreparedQuery<E, R> preparedQuery) {
            return this.reactiveOperations.decorate((PreparedQuery)preparedQuery);
        }
    }
}

