/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.transaction;

import io.micronaut.configuration.mongo.core.NamedMongoConfiguration;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.mongodb.conf.RequiresSyncMongo;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.async.AsyncUsingSyncTransactionOperations;
import io.micronaut.transaction.interceptor.CoroutineTxHelper;
import jakarta.inject.Singleton;

@RequiresSyncMongo
@Factory
final class SynchronousMongoTransactionManagerFactory {
    SynchronousMongoTransactionManagerFactory() {
    }

    @Requires(missingProperty="mongodb.servers")
    @Primary
    @Singleton
    <T> AsyncUsingSyncTransactionOperations<T> buildPrimaryAsyncTransactionOperations(SynchronousTransactionManager<T> synchronousTransactionManager, @Nullable CoroutineTxHelper coroutineTxHelper) {
        return new AsyncUsingSyncTransactionOperations(synchronousTransactionManager, coroutineTxHelper);
    }

    @EachBean(value=NamedMongoConfiguration.class)
    <T> AsyncUsingSyncTransactionOperations<T> buildAsyncTransactionOperations(@Parameter SynchronousTransactionManager<T> synchronousTransactionManager, @Nullable CoroutineTxHelper coroutineTxHelper) {
        return new AsyncUsingSyncTransactionOperations(synchronousTransactionManager, coroutineTxHelper);
    }
}

