/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.serde;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.GeneratedValue;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.document.serde.CustomConverterSerializer;
import io.micronaut.data.document.serde.IdPropertyNamingStrategy;
import io.micronaut.data.document.serde.IdSerializer;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.convert.AttributeConverter;
import io.micronaut.data.mongodb.serde.DataSerdeRegistry;
import io.micronaut.data.mongodb.serde.MappedCodec;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.bson.custom.CodecBsonDecoder;
import io.micronaut.serde.config.naming.PropertyNamingStrategy;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.reference.PropertyReference;
import io.micronaut.serde.reference.SerializationReference;
import java.io.IOException;
import org.bson.codecs.Codec;
import org.bson.codecs.IterableCodec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.types.ObjectId;

@Internal
final class DataEncoderContext
implements Serializer.EncoderContext {
    private final Argument<ObjectId> OBJECT_ID = Argument.of(ObjectId.class);
    private final AttributeConverterRegistry attributeConverterRegistry;
    private final Argument argument;
    private final RuntimePersistentEntity<Object> runtimePersistentEntity;
    private final Serializer.EncoderContext parent;
    private final CodecRegistry codecRegistry;

    DataEncoderContext(AttributeConverterRegistry attributeConverterRegistry, Argument argument, RuntimePersistentEntity<Object> runtimePersistentEntity, Serializer.EncoderContext parent, CodecRegistry codecRegistry) {
        this.attributeConverterRegistry = attributeConverterRegistry;
        this.argument = argument;
        this.runtimePersistentEntity = runtimePersistentEntity;
        this.parent = parent;
        this.codecRegistry = codecRegistry;
    }

    public ConversionService<?> getConversionService() {
        return this.parent.getConversionService();
    }

    public boolean hasView(Class<?> ... views) {
        return this.parent.hasView((Class[])views);
    }

    public <B, P> SerializationReference<B, P> resolveReference(SerializationReference<B, P> reference) {
        return this.parent.resolveReference(reference);
    }

    public <T, D extends Serializer<? extends T>> D findCustomSerializer(Class<? extends D> serializerClass) throws SerdeException {
        if (serializerClass == IdSerializer.class) {
            IdSerializer idSerializer = new IdSerializer(){

                public Serializer<Object> createSpecific(Serializer.EncoderContext encoderContext, Argument<? extends Object> type) throws SerdeException {
                    boolean isGeneratedObjectIdAsString;
                    boolean bl = isGeneratedObjectIdAsString = type.isAssignableFrom(String.class) && type.isAnnotationPresent(GeneratedValue.class);
                    if (isGeneratedObjectIdAsString) {
                        Serializer objectIdSerializer = DataEncoderContext.this.findSerializer(DataEncoderContext.this.OBJECT_ID);
                        return (encoder, encoderContext2, stringType, value) -> {
                            String stringId = (String)value;
                            objectIdSerializer.serialize(encoder, encoderContext2, DataEncoderContext.this.OBJECT_ID, (Object)new ObjectId(stringId));
                        };
                    }
                    Serializer<? extends Object> serializer = DataEncoderContext.this.findSerializer(type);
                    return serializer.createSpecific(encoderContext, type);
                }

                public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<?> type, Object value) {
                    throw new IllegalStateException("Create specific call is required!");
                }
            };
            return (D)idSerializer;
        }
        if (serializerClass == CustomConverterSerializer.class) {
            CustomConverterSerializer customConverterSerializer = new CustomConverterSerializer(){

                public Serializer<Object> createSpecific(Serializer.EncoderContext encoderContext, Argument<?> type) throws SerdeException {
                    Class converterClass = (Class)type.getAnnotationMetadata().classValue(MappedProperty.class, "converter").orElseThrow(IllegalStateException::new);
                    Class converterPersistedType = (Class)type.getAnnotationMetadata().classValue(MappedProperty.class, "converterPersistedType").orElseThrow(IllegalStateException::new);
                    final Argument convertedType = Argument.of((Class)converterPersistedType);
                    final Serializer serializer = DataEncoderContext.this.findSerializer(convertedType);
                    final AttributeConverter converter = DataEncoderContext.this.attributeConverterRegistry.getConverter(converterClass);
                    return new Serializer<Object>(){

                        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<?> type, Object value) throws IOException {
                            if (value == null) {
                                encoder.encodeNull();
                                return;
                            }
                            Object converted = converter.convertToPersistedValue(value, (ConversionContext)ConversionContext.of(type));
                            if (converted == null) {
                                encoder.encodeNull();
                                return;
                            }
                            serializer.serialize(encoder, context, convertedType, converted);
                        }
                    };
                }

                public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<?> type, Object value) {
                    throw new IllegalStateException("Create specific call is required!");
                }
            };
            return (D)customConverterSerializer;
        }
        return (D)this.parent.findCustomSerializer(serializerClass);
    }

    public <T> Serializer<? super T> findSerializer(Argument<? extends T> type) throws SerdeException {
        Codec codec = this.codecRegistry.get(type.getType(), this.codecRegistry);
        if (codec instanceof MappedCodec) {
            return ((MappedCodec)codec).serializer;
        }
        if (codec != null && !(codec instanceof IterableCodec)) {
            return new CodecBsonDecoder(codec);
        }
        return this.parent.findSerializer(type);
    }

    public <D extends PropertyNamingStrategy> D findNamingStrategy(Class<? extends D> namingStrategyClass) throws SerdeException {
        if (namingStrategyClass == IdPropertyNamingStrategy.class) {
            return (D)DataSerdeRegistry.ID_PROPERTY_NAMING_STRATEGY;
        }
        return (D)this.parent.findNamingStrategy(namingStrategyClass);
    }

    public <B, P> void pushManagedRef(PropertyReference<B, P> reference) {
        this.parent.pushManagedRef(reference);
    }

    public void popManagedRef() {
        this.parent.popManagedRef();
    }
}

