/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.database;

import com.mongodb.ConnectionString;
import com.mongodb.reactivestreams.client.MongoClient;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.configuration.mongo.core.DefaultMongoConfiguration;
import io.micronaut.configuration.mongo.core.NamedMongoConfiguration;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.mongodb.conf.RequiresReactiveMongo;
import io.micronaut.data.mongodb.database.ReactiveMongoDatabaseFactory;
import io.micronaut.data.mongodb.database.SimpleReactiveMongoDatabaseFactory;
import io.micronaut.data.mongodb.database.UnknownReactiveMongoDatabaseFactory;
import io.micronaut.data.mongodb.operations.DefaultReactiveMongoRepositoryOperations;
import io.micronaut.data.mongodb.operations.MongoRepositoryOperations;
import io.micronaut.data.operations.HintsCapableRepository;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.reactive.BlockingReactorRepositoryOperations;
import io.micronaut.data.operations.reactive.ReactorReactiveRepositoryOperations;
import io.micronaut.data.runtime.operations.ExecutorAsyncOperations;
import io.micronaut.data.runtime.query.PreparedQueryResolver;
import io.micronaut.data.runtime.query.StoredQueryResolver;
import io.micronaut.inject.ExecutableMethod;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@RequiresReactiveMongo
@Internal
@Factory
final class MongoReactiveFactory {
    MongoReactiveFactory() {
    }

    @Primary
    @Singleton
    ReactiveMongoDatabaseFactory primaryMongoDatabaseFactory(DefaultMongoConfiguration mongoConfiguration, @Primary MongoClient mongoClient) {
        return mongoConfiguration.getConnectionString().map(ConnectionString::getDatabase).filter(StringUtils::isNotEmpty).map(databaseName -> new SimpleReactiveMongoDatabaseFactory(mongoClient, (String)databaseName)).orElseGet(UnknownReactiveMongoDatabaseFactory::new);
    }

    @EachBean(value=NamedMongoConfiguration.class)
    @Singleton
    ReactiveMongoDatabaseFactory namedMongoDatabaseFactory(NamedMongoConfiguration mongoConfiguration, @Parameter MongoClient mongoClient) {
        return mongoConfiguration.getConnectionString().map(ConnectionString::getDatabase).filter(StringUtils::isNotEmpty).map(databaseName -> new SimpleReactiveMongoDatabaseFactory(mongoClient, (String)databaseName)).orElseGet(UnknownReactiveMongoDatabaseFactory::new);
    }

    @EachBean(value=DefaultReactiveMongoRepositoryOperations.class)
    @Singleton
    MongoRepositoryOperations syncOperations(DefaultReactiveMongoRepositoryOperations reactiveOperations) {
        return new MongoReactiveBlockingRepositoryOperations(reactiveOperations);
    }

    private static final class MongoReactiveBlockingRepositoryOperations
    implements MongoRepositoryOperations,
    BlockingReactorRepositoryOperations,
    AsyncCapableRepository,
    HintsCapableRepository,
    StoredQueryResolver,
    PreparedQueryResolver {
        private final DefaultReactiveMongoRepositoryOperations reactiveOperations;
        private ExecutorService executorService;
        private ExecutorAsyncOperations asyncOperations;

        private MongoReactiveBlockingRepositoryOperations(DefaultReactiveMongoRepositoryOperations reactiveOperations) {
            this.reactiveOperations = reactiveOperations;
        }

        public ConversionService<?> getConversionService() {
            return this.reactiveOperations.getConversionService();
        }

        public Map<String, Object> getQueryHints(StoredQuery<?, ?> storedQuery) {
            return this.reactiveOperations.getQueryHints(storedQuery);
        }

        public ReactorReactiveRepositoryOperations reactive() {
            return this.reactiveOperations;
        }

        public ApplicationContext getApplicationContext() {
            return this.reactiveOperations.getApplicationContext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public ExecutorAsyncOperations async() {
            ExecutorAsyncOperations asyncOperations = this.asyncOperations;
            if (asyncOperations == null) {
                MongoReactiveBlockingRepositoryOperations mongoReactiveBlockingRepositoryOperations = this;
                synchronized (mongoReactiveBlockingRepositoryOperations) {
                    asyncOperations = this.asyncOperations;
                    if (asyncOperations == null) {
                        if (this.executorService == null) {
                            this.executorService = Executors.newCachedThreadPool();
                        }
                        this.asyncOperations = asyncOperations = new ExecutorAsyncOperations((RepositoryOperations)this, (Executor)this.executorService);
                    }
                }
            }
            return asyncOperations;
        }

        public <E, R> PreparedQuery<E, R> resolveQuery(MethodInvocationContext<?, ?> context, StoredQuery<E, R> storedQuery, Pageable pageable) {
            return this.reactiveOperations.resolveQuery((MethodInvocationContext)context, (StoredQuery)storedQuery, pageable);
        }

        public <E, R> PreparedQuery<E, R> resolveCountQuery(MethodInvocationContext<?, ?> context, StoredQuery<E, R> storedQuery, Pageable pageable) {
            return this.reactiveOperations.resolveCountQuery((MethodInvocationContext)context, (StoredQuery)storedQuery, pageable);
        }

        public <E, R> StoredQuery<E, R> resolveQuery(MethodInvocationContext<?, ?> context, Class<E> entityClass, Class<R> resultType) {
            return this.reactiveOperations.resolveQuery((MethodInvocationContext)context, (Class)entityClass, (Class)resultType);
        }

        public <E, R> StoredQuery<E, R> resolveCountQuery(MethodInvocationContext<?, ?> context, Class<E> entityClass, Class<R> resultType) {
            return this.reactiveOperations.resolveCountQuery((MethodInvocationContext)context, (Class)entityClass, (Class)resultType);
        }

        public <E, QR> StoredQuery<E, QR> createStoredQuery(ExecutableMethod<?, ?> executableMethod, DataMethod.OperationType operationType, String name, AnnotationMetadata annotationMetadata, Class<Object> rootEntity, String query, String update, String[] queryParts, List<QueryParameterBinding> queryParameters, boolean hasPageable, boolean isSingleResult) {
            return this.reactiveOperations.createStoredQuery((ExecutableMethod)executableMethod, operationType, name, annotationMetadata, (Class)rootEntity, query, update, queryParts, (List)queryParameters, hasPageable, isSingleResult);
        }

        public StoredQuery<Object, Long> createCountStoredQuery(ExecutableMethod<?, ?> executableMethod, DataMethod.OperationType operationType, String name, AnnotationMetadata annotationMetadata, Class<Object> rootEntity, String query, String[] queryParts, List<QueryParameterBinding> queryParameters) {
            return this.reactiveOperations.createCountStoredQuery((ExecutableMethod)executableMethod, operationType, name, annotationMetadata, (Class)rootEntity, query, queryParts, (List)queryParameters);
        }
    }
}

