/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.operations;

import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CollationAlternate;
import com.mongodb.client.model.CollationCaseFirst;
import com.mongodb.client.model.CollationMaxVariable;
import com.mongodb.client.model.CollationStrength;
import com.mongodb.client.model.Filters;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.serde.config.annotation.SerdeConfig;
import java.util.Date;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.annotations.BsonRepresentation;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

@Internal
public final class MongoUtils {
    public static final String ID = "_id";

    public static Collation bsonDocumentAsCollation(@Nullable BsonDocument collationDocument) {
        BsonValue backwards;
        BsonValue normalization;
        BsonValue maxVariable;
        BsonValue alternate;
        BsonValue numericOrdering;
        BsonValue strength;
        BsonValue caseFirst;
        BsonValue caseLevel;
        if (collationDocument == null) {
            return null;
        }
        Collation.Builder builder = Collation.builder();
        BsonValue locale = collationDocument.get((Object)"locale");
        if (locale != null) {
            builder.locale(locale.asString().getValue());
        }
        if ((caseLevel = collationDocument.get((Object)"caseLevel")) != null) {
            builder.caseLevel(Boolean.valueOf(caseLevel.asBoolean().getValue()));
        }
        if ((caseFirst = collationDocument.get((Object)"caseFirst")) != null) {
            builder.collationCaseFirst(CollationCaseFirst.valueOf((String)caseFirst.asString().getValue()));
        }
        if ((strength = collationDocument.get((Object)"strength")) != null) {
            builder.collationStrength(CollationStrength.valueOf((String)strength.asString().getValue()));
        }
        if ((numericOrdering = collationDocument.get((Object)"numericOrdering")) != null) {
            builder.numericOrdering(Boolean.valueOf(numericOrdering.asBoolean().getValue()));
        }
        if ((alternate = collationDocument.get((Object)"alternate")) != null) {
            builder.collationAlternate(CollationAlternate.valueOf((String)alternate.asString().getValue()));
        }
        if ((maxVariable = collationDocument.get((Object)"maxVariable")) != null) {
            builder.collationMaxVariable(CollationMaxVariable.valueOf((String)maxVariable.asString().getValue()));
        }
        if ((normalization = collationDocument.get((Object)"normalization")) != null) {
            builder.normalization(Boolean.valueOf(normalization.asBoolean().getValue()));
        }
        if ((backwards = collationDocument.get((Object)"backwards")) != null) {
            builder.backwards(Boolean.valueOf(backwards.asBoolean().getValue()));
        }
        return builder.build();
    }

    public static BsonValue entityIdValue(ConversionService<?> conversionService, RuntimePersistentEntity<?> persistentEntity, Object entity, CodecRegistry codecRegistry) {
        RuntimePersistentProperty identity = persistentEntity.getIdentity();
        if (identity != null) {
            BeanProperty property = identity.getProperty();
            return MongoUtils.idValue(conversionService, persistentEntity, property.get(entity), codecRegistry);
        }
        throw new IllegalStateException("Cannot determine id!");
    }

    public static BsonValue idValue(ConversionService<?> conversionService, RuntimePersistentEntity<?> persistentEntity, Object idValue, CodecRegistry codecRegistry) {
        RuntimePersistentProperty identity = persistentEntity.getIdentity();
        if (identity != null) {
            if (identity instanceof Association) {
                return MongoUtils.toBsonValue(conversionService, idValue, codecRegistry);
            }
            AnnotationValue bsonRepresentation = identity.getAnnotationMetadata().getAnnotation(BsonRepresentation.class);
            if (bsonRepresentation != null) {
                BsonType bsonType = (BsonType)bsonRepresentation.getRequiredValue(BsonType.class);
                return MongoUtils.toBsonValue(conversionService, bsonType, idValue);
            }
            BeanProperty property = identity.getProperty();
            Class type = property.getType();
            if (type == String.class && idValue != null) {
                return new BsonObjectId(new ObjectId(idValue.toString()));
            }
            return MongoUtils.toBsonValue(conversionService, idValue, codecRegistry);
        }
        throw new IllegalStateException("Cannot determine id!");
    }

    static Bson filterById(ConversionService<?> conversionService, RuntimePersistentEntity<?> persistentEntity, Object value, CodecRegistry codecRegistry) {
        BsonValue id = MongoUtils.idValue(conversionService, persistentEntity, value, codecRegistry);
        return new BsonDocument().append(ID, id);
    }

    static Bson filterByEntityId(ConversionService<?> conversionService, RuntimePersistentEntity<?> persistentEntity, Object entity, CodecRegistry codecRegistry) {
        BsonValue id = MongoUtils.entityIdValue(conversionService, persistentEntity, entity, codecRegistry);
        return new BsonDocument().append(ID, id);
    }

    static Bson filterByIdAndVersion(ConversionService<?> conversionService, RuntimePersistentEntity persistentEntity, Object entity, CodecRegistry codecRegistry) {
        RuntimePersistentProperty version = persistentEntity.getVersion();
        if (version != null) {
            return Filters.and((Bson[])new Bson[]{MongoUtils.filterByEntityId(conversionService, persistentEntity, entity, codecRegistry), Filters.eq((String)MongoUtils.getPropertyPersistName((PersistentProperty)version), (Object)version.getProperty().get(entity))});
        }
        return MongoUtils.filterByEntityId(conversionService, persistentEntity, entity, codecRegistry);
    }

    private static String getPropertyPersistName(PersistentProperty property) {
        return property.getAnnotationMetadata().stringValue(SerdeConfig.class, "property").orElseGet(() -> ((PersistentProperty)property).getName());
    }

    static <T> T toValue(BsonDocument bsonDocument, Class<T> resultClass, CodecRegistry codecRegistry) {
        return (T)codecRegistry.get(resultClass).decode(bsonDocument.asBsonReader(), DecoderContext.builder().build());
    }

    static Object toValue(BsonValue bsonValue) {
        switch (bsonValue.getBsonType()) {
            case STRING: {
                return bsonValue.asString().getValue();
            }
            case INT32: {
                return bsonValue.asInt32().getValue();
            }
            case INT64: {
                return bsonValue.asInt64().getValue();
            }
            case DOUBLE: {
                return bsonValue.asDouble().getValue();
            }
            case DECIMAL128: {
                return bsonValue.asDecimal128().getValue();
            }
            case BOOLEAN: {
                return bsonValue.asBoolean().getValue();
            }
            case NULL: {
                return null;
            }
        }
        throw new IllegalStateException("Not implemented for: " + bsonValue.getBsonType());
    }

    public static BsonValue toBsonValue(ConversionService<?> conversionService, Object value, CodecRegistry codecRegistry) {
        if (value == null) {
            return BsonNull.VALUE;
        }
        if (value instanceof String) {
            return new BsonString((String)value);
        }
        if (value instanceof Integer) {
            return new BsonInt32(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new BsonInt64(((Long)value).longValue());
        }
        if (value instanceof ObjectId) {
            return new BsonObjectId((ObjectId)value);
        }
        return BsonDocumentWrapper.asBsonDocument((Object)value, (CodecRegistry)codecRegistry).toBsonDocument();
    }

    static BsonValue toBsonValue(ConversionService<?> conversionService, BsonType bsonType, Object value) {
        switch (bsonType) {
            case STRING: {
                return new BsonString(value.toString());
            }
            case OBJECT_ID: {
                if (value instanceof String) {
                    return new BsonObjectId(new ObjectId((String)value));
                }
                if (value instanceof byte[]) {
                    return new BsonObjectId(new ObjectId((byte[])value));
                }
                if (value instanceof Date) {
                    return new BsonObjectId(new ObjectId((Date)value));
                }
                return new BsonObjectId((ObjectId)conversionService.convertRequired(value, ObjectId.class));
            }
        }
        throw new IllegalStateException("Bson conversion to: " + bsonType + " is missing!");
    }
}

