/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.init;

import com.mongodb.client.MongoDatabase;
import io.micronaut.configuration.mongo.core.AbstractMongoConfiguration;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.mongodb.conf.RequiresSyncMongo;
import io.micronaut.data.mongodb.database.MongoDatabaseFactory;
import io.micronaut.data.mongodb.init.AbstractMongoCollectionsCreator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;

@Context
@Internal
@RequiresSyncMongo
@Requires(property="micronaut.data.mongodb.create-collections", value="true")
public final class MongoCollectionsCreator
extends AbstractMongoCollectionsCreator<MongoDatabase> {
    @PostConstruct
    void initialize(BeanLocator beanLocator, RuntimeEntityRegistry runtimeEntityRegistry, List<AbstractMongoConfiguration> mongoConfigurations) {
        super.initialize(runtimeEntityRegistry, mongoConfigurations, (AbstractMongoConfiguration mongoConfiguration) -> {
            final MongoDatabaseFactory mongoDatabaseFactory = this.getMongoFactory(MongoDatabaseFactory.class, beanLocator, mongoConfiguration);
            final HashMap databaseCollections = new HashMap();
            return new AbstractMongoCollectionsCreator.DatabaseOperations<MongoDatabase>(){

                @Override
                public String getDatabaseName(MongoDatabase database) {
                    return database.getName();
                }

                @Override
                public MongoDatabase find(PersistentEntity persistentEntity) {
                    return mongoDatabaseFactory.getDatabase(persistentEntity);
                }

                @Override
                public Set<String> listCollectionNames(MongoDatabase database) {
                    return databaseCollections.computeIfAbsent(database.getName(), s -> (HashSet)database.listCollectionNames().into(new HashSet()));
                }

                @Override
                public void createCollection(MongoDatabase database, String collection) {
                    database.createCollection(collection);
                }
            };
        });
    }
}

