/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.transaction;

import com.mongodb.client.ClientSession;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.mongodb.transaction.MongoSynchronousTransactionManager;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.transaction.exceptions.NoTransactionException;

@Prototype
public final class TransactionalClientSessionInterceptor
implements MethodInterceptor<ClientSession, Object> {
    private final MongoSynchronousTransactionManager transactionManager;

    @Internal
    TransactionalClientSessionInterceptor(MongoSynchronousTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public Object intercept(MethodInvocationContext<ClientSession, Object> context) {
        ClientSession clientSession = this.transactionManager.findClientSession();
        if (clientSession == null) {
            throw new NoTransactionException("No current transaction present. Consider declaring @Transactional on the surrounding method");
        }
        ExecutableMethod method = context.getExecutableMethod();
        if (method.getName().equals("close")) {
            this.transactionManager.closeClientSession();
            return null;
        }
        return method.invoke((Object)clientSession, context.getParameterValues());
    }
}

