/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.serde;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.mongodb.serde.DataSerdeRegistry;
import io.micronaut.data.mongodb.serde.MappedCodec;
import io.micronaut.data.mongodb.serde.MappedEntityCodec;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;

@Internal
@Singleton
final class DataCodecRegistry
implements CodecRegistry {
    private final DataSerdeRegistry dataSerdeRegistry;
    private final RuntimeEntityRegistry runtimeEntityRegistry;
    private final Map<Class, Codec> codecs = new ConcurrentHashMap<Class, Codec>();

    DataCodecRegistry(DataSerdeRegistry dataSerdeRegistry, RuntimeEntityRegistry runtimeEntityRegistry) {
        this.dataSerdeRegistry = dataSerdeRegistry;
        this.runtimeEntityRegistry = runtimeEntityRegistry;
    }

    public <T> Codec<T> get(Class<T> clazz) {
        throw new CodecConfigurationException("Not supported");
    }

    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        MappedCodec codec = this.codecs.get(clazz);
        if (codec != null) {
            return codec;
        }
        if (BeanIntrospector.SHARED.findIntrospection(clazz).isPresent()) {
            RuntimePersistentEntity entity = this.runtimeEntityRegistry.getEntity(clazz);
            codec = entity.isAnnotationPresent(MappedEntity.class) ? new MappedEntityCodec<T>(this.dataSerdeRegistry, entity, clazz, registry) : new MappedCodec<T>(this.dataSerdeRegistry, entity, clazz, registry);
            this.codecs.put(clazz, codec);
            return codec;
        }
        return null;
    }
}

