/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.jpa.criteria.IExpression;
import io.micronaut.data.model.jpa.criteria.IPredicate;
import io.micronaut.data.model.jpa.criteria.ISelection;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.QueryResultPersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.impl.predicate.ConjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.DisjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PersistentPropertyBinaryPredicate;
import io.micronaut.data.model.jpa.criteria.impl.query.QueryModelPredicateVisitor;
import io.micronaut.data.model.jpa.criteria.impl.query.QueryModelSelectionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.selection.CompoundSelection;
import io.micronaut.data.model.jpa.criteria.impl.util.Joiner;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryBuilder2;
import io.micronaut.data.model.query.builder.QueryResult;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.EntityType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

@Internal
public abstract class AbstractPersistentEntityCriteriaQuery<T>
implements PersistentEntityCriteriaQuery<T>,
QueryResultPersistentEntityCriteriaQuery {
    protected final CriteriaBuilder criteriaBuilder;
    protected final Class<T> resultType;
    protected Predicate predicate;
    protected Selection<?> selection;
    protected PersistentEntityRoot<?> entityRoot;
    protected List<Order> orders;
    protected int max = -1;
    protected int offset = 0;
    protected boolean forUpdate;
    protected boolean distinct;

    protected AbstractPersistentEntityCriteriaQuery(Class<T> resultType, CriteriaBuilder criteriaBuilder) {
        this.resultType = resultType;
        this.criteriaBuilder = criteriaBuilder;
    }

    @Override
    public QueryResult buildQuery(AnnotationMetadata annotationMetadata, QueryBuilder queryBuilder) {
        QueryBuilder2 queryBuilder2 = QueryResultPersistentEntityCriteriaQuery.findQueryBuilder2(queryBuilder);
        if (queryBuilder2 == null) {
            return queryBuilder.buildQuery(annotationMetadata, this.getQueryModel());
        }
        return this.buildQuery(annotationMetadata, queryBuilder2);
    }

    @Override
    public QueryResult buildQuery(AnnotationMetadata annotationMetadata, QueryBuilder2 queryBuilder) {
        SelectQueryDefinitionImpl definition = new SelectQueryDefinitionImpl(this.entityRoot.getPersistentEntity(), this.predicate, this.selection == null ? this.entityRoot : this.selection, this.calculateJoins(this.entityRoot.getPersistentEntity(), false), this.forUpdate, this.distinct, this.orders == null ? List.of() : this.orders, this.max, this.offset);
        return queryBuilder.buildSelect(annotationMetadata, definition);
    }

    @Override
    public QueryResult buildCountQuery(AnnotationMetadata annotationMetadata, QueryBuilder2 queryBuilder) {
        SelectQueryDefinitionImpl definition = new SelectQueryDefinitionImpl(this.entityRoot.getPersistentEntity(), this.predicate, (Selection<?>)this.criteriaBuilder.count(this.entityRoot), this.calculateJoins(this.entityRoot.getPersistentEntity(), true), false, this.distinct, List.of(), -1, -1);
        return queryBuilder.buildSelect(annotationMetadata, definition);
    }

    private Map<String, JoinPath> calculateJoins(PersistentEntity persistentEntity, boolean remapFetchJoins) {
        Joiner joiner = new Joiner();
        Object object = this.predicate;
        if (object instanceof IPredicate) {
            IPredicate predicateVisitable = (IPredicate)object;
            predicateVisitable.visitPredicate(joiner);
        }
        if ((object = this.selection) instanceof ISelection) {
            ISelection selectionVisitable = (ISelection)object;
            selectionVisitable.visitSelection(joiner);
            this.entityRoot.visitSelection(joiner);
        } else {
            this.entityRoot.visitSelection(joiner);
        }
        if (this.orders != null) {
            for (Order o : this.orders) {
                joiner.joinIfNeeded(CriteriaUtils.requireProperty(o.getExpression()));
            }
        }
        LinkedHashMap<String, JoinPath> joinPaths = new LinkedHashMap<String, JoinPath>();
        for (Map.Entry entry : joiner.getJoins().entrySet()) {
            String path;
            io.micronaut.data.model.PersistentPropertyPath propertyPath;
            Join.Type joinType = Optional.ofNullable(((Joiner.Joined)entry.getValue()).getType()).orElse(Join.Type.DEFAULT);
            if (remapFetchJoins) {
                switch (joinType) {
                    case INNER: 
                    case FETCH: {
                        Join.Type type = Join.Type.DEFAULT;
                        break;
                    }
                    case LEFT_FETCH: {
                        Join.Type type = Join.Type.LEFT;
                        break;
                    }
                    case RIGHT_FETCH: {
                        Join.Type type = Join.Type.RIGHT;
                        break;
                    }
                    default: {
                        Join.Type type = joinType = joinType;
                    }
                }
            }
            if ((propertyPath = persistentEntity.getPropertyPath(path = (String)entry.getKey())) == null) {
                throw new IllegalArgumentException("Invalid association path. Element [" + path + "] is not an association for [" + persistentEntity + "]");
            }
            Association[] associationPath = propertyPath.getProperty() instanceof Association ? (Association[])Stream.concat(propertyPath.getAssociations().stream(), Stream.of(propertyPath.getProperty())).toArray(Association[]::new) : propertyPath.getAssociations().toArray(new Association[0]);
            JoinPath jp = new JoinPath(path, associationPath, joinType, ((Joiner.Joined)entry.getValue()).getAlias());
            joinPaths.put((String)entry.getKey(), jp);
        }
        return joinPaths;
    }

    @Override
    @NonNull
    public QueryModel getQueryModel() {
        if (this.entityRoot == null) {
            throw new IllegalStateException("The root entity must be specified!");
        }
        QueryModel qm = QueryModel.from(this.entityRoot.getPersistentEntity());
        Joiner joiner = new Joiner();
        Selection<?> selection = this.predicate;
        if (selection instanceof IPredicate) {
            IPredicate predicateVisitable = (IPredicate)selection;
            predicateVisitable.visitPredicate(this.createPredicateVisitor(qm));
            predicateVisitable.visitPredicate(joiner);
        }
        if ((selection = this.selection) instanceof ISelection) {
            ISelection selectionVisitable = (ISelection)selection;
            selectionVisitable.visitSelection(new QueryModelSelectionVisitor(qm, this.distinct));
            selectionVisitable.visitSelection(joiner);
            this.entityRoot.visitSelection(joiner);
        } else {
            this.entityRoot.visitSelection(new QueryModelSelectionVisitor(qm, this.distinct));
            this.entityRoot.visitSelection(joiner);
        }
        if (this.orders != null && !this.orders.isEmpty()) {
            List<Sort.Order> sortOrders = this.orders.stream().map(o -> {
                PersistentPropertyPath propertyPath = CriteriaUtils.requireProperty(o.getExpression());
                joiner.joinIfNeeded(propertyPath);
                String name = propertyPath.getPathAsString();
                if (o.isAscending()) {
                    return Sort.Order.asc(name);
                }
                return Sort.Order.desc(name);
            }).toList();
            qm.sort(Sort.of(sortOrders));
        }
        for (Map.Entry<String, Joiner.Joined> e : joiner.getJoins().entrySet()) {
            qm.join(e.getKey(), Optional.ofNullable(e.getValue().getType()).orElse(Join.Type.DEFAULT), e.getValue().getAlias());
        }
        qm.max(this.max);
        qm.offset(this.offset);
        if (this.forUpdate) {
            qm.forUpdate();
        }
        return qm;
    }

    @NonNull
    protected QueryModelPredicateVisitor createPredicateVisitor(QueryModel queryModel) {
        return new QueryModelPredicateVisitor(queryModel);
    }

    @Override
    public PersistentEntityCriteriaQuery<T> max(int max) {
        this.max = max;
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> offset(int offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> forUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> select(Selection<? extends T> selection) {
        this.selection = Objects.requireNonNull(selection);
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> multiselect(Selection<?> ... selections) {
        Objects.requireNonNull(selections);
        this.selection = selections.length > 0 ? new CompoundSelection(Arrays.asList(selections)) : null;
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> multiselect(List<Selection<?>> selectionList) {
        Objects.requireNonNull(selectionList);
        this.selection = !selectionList.isEmpty() ? new CompoundSelection(selectionList) : null;
        return this;
    }

    @Override
    public abstract <X> PersistentEntityRoot<X> from(Class<X> var1);

    @Override
    public abstract <X> PersistentEntityRoot<X> from(PersistentEntity var1);

    @Override
    public <X> PersistentEntityRoot<X> from(EntityType<X> entity) {
        if (this.entityRoot != null) {
            throw new IllegalStateException("The root entity is already specified!");
        }
        return null;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> where(Expression<Boolean> restriction) {
        if (restriction instanceof ConjunctionPredicate) {
            ConjunctionPredicate conjunctionPredicate = (ConjunctionPredicate)restriction;
            this.predicate = conjunctionPredicate;
        } else {
            this.predicate = new ConjunctionPredicate(Collections.singleton((IExpression)restriction));
        }
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> where(Predicate ... restrictions) {
        Objects.requireNonNull(restrictions);
        this.predicate = restrictions.length > 0 ? (restrictions.length == 1 ? restrictions[0] : new ConjunctionPredicate(((Stream)Arrays.stream(restrictions).sequential()).map(x -> (IExpression)x).toList())) : null;
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> groupBy(Expression<?> ... grouping) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public PersistentEntityCriteriaQuery<T> groupBy(List<Expression<?>> grouping) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public PersistentEntityCriteriaQuery<T> having(Expression<Boolean> restriction) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public PersistentEntityCriteriaQuery<T> having(Predicate ... restrictions) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public PersistentEntityCriteriaQuery<T> orderBy(Order ... o) {
        this.orders = Arrays.asList(Objects.requireNonNull(o));
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> orderBy(List<Order> o) {
        this.orders = Objects.requireNonNull(o);
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public Set<Root<?>> getRoots() {
        if (this.entityRoot != null) {
            return Collections.singleton(this.entityRoot);
        }
        return Collections.emptySet();
    }

    public List<Expression<?>> getGroupList() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Predicate getGroupRestriction() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Class<T> getResultType() {
        return this.resultType;
    }

    public List<Order> getOrderList() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Set<ParameterExpression<?>> getParameters() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <U> Subquery<U> subquery(Class<U> type) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Selection<T> getSelection() {
        return this.selection;
    }

    public Predicate getRestriction() {
        return this.predicate;
    }

    public final boolean hasOnlyIdRestriction() {
        return this.isOnlyIdRestriction((Expression<?>)this.predicate);
    }

    private boolean isOnlyIdRestriction(Expression<?> predicate) {
        DisjunctionPredicate disjunctionPredicate;
        ConjunctionPredicate conjunctionPredicate;
        if (predicate instanceof PersistentPropertyBinaryPredicate) {
            PersistentPropertyBinaryPredicate pp = (PersistentPropertyBinaryPredicate)predicate;
            return pp.getProperty() == pp.getProperty().getOwner().getIdentity();
        }
        if (predicate instanceof ConjunctionPredicate && (conjunctionPredicate = (ConjunctionPredicate)predicate).getPredicates().size() == 1) {
            return this.isOnlyIdRestriction((Expression)conjunctionPredicate.getPredicates().iterator().next());
        }
        if (predicate instanceof DisjunctionPredicate && (disjunctionPredicate = (DisjunctionPredicate)predicate).getPredicates().size() == 1) {
            return this.isOnlyIdRestriction((Expression)disjunctionPredicate.getPredicates().iterator().next());
        }
        return false;
    }

    public final boolean hasVersionRestriction() {
        if (this.entityRoot.getPersistentEntity().getVersion() == null) {
            return false;
        }
        return CriteriaUtils.hasVersionPredicate(this.predicate);
    }

    @Internal
    private static final class SelectQueryDefinitionImpl
    extends BaseQueryDefinitionImpl
    implements QueryBuilder2.SelectQueryDefinition {
        private final Selection<?> selection;
        private final boolean isForUpdate;
        private final boolean isDistinct;
        private final List<Order> order;
        private final int limit;
        private final int offset;

        public SelectQueryDefinitionImpl(PersistentEntity persistentEntity, Predicate predicate, Selection<?> selection, Map<String, JoinPath> joinPaths, boolean isForUpdate, boolean isDistinct, List<Order> order, int limit, int offset) {
            super(persistentEntity, predicate, joinPaths);
            this.selection = selection;
            this.isForUpdate = isForUpdate;
            this.isDistinct = isDistinct;
            this.order = order;
            this.limit = limit;
            this.offset = offset;
        }

        @Override
        public Selection<?> selection() {
            return this.selection;
        }

        @Override
        public List<Order> order() {
            return this.order;
        }

        @Override
        public int limit() {
            return this.limit;
        }

        @Override
        public int offset() {
            return this.offset;
        }

        @Override
        public boolean isForUpdate() {
            return this.isForUpdate;
        }

        @Override
        public boolean isDistinct() {
            return this.isDistinct;
        }
    }

    @Internal
    static abstract class BaseQueryDefinitionImpl
    implements QueryBuilder2.BaseQueryDefinition {
        private final PersistentEntity persistentEntity;
        private final Predicate predicate;
        private final Map<String, JoinPath> joinPaths;

        protected BaseQueryDefinitionImpl(PersistentEntity persistentEntity, Predicate predicate, Map<String, JoinPath> joinPaths) {
            this.persistentEntity = persistentEntity;
            this.predicate = predicate;
            this.joinPaths = joinPaths;
        }

        @Override
        public PersistentEntity persistentEntity() {
            return this.persistentEntity;
        }

        @Override
        public Predicate predicate() {
            return this.predicate;
        }

        @Override
        public Collection<JoinPath> getJoinPaths() {
            return Collections.unmodifiableCollection(this.joinPaths.values());
        }

        @Override
        public Optional<JoinPath> getJoinPath(String path) {
            if (path != null) {
                return Optional.ofNullable(this.joinPaths.get(path));
            }
            return Optional.empty();
        }
    }
}

