/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.query;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.jpa.criteria.ISelection;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.expression.BinaryExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.FunctionExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.IdExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.LiteralExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.UnaryExpression;
import io.micronaut.data.model.jpa.criteria.impl.selection.AliasedSelection;
import io.micronaut.data.model.jpa.criteria.impl.selection.CompoundSelection;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.factory.Projections;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Selection;

@Internal
public final class QueryModelSelectionVisitor
implements SelectionVisitor {
    private final QueryModel queryModel;
    private final boolean distinct;
    private String alias;
    private boolean isCompound;

    public QueryModelSelectionVisitor(QueryModel queryModel, boolean distinct) {
        this.queryModel = queryModel;
        this.distinct = distinct;
    }

    @Override
    public void visit(PersistentPropertyPath<?> persistentPropertyPath) {
        if (this.distinct && !this.hasDistinctProjection()) {
            this.addProjection(Projections.distinct());
        }
        this.addProjection(Projections.property(persistentPropertyPath.getPathAsString(), this.isCompound));
    }

    @Override
    public void visit(UnaryExpression<?> unaryExpression) {
        this.addProjection(this.getProjection(unaryExpression));
    }

    private QueryModel.Projection getProjection(UnaryExpression<?> unaryExpression) {
        Expression<?> expression = unaryExpression.getExpression();
        switch (unaryExpression.getType()) {
            case SUM: {
                return Projections.sum(CriteriaUtils.requireProperty(expression).getPathAsString());
            }
            case AVG: {
                return Projections.avg(CriteriaUtils.requireProperty(expression).getPathAsString());
            }
            case MAX: {
                return Projections.max(CriteriaUtils.requireProperty(expression).getPathAsString());
            }
            case MIN: {
                return Projections.min(CriteriaUtils.requireProperty(expression).getPathAsString());
            }
            case COUNT: {
                if (expression instanceof PersistentEntityRoot) {
                    return Projections.count();
                }
                if (expression instanceof PersistentPropertyPath) {
                    return Projections.count();
                }
                throw new IllegalStateException("Illegal expression: " + expression + " for count selection!");
            }
            case COUNT_DISTINCT: {
                if (expression instanceof PersistentEntityRoot) {
                    return Projections.countDistinctRoot();
                }
                if (expression instanceof PersistentPropertyPath) {
                    PersistentPropertyPath persistentPropertyPath = (PersistentPropertyPath)expression;
                    return Projections.countDistinct(persistentPropertyPath.getPathAsString());
                }
                throw new IllegalStateException("Illegal expression: " + expression + " for count distinct selection!");
            }
        }
        throw new IllegalStateException("Unknown aggregation: " + unaryExpression.getExpression());
    }

    @Override
    public void visit(CompoundSelection<?> compoundSelection) {
        this.isCompound = true;
        for (Selection<?> selection : compoundSelection.getCompoundSelectionItems()) {
            if (selection instanceof ISelection) {
                ISelection selectionVisitable = (ISelection)selection;
                selectionVisitable.visitSelection(this);
                continue;
            }
            throw new IllegalStateException("Unknown selection object: " + selection);
        }
        this.isCompound = false;
    }

    @Override
    public void visit(PersistentEntityRoot<?> entityRoot) {
        if (this.isCompound) {
            throw new IllegalStateException("Entity root cannot be in compound selection!");
        }
        if (this.distinct) {
            this.addProjection(Projections.distinct());
        } else {
            this.addProjection(Projections.rootEntity());
        }
    }

    @Override
    public void visit(LiteralExpression<?> literalExpression) {
        this.addProjection(Projections.literal(literalExpression.getValue()));
    }

    @Override
    public void visit(IdExpression<?, ?> idExpression) {
        PersistentEntityRoot<?> root = idExpression.getRoot();
        PersistentEntity persistentEntity = root.getPersistentEntity();
        if (persistentEntity.hasCompositeIdentity()) {
            for (PersistentProperty persistentProperty : persistentEntity.getCompositeIdentity()) {
                if (this.distinct && !this.hasDistinctProjection()) {
                    this.addProjection(Projections.distinct());
                }
                this.addProjection(Projections.property(persistentProperty.getName()));
            }
        } else {
            PersistentProperty identity = persistentEntity.getIdentity();
            if (this.distinct && !this.hasDistinctProjection()) {
                this.addProjection(Projections.distinct());
            }
            this.addProjection(Projections.property(identity.getName()));
        }
    }

    @Override
    public void visit(AliasedSelection<?> aliasedSelection) {
        this.alias = aliasedSelection.getAlias();
        aliasedSelection.getSelection().visitSelection(this);
        this.alias = null;
    }

    @Override
    public void visit(FunctionExpression<?> functionExpression) {
        throw new IllegalStateException("Not supported expression: " + functionExpression);
    }

    @Override
    public void visit(BinaryExpression<?> binaryExpression) {
        throw new IllegalStateException("Not supported expression: " + binaryExpression);
    }

    private void addProjection(QueryModel.Projection projection) {
        if (projection instanceof QueryModel.PropertyProjection) {
            QueryModel.PropertyProjection propertyProjection = (QueryModel.PropertyProjection)projection;
            if (this.alias != null) {
                propertyProjection.setAlias(this.alias);
            }
        }
        this.queryModel.projections().add(projection);
    }

    private boolean hasDistinctProjection() {
        return this.queryModel.getProjections().stream().anyMatch(p -> p instanceof QueryModel.DistinctProjection);
    }
}

