/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.CursoredPageable;
import io.micronaut.data.model.DefaultCursoredPageable;
import io.micronaut.data.model.DefaultPageable;
import io.micronaut.data.model.Sort;
import io.micronaut.serde.annotation.Serdeable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@Serdeable
@Introspected
@JsonIgnoreProperties(ignoreUnknown=true)
public interface Pageable
extends Sort {
    public static final Pageable UNPAGED = new DefaultPageable(0, -1, Sort.UNSORTED, true);

    public int getNumber();

    public int getSize();

    default public Mode getMode() {
        return Mode.OFFSET;
    }

    default public Optional<Cursor> cursor() {
        return Optional.empty();
    }

    default public boolean requestTotal() {
        return true;
    }

    @JsonIgnore
    default public long getOffset() {
        int size = this.getSize();
        if (size < 0) {
            return 0L;
        }
        return (long)this.getNumber() * (long)size;
    }

    @NonNull
    default public Sort getSort() {
        return Sort.unsorted();
    }

    @NonNull
    default public Pageable next() {
        return this.getPageable(this.getNumber() + 1);
    }

    @NonNull
    default public Pageable previous() {
        return this.getPageable(this.getNumber() - 1);
    }

    private Pageable getPageable(int newNumber) {
        int size = this.getSize();
        if (size < 0) {
            return Pageable.from(0, size, this.getSort());
        }
        Pageable newPageable = newNumber < 0 ? Pageable.from(0, size, this.getSort()) : Pageable.from(newNumber, size, this.getSort());
        if (!this.requestTotal()) {
            newPageable = newPageable.withoutTotal();
        }
        return newPageable;
    }

    @JsonIgnore
    default public boolean isUnpaged() {
        return this.getSize() == -1;
    }

    @Override
    @NonNull
    default public Pageable order(@NonNull String propertyName) {
        Sort newSort = this.getSort().order(propertyName);
        return Pageable.from(this.getNumber(), this.getSize(), newSort);
    }

    @Override
    @JsonIgnore
    default public boolean isSorted() {
        return this.getSort().isSorted();
    }

    @Override
    @NonNull
    default public Pageable order(@NonNull Sort.Order order) {
        Sort newSort = this.getSort().order(order);
        return Pageable.from(this.getNumber(), this.getSize(), newSort);
    }

    @Override
    @NonNull
    default public Pageable order(@NonNull String propertyName, @NonNull Sort.Order.Direction direction) {
        Sort newSort = this.getSort().order(propertyName, direction);
        return Pageable.from(this.getNumber(), this.getSize(), newSort);
    }

    @Override
    @NonNull
    @JsonIgnore
    default public List<Sort.Order> getOrderBy() {
        return this.getSort().getOrderBy();
    }

    default public Pageable withTotal() {
        if (this.requestTotal()) {
            return this;
        }
        throw new UnsupportedOperationException("Changing requestTotal is not supported");
    }

    default public Pageable withoutTotal() {
        if (!this.requestTotal()) {
            return this;
        }
        throw new UnsupportedOperationException("Changing requestTotal is not supported");
    }

    @NonNull
    public static Pageable from(int page) {
        return new DefaultPageable(page, 10, null, true);
    }

    @NonNull
    public static Pageable from(int page, int size) {
        return new DefaultPageable(page, size, null, true);
    }

    @NonNull
    public static Pageable from(int page, int size, @Nullable Sort sort) {
        return new DefaultPageable(page, size, sort, true);
    }

    @Internal
    @JsonCreator
    @NonNull
    public static Pageable from(@JsonProperty(value="number") int page, @JsonProperty(value="size") int size, @JsonProperty(value="mode") @Nullable Mode mode, @JsonProperty(value="cursor") @Nullable Cursor cursor, @JsonProperty(value="sort") @Nullable Sort sort, @JsonProperty(value="requestTotal", defaultValue="true") boolean requestTotal) {
        if (mode == null || mode == Mode.OFFSET) {
            return new DefaultPageable(page, size, sort, requestTotal);
        }
        return new DefaultCursoredPageable(size, cursor, mode, page, sort == null ? UNSORTED : sort, requestTotal);
    }

    @NonNull
    public static Pageable from(Sort sort) {
        if (sort == null) {
            return UNPAGED;
        }
        return new DefaultPageable(0, -1, sort, true);
    }

    @NonNull
    public static Pageable unpaged() {
        return UNPAGED;
    }

    @NonNull
    public static CursoredPageable afterCursor(@NonNull Cursor cursor, int page, int size, @Nullable Sort sort) {
        if (sort == null) {
            sort = UNSORTED;
        }
        return new DefaultCursoredPageable(size, cursor, Mode.CURSOR_NEXT, page, sort, true);
    }

    @NonNull
    public static CursoredPageable beforeCursor(@NonNull Cursor cursor, int page, int size, @Nullable Sort sort) {
        if (sort == null) {
            sort = UNSORTED;
        }
        return new DefaultCursoredPageable(size, cursor, Mode.CURSOR_PREVIOUS, page, sort, true);
    }

    public static enum Mode {
        CURSOR_NEXT,
        CURSOR_PREVIOUS,
        OFFSET;

    }

    @Serdeable
    public static interface Cursor {
        public Object get(int var1);

        public List<Object> elements();

        public int size();

        public static Cursor of(Object ... elements) {
            return new DefaultCursoredPageable.DefaultCursor(Arrays.asList(elements));
        }

        @JsonCreator
        public static Cursor of(List<Object> elements) {
            return new DefaultCursoredPageable.DefaultCursor(elements);
        }
    }
}

