/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.predicate;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.jpa.criteria.impl.PredicateVisitor;
import io.micronaut.data.model.jpa.criteria.impl.predicate.AbstractPredicate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;

@Internal
public final class LikePredicate
extends AbstractPredicate {
    private final Expression<String> expression;
    private final Expression<String> pattern;
    @Nullable
    private final Expression<Character> escapeChar;
    private final boolean negated;
    private final boolean caseInsensitive;

    public LikePredicate(Expression<String> expression, Expression<String> pattern) {
        this(expression, pattern, null, false, false);
    }

    public LikePredicate(Expression<String> expression, Expression<String> pattern, Expression<Character> escapeChar, boolean negated) {
        this(expression, pattern, escapeChar, negated, false);
    }

    public LikePredicate(Expression<String> expression, Expression<String> pattern, Expression<Character> escapeChar, boolean negated, boolean caseInsensitive) {
        this.expression = expression;
        this.pattern = pattern;
        this.escapeChar = escapeChar;
        this.negated = negated;
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public Predicate not() {
        return new LikePredicate(this.expression, this.pattern, this.escapeChar, !this.negated);
    }

    public Expression<String> getExpression() {
        return this.expression;
    }

    public Expression<String> getPattern() {
        return this.pattern;
    }

    @Nullable
    public Expression<Character> getEscapeChar() {
        return this.escapeChar;
    }

    @Override
    public boolean isNegated() {
        return this.negated;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    public void visitPredicate(PredicateVisitor predicateVisitor) {
        predicateVisitor.visit(this);
    }
}

