/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.expression;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.jpa.criteria.IExpression;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;

@Internal
abstract class AbstractExpression<E>
implements IExpression<E> {
    @Nullable
    private final Class<E> expressionType;

    public AbstractExpression(@Nullable Class<E> expressionType) {
        this.expressionType = expressionType;
    }

    @Override
    public boolean isBoolean() {
        if (this.expressionType != null) {
            return CriteriaUtils.isBoolean(this.expressionType);
        }
        return false;
    }

    @Override
    public boolean isNumeric() {
        if (this.expressionType != null) {
            return CriteriaUtils.isNumeric(this.expressionType);
        }
        return true;
    }

    @Override
    public boolean isComparable() {
        if (this.expressionType != null) {
            return CriteriaUtils.isComparable(this.expressionType);
        }
        return false;
    }

    public Class<E> getJavaType() {
        return this.expressionType;
    }

    @Nullable
    public Class<E> getExpressionType() {
        return this.expressionType;
    }
}

