/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Embeddable;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.AssociationUtils;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.PersistentElement;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public interface PersistentEntity
extends PersistentElement {
    @NonNull
    public String getName();

    @NonNull
    public String getAliasName();

    default public boolean hasCompositeIdentity() {
        return this.getCompositeIdentity() != null;
    }

    default public boolean hasIdentity() {
        return this.getIdentity() != null;
    }

    @Nullable
    public PersistentProperty[] getCompositeIdentity();

    @Nullable
    public PersistentProperty getIdentity();

    @NonNull
    default public List<PersistentProperty> getIdentityProperties() {
        if (this.getIdentity() != null) {
            return List.of(this.getIdentity());
        }
        PersistentProperty[] compositeIdentity = this.getCompositeIdentity();
        if (compositeIdentity != null) {
            return List.of(compositeIdentity);
        }
        return List.of();
    }

    @Nullable
    public PersistentProperty getVersion();

    default public boolean isVersioned() {
        return this.getVersion() != null;
    }

    @NonNull
    public Collection<? extends PersistentProperty> getPersistentProperties();

    @NonNull
    default public Collection<? extends Association> getAssociations() {
        return this.getPersistentProperties().stream().filter(bp -> bp instanceof Association).map(bp -> (Association)bp).toList();
    }

    @NonNull
    default public Collection<Embedded> getEmbedded() {
        return this.getPersistentProperties().stream().filter(PersistentProperty::isEmbedded).map(p -> (Embedded)p).toList();
    }

    @Nullable
    public PersistentProperty getPropertyByName(String var1);

    @Nullable
    default public PersistentProperty getIdentityByName(String name) {
        PersistentProperty identity = this.getIdentity();
        if (identity != null && identity.getName().equals(name)) {
            return identity;
        }
        PersistentProperty[] compositeIdentities = this.getCompositeIdentity();
        if (compositeIdentities != null) {
            for (PersistentProperty compositeIdentity : compositeIdentities) {
                if (!compositeIdentity.getName().equals(name)) continue;
                return compositeIdentity;
            }
        }
        return null;
    }

    @NonNull
    public Collection<String> getPersistentPropertyNames();

    default public boolean isEmbeddable() {
        return this.getAnnotationMetadata().hasAnnotation(Embeddable.class);
    }

    @NonNull
    default public String getSimpleName() {
        return NameUtils.getSimpleName((String)this.getName());
    }

    @NonNull
    default public String getDecapitalizedName() {
        return NameUtils.decapitalize((String)this.getSimpleName());
    }

    public boolean isOwningEntity(PersistentEntity var1);

    @Nullable
    public PersistentEntity getParentEntity();

    default public Optional<String> getPath(String camelCasePath) {
        List<String> path = Arrays.stream(AssociationUtils.CAMEL_CASE_SPLIT_PATTERN.split(camelCasePath)).map(NameUtils::decapitalize).toList();
        if (CollectionUtils.isNotEmpty(path)) {
            Iterator<String> i = path.iterator();
            StringBuilder b = new StringBuilder();
            PersistentEntity currentEntity = this;
            String name = null;
            while (i.hasNext()) {
                PersistentProperty identity;
                PersistentProperty sp = currentEntity.getPropertyByName(name = name == null ? i.next() : name + NameUtils.capitalize((String)i.next()));
                if (sp == null && (identity = currentEntity.getIdentity()) != null) {
                    if (identity.getName().equals(name)) {
                        sp = identity;
                    } else if (identity instanceof Association) {
                        Association association = (Association)identity;
                        PersistentEntity idEntity = association.getAssociatedEntity();
                        sp = idEntity.getPropertyByName(name);
                    }
                }
                if (sp == null) continue;
                if (sp instanceof Association) {
                    Association association = (Association)sp;
                    b.append(name);
                    if (i.hasNext()) {
                        b.append('.');
                    }
                    currentEntity = association.getAssociatedEntity();
                    name = null;
                    continue;
                }
                if (i.hasNext()) continue;
                b.append(name);
            }
            return b.isEmpty() || b.charAt(b.length() - 1) == '.' ? Optional.empty() : Optional.of(b.toString());
        }
        return Optional.empty();
    }

    @NonNull
    default public PersistentEntity getRootEntity() {
        return this;
    }

    default public boolean isRoot() {
        return this.getRootEntity() == this;
    }

    default public Optional<PersistentProperty> getPropertyByPath(String path) {
        if (path.indexOf(46) == -1) {
            PersistentProperty identity;
            PersistentProperty pp = this.getPropertyByName(path);
            if (pp == null && (identity = this.getIdentity()) != null) {
                if (identity.getName().equals(path)) {
                    pp = identity;
                } else if (identity instanceof Embedded) {
                    Embedded embedded = (Embedded)identity;
                    PersistentEntity idEntity = embedded.getAssociatedEntity();
                    pp = idEntity.getPropertyByName(path);
                }
            }
            return Optional.ofNullable(pp);
        }
        String[] tokens = path.split("\\.");
        PersistentEntity startingEntity = this;
        PersistentProperty prop = null;
        for (String token : tokens) {
            prop = startingEntity.getPropertyByName(token);
            if (prop == null) {
                PersistentProperty identity = startingEntity.getIdentity();
                if (identity != null && identity.getName().equals(token)) {
                    prop = identity;
                } else {
                    return Optional.empty();
                }
            }
            if (!(prop instanceof Association)) continue;
            Association association = (Association)prop;
            startingEntity = association.getAssociatedEntity();
        }
        return Optional.ofNullable(prop);
    }

    @Nullable
    default public PersistentPropertyPath getPropertyPath(@NonNull String path) {
        if (path.indexOf(46) == -1) {
            return this.getPropertyPath(new String[]{path});
        }
        return this.getPropertyPath(StringUtils.splitOmitEmptyStringsList((CharSequence)path, (char)'.').toArray(new String[0]));
    }

    @Nullable
    default public PersistentPropertyPath getPropertyPath(@NonNull String[] propertyPath) {
        if (propertyPath.length == 0) {
            return null;
        }
        if (propertyPath.length == 1) {
            String propertyName = propertyPath[0];
            PersistentProperty pp = this.getPropertyByName(propertyName);
            if (pp == null) {
                PersistentProperty version;
                PersistentProperty identity = this.getIdentity();
                if (identity != null) {
                    Embedded embedded;
                    PersistentEntity idEntity;
                    if (identity.getName().equals(propertyName)) {
                        pp = identity;
                    } else if (identity instanceof Embedded && (pp = (idEntity = (embedded = (Embedded)identity).getAssociatedEntity()).getPropertyByName(propertyName)) != null) {
                        return PersistentPropertyPath.of(Collections.singletonList((Embedded)identity), pp, identity.getName() + "." + pp.getName());
                    }
                }
                if ((version = this.getVersion()) != null && version.getName().equals(propertyName)) {
                    pp = version;
                }
            }
            return pp == null ? null : PersistentPropertyPath.of(Collections.emptyList(), pp, propertyName);
        }
        ArrayList<Association> associations = new ArrayList<Association>(propertyPath.length - 1);
        PersistentEntity startingEntity = this;
        for (int i = 0; i < propertyPath.length - 1; ++i) {
            String propertyName = propertyPath[i];
            PersistentProperty prop = startingEntity.getPropertyByName(propertyName);
            if (!(prop instanceof Association)) {
                if (prop == null) {
                    return null;
                }
                throw new IllegalArgumentException("Invalid association path. Property [" + propertyName + "] of [" + startingEntity + "] is not an association in [" + String.join((CharSequence)".", propertyPath) + "]");
            }
            Association association = (Association)prop;
            startingEntity = association.getAssociatedEntity();
            associations.add(association);
        }
        PersistentProperty prop = startingEntity.getPropertyByName(propertyPath[propertyPath.length - 1]);
        if (prop == null) {
            return null;
        }
        return PersistentPropertyPath.of(associations, prop);
    }

    @NonNull
    public NamingStrategy getNamingStrategy();

    @NonNull
    public Optional<NamingStrategy> findNamingStrategy();

    @NonNull
    public static <T> RuntimePersistentEntity<T> of(@NonNull Class<T> type) {
        ArgumentUtils.requireNonNull((String)"type", type);
        return new RuntimePersistentEntity<T>(type);
    }

    @NonNull
    public static <T> RuntimePersistentEntity<T> of(@NonNull BeanIntrospection<T> introspection) {
        ArgumentUtils.requireNonNull((String)"introspection", introspection);
        return new RuntimePersistentEntity<T>(introspection);
    }
}

