/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface QueryResult {
    @NonNull
    public String getQuery();

    @Nullable
    default public String getUpdate() {
        return null;
    }

    @Nullable
    default public String getAggregate() {
        return null;
    }

    @NonNull
    public List<String> getQueryParts();

    @NonNull
    default public Map<String, String> getParameters() {
        return this.getParameterBindings().stream().collect(Collectors.toMap(QueryParameterBinding::getKey, p -> String.join((CharSequence)".", p.getPropertyPath())));
    }

    @NonNull
    default public Map<String, DataType> getParameterTypes() {
        return this.getParameterBindings().stream().collect(Collectors.toMap(p -> String.join((CharSequence)".", p.getPropertyPath()), QueryParameterBinding::getDataType, (d1, d2) -> d1));
    }

    public List<QueryParameterBinding> getParameterBindings();

    default public Map<String, String> getAdditionalRequiredParameters() {
        return Collections.emptyMap();
    }

    default public int getMax() {
        return -1;
    }

    default public long getOffset() {
        return 0L;
    }

    @NonNull
    default public Collection<JoinPath> getJoinPaths() {
        return Collections.emptyList();
    }

    @NonNull
    public static QueryResult of(final @NonNull String query, final @NonNull List<String> queryParts, final @NonNull List<QueryParameterBinding> parameterBindings, final @NonNull Map<String, String> additionalRequiredParameters) {
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        ArgumentUtils.requireNonNull((String)"parameterBindings", parameterBindings);
        ArgumentUtils.requireNonNull((String)"additionalRequiredParameters", additionalRequiredParameters);
        return new QueryResult(){

            @Override
            @NonNull
            public String getQuery() {
                return query;
            }

            @Override
            public List<String> getQueryParts() {
                return queryParts;
            }

            @Override
            public List<QueryParameterBinding> getParameterBindings() {
                return parameterBindings;
            }

            @Override
            public Map<String, String> getAdditionalRequiredParameters() {
                return additionalRequiredParameters;
            }
        };
    }

    @NonNull
    public static QueryResult of(final @NonNull String query, final @NonNull List<String> queryParts, final @NonNull List<QueryParameterBinding> parameterBindings) {
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        ArgumentUtils.requireNonNull((String)"parameterBindings", parameterBindings);
        return new QueryResult(){

            @Override
            @NonNull
            public String getQuery() {
                return query;
            }

            @Override
            public List<String> getQueryParts() {
                return queryParts;
            }

            @Override
            public List<QueryParameterBinding> getParameterBindings() {
                return parameterBindings;
            }
        };
    }

    @NonNull
    public static QueryResult of(@NonNull String query, @NonNull List<String> queryParts, @NonNull List<QueryParameterBinding> parameterBindings, @NonNull Map<String, String> additionalRequiredParameters, int max, long offset) {
        return QueryResult.of(query, queryParts, parameterBindings, additionalRequiredParameters, max, offset, Collections.emptyList());
    }

    @NonNull
    public static QueryResult of(final @NonNull String query, final @NonNull List<String> queryParts, final @NonNull List<QueryParameterBinding> parameterBindings, final @NonNull Map<String, String> additionalRequiredParameters, final int max, final long offset, final @Nullable Collection<JoinPath> joinPaths) {
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        ArgumentUtils.requireNonNull((String)"parameterBindings", parameterBindings);
        ArgumentUtils.requireNonNull((String)"additionalRequiredParameters", additionalRequiredParameters);
        return new QueryResult(){

            @Override
            public int getMax() {
                return max;
            }

            @Override
            public long getOffset() {
                return offset;
            }

            @Override
            @NonNull
            public String getQuery() {
                return query;
            }

            @Override
            public List<String> getQueryParts() {
                return queryParts;
            }

            @Override
            public List<QueryParameterBinding> getParameterBindings() {
                return parameterBindings;
            }

            @Override
            public Map<String, String> getAdditionalRequiredParameters() {
                return additionalRequiredParameters;
            }

            @Override
            public Collection<JoinPath> getJoinPaths() {
                return joinPaths;
            }
        };
    }

    @NonNull
    public static QueryResult of(final @NonNull String query, final @NonNull List<String> queryParts, final @NonNull List<QueryParameterBinding> parameterBindings, final int max, final long offset, final @Nullable Collection<JoinPath> joinPaths) {
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        ArgumentUtils.requireNonNull((String)"parameterBindings", parameterBindings);
        return new QueryResult(){

            @Override
            public int getMax() {
                return max;
            }

            @Override
            public long getOffset() {
                return offset;
            }

            @Override
            @NonNull
            public String getQuery() {
                return query;
            }

            @Override
            public List<String> getQueryParts() {
                return queryParts;
            }

            @Override
            public List<QueryParameterBinding> getParameterBindings() {
                return parameterBindings;
            }

            @Override
            public Collection<JoinPath> getJoinPaths() {
                return joinPaths;
            }
        };
    }
}

